/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.BalancePlan;
import org.apache.solr.cluster.placement.BalanceRequest;
import org.apache.solr.cluster.placement.DeleteCollectionRequest;
import org.apache.solr.cluster.placement.DeleteReplicasRequest;
import org.apache.solr.cluster.placement.DeleteShardsRequest;
import org.apache.solr.cluster.placement.ModificationRequest;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementModificationException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.ReplicaPlacement;
import org.apache.solr.common.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrderedNodePlacementPlugin
implements PlacementPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public List<PlacementPlan> computePlacements(Collection<PlacementRequest> requests, PlacementContext placementContext) throws PlacementException {
        ArrayList<PlacementPlan> placementPlans = new ArrayList<PlacementPlan>(requests.size());
        HashSet<Node> allNodes = new HashSet<Node>();
        HashSet<SolrCollection> allCollections = new HashSet<SolrCollection>();
        ArrayDeque<PendingPlacementRequest> pendingRequests = new ArrayDeque<PendingPlacementRequest>(requests.size());
        for (PlacementRequest placementRequest : requests) {
            PendingPlacementRequest pending = new PendingPlacementRequest(placementRequest);
            pendingRequests.add(pending);
            placementPlans.add(placementContext.getPlacementPlanFactory().createPlacementPlan(placementRequest, pending.getComputedPlacementSet()));
            allNodes.addAll(placementRequest.getTargetNodes());
            allCollections.add(placementRequest.getCollection());
        }
        Collection<WeightedNode> weightedNodes = this.getWeightedNodes(placementContext, allNodes, allCollections, true).values();
        while (!pendingRequests.isEmpty()) {
            PendingPlacementRequest pendingPlacementRequest = (PendingPlacementRequest)pendingRequests.poll();
            if (!pendingPlacementRequest.isPending()) continue;
            List nodesForRequest = weightedNodes.stream().filter(pendingPlacementRequest::isTargetingNode).collect(Collectors.toList());
            SolrCollection solrCollection = pendingPlacementRequest.getCollection();
            for (String shardName : pendingPlacementRequest.getPendingShards()) {
                for (Replica.ReplicaType replicaType : pendingPlacementRequest.getPendingReplicaTypes(shardName)) {
                    int replicaCount = pendingPlacementRequest.getPendingReplicas(shardName, replicaType);
                    if (log.isDebugEnabled()) {
                        log.debug("Placing {} replicas for Collection: {}, Shard: {}, ReplicaType: {}", new Object[]{replicaCount, solrCollection.getName(), shardName, replicaType});
                    }
                    Replica pr = OrderedNodePlacementPlugin.createProjectedReplica(solrCollection, shardName, replicaType, null);
                    NodeHeap nodesForReplicaType = new NodeHeap(n -> n.calcRelevantWeightWithReplica(pr));
                    nodesForRequest.stream().filter(n -> n.canAddReplica(pr)).forEach(nodesForReplicaType::add);
                    int replicasPlaced = 0;
                    boolean retryRequestLater = false;
                    while (!nodesForReplicaType.isEmpty() && replicasPlaced < replicaCount) {
                        WeightedNode node = nodesForReplicaType.poll();
                        if (!node.canAddReplica(pr)) {
                            log.debug("Node can no-longer add the given replica, move on to next node: {}", (Object)node);
                            continue;
                        }
                        int numWeightTies = nodesForReplicaType.peekTies();
                        if (!pendingRequests.isEmpty() && pendingPlacementRequest.canBeRequeued() && numWeightTies > replicaCount - replicasPlaced) {
                            log.debug("There is a tie for best weight. There are more options ({}) than replicas to place ({}), so try this placement request later: {}", new Object[]{numWeightTies, replicaCount - replicasPlaced, node});
                            retryRequestLater = true;
                            break;
                        }
                        log.debug("Node chosen to host replica: {}", (Object)node);
                        boolean needsToResortAll = node.addReplica(OrderedNodePlacementPlugin.createProjectedReplica(solrCollection, shardName, replicaType, node.getNode()));
                        pendingPlacementRequest.addPlacement(placementContext.getPlacementPlanFactory().createReplicaPlacement(solrCollection, shardName, node.getNode(), replicaType));
                        if (++replicasPlaced >= replicaCount) continue;
                        if (needsToResortAll) {
                            log.debug("Replica addition requires re-sorting of entire selection list");
                            nodesForReplicaType.resortAll();
                        }
                        if (!node.canAddReplica(pr)) continue;
                        nodesForReplicaType.add(node);
                    }
                    if (retryRequestLater || replicasPlaced >= replicaCount) continue;
                    throw new PlacementException(String.format(Locale.ROOT, "Not enough eligible nodes to place %d replica(s) of type %s for shard %s of collection %s. Only able to place %d replicas.", new Object[]{replicaCount, replicaType, shardName, solrCollection.getName(), replicasPlaced}));
                }
            }
            if (!pendingPlacementRequest.isPending()) continue;
            pendingPlacementRequest.requeue();
            pendingRequests.add(pendingPlacementRequest);
        }
        return placementPlans;
    }

    @Override
    public BalancePlan computeBalancing(BalanceRequest balanceRequest, PlacementContext placementContext) throws PlacementException {
        WeightedNode lowestWeight;
        HashMap<Replica, Node> replicaMovements = new HashMap<Replica, Node>();
        TreeSet<WeightedNode> orderedNodes = new TreeSet<WeightedNode>();
        orderedNodes.addAll(this.getWeightedNodes(placementContext, balanceRequest.getNodes(), placementContext.getCluster().collections(), true).values());
        HashMap newReplicaMovements = CollectionUtil.newHashMap((int)1);
        ArrayList<WeightedNode> traversedHighNodes = new ArrayList<WeightedNode>(orderedNodes.size() - 1);
        while (orderedNodes.size() > 1 && ((WeightedNode)orderedNodes.first()).calcWeight() < ((WeightedNode)orderedNodes.last()).calcWeight() && (lowestWeight = (WeightedNode)orderedNodes.pollFirst()) != null) {
            WeightedNode highestWeight;
            log.debug("Highest weighted node: {}", (Object)lowestWeight);
            newReplicaMovements.clear();
            block1: while (newReplicaMovements.isEmpty() && !orderedNodes.isEmpty() && ((WeightedNode)orderedNodes.last()).calcWeight() > lowestWeight.calcWeight() + 1 && (highestWeight = (WeightedNode)orderedNodes.pollLast()) != null) {
                log.debug("Highest weighted node: {}", (Object)highestWeight);
                traversedHighNodes.add(highestWeight);
                List availableReplicasToMove = highestWeight.getAllReplicasOnNode().stream().sorted(Comparator.comparing(Replica::getReplicaName)).collect(Collectors.toList());
                int combinedNodeWeights = highestWeight.calcWeight() + lowestWeight.calcWeight();
                for (Replica r : availableReplicasToMove) {
                    if (!highestWeight.canRemoveReplicas(Set.of(r)).isEmpty() || !lowestWeight.canAddReplica(r)) continue;
                    lowestWeight.addReplica(r);
                    highestWeight.removeReplica(r);
                    int lowestWeightWithReplica = lowestWeight.calcWeight();
                    int highestWeightWithoutReplica = highestWeight.calcWeight();
                    if (log.isDebugEnabled()) {
                        log.debug("Replica: {}, toNode weight with replica: {}, fromNode weight without replica: {}", new Object[]{r.getReplicaName(), lowestWeightWithReplica, highestWeightWithoutReplica});
                    }
                    if (highestWeightWithoutReplica + lowestWeightWithReplica >= combinedNodeWeights && highestWeightWithoutReplica < lowestWeightWithReplica) {
                        lowestWeight.removeReplica(r);
                        highestWeight.addReplica(r);
                        continue;
                    }
                    log.debug("Replica Movement chosen. From: {}, To: {}, Replica: {}", new Object[]{highestWeight, lowestWeight, r});
                    newReplicaMovements.put(r, lowestWeight.getNode());
                    continue block1;
                }
            }
            traversedHighNodes.addAll(orderedNodes);
            orderedNodes.clear();
            orderedNodes.addAll(traversedHighNodes);
            traversedHighNodes.clear();
            if (newReplicaMovements.size() <= 0) continue;
            replicaMovements.putAll(newReplicaMovements);
            orderedNodes.add(lowestWeight);
        }
        return placementContext.getBalancePlanFactory().createBalancePlan(balanceRequest, replicaMovements);
    }

    protected Map<Node, WeightedNode> getWeightedNodes(PlacementContext placementContext, Set<Node> nodes, Iterable<SolrCollection> relevantCollections, boolean skipNodesWithErrors) throws PlacementException {
        Map<Node, WeightedNode> weightedNodes = this.getBaseWeightedNodes(placementContext, nodes, relevantCollections, skipNodesWithErrors);
        for (SolrCollection collection : placementContext.getCluster().collections()) {
            for (Shard shard : collection.shards()) {
                for (Replica replica : shard.replicas()) {
                    WeightedNode weightedNode = weightedNodes.get(replica.getNode());
                    if (weightedNode == null) continue;
                    weightedNode.initReplica(replica);
                }
            }
        }
        return weightedNodes;
    }

    protected abstract Map<Node, WeightedNode> getBaseWeightedNodes(PlacementContext var1, Set<Node> var2, Iterable<SolrCollection> var3, boolean var4) throws PlacementException;

    @Override
    public void verifyAllowedModification(ModificationRequest modificationRequest, PlacementContext placementContext) throws PlacementException {
        if (modificationRequest instanceof DeleteShardsRequest) {
            log.warn("DeleteShardsRequest not implemented yet, skipping: {}", (Object)modificationRequest);
        } else if (modificationRequest instanceof DeleteCollectionRequest) {
            this.verifyDeleteCollection((DeleteCollectionRequest)modificationRequest, placementContext);
        } else if (modificationRequest instanceof DeleteReplicasRequest) {
            this.verifyDeleteReplicas((DeleteReplicasRequest)modificationRequest, placementContext);
        } else {
            log.warn("unsupported request type, skipping: {}", (Object)modificationRequest);
        }
    }

    protected void verifyDeleteCollection(DeleteCollectionRequest deleteCollectionRequest, PlacementContext placementContext) throws PlacementException {
    }

    protected void verifyDeleteReplicas(DeleteReplicasRequest deleteReplicasRequest, PlacementContext placementContext) throws PlacementException {
        Map<Node, List<Replica>> nodesRepresented = deleteReplicasRequest.getReplicas().stream().collect(Collectors.groupingBy(Replica::getNode));
        Map<Node, WeightedNode> weightedNodes = this.getWeightedNodes(placementContext, nodesRepresented.keySet(), placementContext.getCluster().collections(), false);
        PlacementModificationException placementModificationException = new PlacementModificationException("delete replica(s) rejected");
        for (Map.Entry<Node, List<Replica>> entry : nodesRepresented.entrySet()) {
            WeightedNode node = weightedNodes.get(entry.getKey());
            if (node == null) {
                entry.getValue().forEach(replica -> placementModificationException.addRejectedModification(replica.toString(), "could not load information for node: " + ((Node)entry.getKey()).getName()));
                continue;
            }
            node.canRemoveReplicas((Collection<Replica>)entry.getValue()).forEach((replica, reason) -> placementModificationException.addRejectedModification(replica.toString(), (String)reason));
        }
        if (!placementModificationException.getRejectedModifications().isEmpty()) {
            throw placementModificationException;
        }
    }

    static Replica createProjectedReplica(final SolrCollection collection, final String shardName, final Replica.ReplicaType type, final Node node) {
        final Shard shard = new Shard(){

            @Override
            public String getShardName() {
                return shardName;
            }

            @Override
            public SolrCollection getCollection() {
                return collection;
            }

            @Override
            public Replica getReplica(String name) {
                return null;
            }

            @Override
            public Iterator<Replica> iterator() {
                return null;
            }

            @Override
            public Iterable<Replica> replicas() {
                return null;
            }

            @Override
            public Replica getLeader() {
                return null;
            }

            @Override
            public Shard.ShardState getState() {
                return null;
            }

            public String toString() {
                return Optional.ofNullable(collection).map(SolrCollection::getName).orElse("<no collection>") + "/" + shardName;
            }
        };
        return new Replica(){

            @Override
            public Shard getShard() {
                return shard;
            }

            @Override
            public Replica.ReplicaType getType() {
                return type;
            }

            @Override
            public Replica.ReplicaState getState() {
                return Replica.ReplicaState.DOWN;
            }

            @Override
            public String getReplicaName() {
                return "";
            }

            @Override
            public String getCoreName() {
                return "";
            }

            @Override
            public Node getNode() {
                return node;
            }

            public String toString() {
                return Optional.ofNullable(shard).map(Shard::getShardName).orElse("<no shard>") + "@" + Optional.ofNullable(node).map(Node::getName).orElse("<no node>") + " of " + type;
            }
        };
    }

    static class PendingPlacementRequest {
        boolean hasBeenRequeued = false;
        final SolrCollection collection;
        final Set<Node> targetNodes;
        final Set<ReplicaPlacement> computedPlacements;
        final Map<String, Map<Replica.ReplicaType, Integer>> replicasToPlaceForShards;

        public PendingPlacementRequest(PlacementRequest request) {
            this.collection = request.getCollection();
            this.targetNodes = request.getTargetNodes();
            Set<String> shards = request.getShardNames();
            this.replicasToPlaceForShards = CollectionUtil.newHashMap((int)shards.size());
            int totalShardReplicas = 0;
            for (Replica.ReplicaType type : Replica.ReplicaType.values()) {
                int count = request.getCountReplicasToCreate(type);
                if (count <= 0) continue;
                totalShardReplicas += count;
                shards.forEach(s -> this.replicasToPlaceForShards.computeIfAbsent((String)s, sh -> CollectionUtil.newHashMap((int)3)).put(type, count));
            }
            this.computedPlacements = CollectionUtil.newHashSet((int)(totalShardReplicas * shards.size()));
        }

        public boolean isPending() {
            return !this.replicasToPlaceForShards.isEmpty();
        }

        public SolrCollection getCollection() {
            return this.collection;
        }

        public boolean isTargetingNode(WeightedNode node) {
            return this.targetNodes.contains(node.getNode());
        }

        public Set<ReplicaPlacement> getComputedPlacementSet() {
            return this.computedPlacements;
        }

        public Collection<String> getPendingShards() {
            return new ArrayList<String>(this.replicasToPlaceForShards.keySet());
        }

        public Collection<Replica.ReplicaType> getPendingReplicaTypes(String shard) {
            return Optional.ofNullable(this.replicasToPlaceForShards.get(shard)).map(Map::keySet).map(TreeSet::new).orElseGet(Collections::emptyList);
        }

        public int getPendingReplicas(String shard, Replica.ReplicaType type) {
            return Optional.ofNullable(this.replicasToPlaceForShards.get(shard)).map(m -> (Integer)m.get((Object)type)).orElse(0);
        }

        public boolean canBeRequeued() {
            return !this.hasBeenRequeued;
        }

        public void requeue() {
            this.hasBeenRequeued = true;
        }

        public void addPlacement(ReplicaPlacement replica) {
            this.computedPlacements.add(replica);
            this.replicasToPlaceForShards.computeIfPresent(replica.getShardName(), (shard, replicaTypes) -> {
                replicaTypes.computeIfPresent(replica.getReplicaType(), (type, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                if (replicaTypes.size() > 0) {
                    return replicaTypes;
                }
                return null;
            });
        }
    }

    private static class NodeHeap {
        final Function<WeightedNode, Integer> weightFunc;
        final TreeMap<Integer, Deque<WeightedNode>> nodesByWeight;
        Deque<WeightedNode> currentLowestList;
        int currentLowestWeight;
        int size = 0;

        protected NodeHeap(Function<WeightedNode, Integer> weightFunc) {
            this.weightFunc = weightFunc;
            this.nodesByWeight = new TreeMap();
            this.currentLowestList = null;
            this.currentLowestWeight = -1;
        }

        protected WeightedNode poll() {
            this.updateLowestWeightedList();
            if (this.currentLowestList == null || this.currentLowestList.isEmpty()) {
                return null;
            }
            --this.size;
            return this.currentLowestList.pollFirst();
        }

        protected int peekTies() {
            return this.currentLowestList == null ? 1 : this.currentLowestList.size() + 1;
        }

        private void updateLowestWeightedList() {
            this.recheckLowestWeights();
            while (this.currentLowestList == null || this.currentLowestList.isEmpty()) {
                Map.Entry<Integer, Deque<WeightedNode>> lowestEntry = this.nodesByWeight.pollFirstEntry();
                if (lowestEntry == null) {
                    this.currentLowestList = null;
                    this.currentLowestWeight = -1;
                    break;
                }
                this.currentLowestList = lowestEntry.getValue();
                this.currentLowestWeight = lowestEntry.getKey();
                this.recheckLowestWeights();
            }
        }

        private void recheckLowestWeights() {
            if (this.currentLowestList != null) {
                this.currentLowestList.removeIf(node -> {
                    if (this.weightFunc.apply((WeightedNode)node) != this.currentLowestWeight) {
                        log.debug("Node's sort is out-of-date, re-sorting: {}", node);
                        this.add((WeightedNode)node);
                        return true;
                    }
                    return false;
                });
            }
        }

        public void add(WeightedNode node) {
            ++this.size;
            int nodeWeight = this.weightFunc.apply(node);
            if (this.currentLowestWeight == nodeWeight) {
                this.currentLowestList.add(node);
            } else {
                this.nodesByWeight.computeIfAbsent(nodeWeight, w -> new ArrayDeque()).addLast(node);
            }
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void resortAll() {
            ArrayList<WeightedNode> temp = new ArrayList<WeightedNode>(this.size);
            if (this.currentLowestList != null) {
                temp.addAll(this.currentLowestList);
                this.currentLowestList.clear();
            }
            this.nodesByWeight.values().forEach(temp::addAll);
            this.currentLowestWeight = -1;
            this.nodesByWeight.clear();
            temp.forEach(this::add);
        }
    }

    public static abstract class WeightedNode
    implements Comparable<WeightedNode> {
        private final Node node;
        private final Map<String, Map<String, Set<Replica>>> replicas;
        private final Set<Replica> allReplicas;

        public WeightedNode(Node node) {
            this.node = node;
            this.replicas = new HashMap<String, Map<String, Set<Replica>>>();
            this.allReplicas = new HashSet<Replica>();
        }

        public Node getNode() {
            return this.node;
        }

        public Set<Replica> getAllReplicasOnNode() {
            return new HashSet<Replica>(this.allReplicas);
        }

        public int getAllReplicaCount() {
            return this.allReplicas.size();
        }

        public Set<String> getCollectionsOnNode() {
            return this.replicas.keySet();
        }

        public boolean hasCollectionOnNode(String collection) {
            return this.replicas.containsKey(collection);
        }

        public Set<String> getShardsOnNode(String collection) {
            return this.replicas.getOrDefault(collection, Collections.emptyMap()).keySet();
        }

        public boolean hasShardOnNode(Shard shard) {
            return this.replicas.getOrDefault(shard.getCollection().getName(), Collections.emptyMap()).containsKey(shard.getShardName());
        }

        public Set<Replica> getReplicasForShardOnNode(Shard shard) {
            return Optional.ofNullable(this.replicas.get(shard.getCollection().getName())).map(m -> (Set)m.get(shard.getShardName())).orElseGet(Collections::emptySet);
        }

        public abstract int calcWeight();

        public abstract int calcRelevantWeightWithReplica(Replica var1);

        public boolean canAddReplica(Replica replica) {
            return this.getReplicasForShardOnNode(replica.getShard()).isEmpty();
        }

        private boolean addReplicaToInternalState(Replica replica) {
            this.allReplicas.add(replica);
            return this.replicas.computeIfAbsent(replica.getShard().getCollection().getName(), k -> new HashMap()).computeIfAbsent(replica.getShard().getShardName(), k -> CollectionUtil.newHashSet((int)1)).add(replica);
        }

        public final void initReplica(Replica replica) {
            if (this.addReplicaToInternalState(replica)) {
                this.initReplicaWeights(replica);
            }
        }

        protected void initReplicaWeights(Replica replica) {
        }

        public final boolean addReplica(Replica replica) {
            if (this.addReplicaToInternalState(replica)) {
                return this.addProjectedReplicaWeights(replica);
            }
            return false;
        }

        protected abstract boolean addProjectedReplicaWeights(Replica var1);

        public Map<Replica, String> canRemoveReplicas(Collection<Replica> replicas) {
            return Collections.emptyMap();
        }

        public final void removeReplica(Replica replica) {
            AtomicBoolean hasReplica = new AtomicBoolean(false);
            this.replicas.computeIfPresent(replica.getShard().getCollection().getName(), (col, shardReps) -> {
                shardReps.computeIfPresent(replica.getShard().getShardName(), (shard, reps) -> {
                    if (reps.remove(replica)) {
                        hasReplica.set(true);
                        this.allReplicas.remove(replica);
                    }
                    return reps.isEmpty() ? null : reps;
                });
                return shardReps.isEmpty() ? null : shardReps;
            });
            if (hasReplica.get()) {
                this.removeProjectedReplicaWeights(replica);
            }
        }

        protected abstract void removeProjectedReplicaWeights(Replica var1);

        protected Comparable getTiebreaker() {
            return this.node.getName();
        }

        @Override
        public int compareTo(WeightedNode o) {
            int comp = Integer.compare(this.calcWeight(), o.calcWeight());
            if (comp == 0 && !this.equals(o)) {
                comp = this.getTiebreaker().compareTo(o.getTiebreaker());
            }
            return comp;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedNode)) {
                return false;
            }
            WeightedNode on = (WeightedNode)o;
            if (this.node == null) {
                return on.node == null;
            }
            return this.node.equals(on.node);
        }

        public String toString() {
            return "WeightedNode{node=" + this.node.getName() + ", weight=" + this.calcWeight() + "}";
        }
    }
}

