/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.filestore.FileStoreAPI;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DistribFileStore
implements FileStore {
    static final long MAX_PKG_SIZE = Long.parseLong(System.getProperty("max.file.store.size", String.valueOf(0x6400000)));
    static final String ZK_PACKAGESTORE = "/packagestore";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private Map<String, FileInfo> tmpFiles = new ConcurrentHashMap<String, FileInfo>();
    private final Path solrHome;

    public DistribFileStore(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.solrHome = Paths.get(this.coreContainer.getSolrHome(), new String[0]);
    }

    @Override
    public Path getRealpath(String path) {
        return DistribFileStore._getRealPath(path, this.solrHome);
    }

    private static Path _getRealPath(String path, Path solrHome) {
        if (File.separatorChar == '\\') {
            path = path.replace('/', File.separatorChar);
        }
        SolrPaths.assertNotUnc(Path.of(path, new String[0]));
        while (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        Path finalPath = DistribFileStore.getFileStoreDirPath(solrHome).resolve(path);
        if (!finalPath.normalize().startsWith(DistribFileStore.getFileStoreDirPath(solrHome).normalize())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal path " + path);
        }
        return finalPath;
    }

    @Override
    public void put(FileStore.FileEntry entry) throws IOException {
        FileInfo info = new FileInfo(entry.path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.writeJson((Object)entry.getMetaData(), (OutputStream)baos, (boolean)true);
        byte[] bytes = baos.toByteArray();
        info.persistToFile(entry.buf, ByteBuffer.wrap(bytes, 0, bytes.length));
        this.distribute(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distribute(FileInfo info) {
        try {
            String dirName = info.path.substring(0, info.path.lastIndexOf(47));
            this.coreContainer.getZkController().getZkClient().makePath(ZK_PACKAGESTORE + dirName, false, true);
            this.coreContainer.getZkController().getZkClient().create(ZK_PACKAGESTORE + info.path, info.getDetails().getMetaData().sha512.getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, true);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create an entry in ZK", (Throwable)e);
        }
        this.tmpFiles.put(info.path, info);
        ArrayList<String> nodes = this.coreContainer.getFileStoreAPI().shuffledNodes();
        int i = 0;
        int FETCHFROM_SRC = 50;
        String myNodeName = this.coreContainer.getZkController().getNodeName();
        try {
            for (String node : nodes) {
                String baseUrl = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(node);
                String url = baseUrl.replace("/solr", "/api") + "/node/files" + info.path + "?getFrom=";
                if (i < FETCHFROM_SRC) {
                    url = url + myNodeName;
                } else {
                    if (i == FETCHFROM_SRC) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    url = url + "*";
                }
                try {
                    Utils.executeGET((HttpClient)this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)url, null);
                }
                catch (Exception e) {
                    log.info("Node: {} failed to respond for file fetch notification", (Object)node, (Object)e);
                }
                ++i;
            }
        }
        finally {
            this.coreContainer.getUpdateShardHandler().getUpdateExecutor().submit(() -> {
                try {
                    Thread.sleep(10000L);
                }
                finally {
                    this.tmpFiles.remove(info.path);
                }
                return null;
            });
        }
    }

    @Override
    public boolean fetch(String path, String from) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        FileInfo f = new FileInfo(path);
        try {
            if (f.exists(true, false)) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("Error fetching file ", (Throwable)e);
            return false;
        }
        if (from == null || "*".equals(from)) {
            log.info("Missing file in package store: {}", (Object)path);
            if (f.fetchFromAnyNode()) {
                log.info("Successfully downloaded : {}", (Object)path);
                return true;
            }
            log.info("Unable to download file : {}", (Object)path);
            return false;
        }
        f.fetchFileFromNodeAndPersist(from);
        return false;
    }

    @Override
    public void get(String path, Consumer<FileStore.FileEntry> consumer, boolean fetchmissing) throws IOException {
        File file = this.getRealpath(path).toFile();
        String simpleName = file.getName();
        if (DistribFileStore.isMetaDataFile(simpleName)) {
            try (final FileInputStream is = new FileInputStream(file);){
                consumer.accept(new FileStore.FileEntry(null, null, path){

                    @Override
                    public InputStream getInputStream() {
                        return is;
                    }
                });
            }
            return;
        }
        new FileInfo(path).readData(consumer);
    }

    @Override
    public void syncToAllNodes(String path) throws IOException {
        FileInfo fi = new FileInfo(path);
        if (!fi.exists(true, false)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such file : " + path);
        }
        fi.getFileData(true);
        this.distribute(fi);
    }

    @Override
    public List<FileStore.FileDetails> list(String path, Predicate<String> predicate) {
        File file = this.getRealpath(path).toFile();
        ArrayList<FileStore.FileDetails> fileDetails = new ArrayList<FileStore.FileDetails>();
        FileStore.FileType type = this.getType(path, false);
        if (type == FileStore.FileType.DIRECTORY) {
            file.list((dir, name) -> {
                if ((predicate == null || predicate.test(name)) && !DistribFileStore.isMetaDataFile(name)) {
                    fileDetails.add(new FileInfo(path + "/" + name).getDetails());
                }
                return false;
            });
        } else if (type == FileStore.FileType.FILE) {
            fileDetails.add(new FileInfo(path).getDetails());
        }
        return fileDetails;
    }

    @Override
    public void delete(String path) {
        this.deleteLocal(path);
        ArrayList<String> nodes = this.coreContainer.getFileStoreAPI().shuffledNodes();
        HttpClient client = this.coreContainer.getUpdateShardHandler().getDefaultHttpClient();
        for (String node : nodes) {
            String baseUrl = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(node);
            String url = baseUrl.replace("/solr", "/api") + "/node/files" + path;
            HttpDelete del = new HttpDelete(url);
            this.coreContainer.runAsync(() -> Utils.executeHttpMethod((HttpClient)client, (String)url, null, (HttpRequestBase)del));
        }
    }

    private void checkInZk(String path) {
        try {
            if (this.coreContainer.getZkController().getZkClient().exists(ZK_PACKAGESTORE + path, true).booleanValue()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The path exist ZK, delete and retry");
            }
        }
        catch (SolrException se) {
            throw se;
        }
        catch (Exception e) {
            log.error("Could not connect to ZK", (Throwable)e);
        }
    }

    @Override
    public void deleteLocal(String path) {
        this.checkInZk(path);
        FileInfo f = new FileInfo(path);
        f.deleteFile();
    }

    @Override
    public void refresh(String path) {
        try {
            List l = null;
            try {
                l = this.coreContainer.getZkController().getZkClient().getChildren(ZK_PACKAGESTORE + path, null, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            if (l != null && !l.isEmpty()) {
                List<FileStore.FileDetails> myFiles = this.list(path, s -> true);
                for (Object f : l) {
                    if (myFiles.contains(f)) continue;
                    log.info("{} does not exist locally, downloading.. ", f);
                    this.fetch(path + "/" + f.toString(), "*");
                }
            }
        }
        catch (Exception e) {
            log.error("Could not refresh files in {}", (Object)path, (Object)e);
        }
    }

    @Override
    public FileStore.FileType getType(String path, boolean fetchMissing) {
        File file = this.getRealpath(path).toFile();
        if (!file.exists() && fetchMissing && this.fetch(path, null)) {
            file = this.getRealpath(path).toFile();
        }
        return DistribFileStore._getFileType(file);
    }

    public static FileStore.FileType _getFileType(File file) {
        if (!file.exists()) {
            return FileStore.FileType.NOFILE;
        }
        if (file.isDirectory()) {
            return FileStore.FileType.DIRECTORY;
        }
        return DistribFileStore.isMetaDataFile(file.getName()) ? FileStore.FileType.METADATA : FileStore.FileType.FILE;
    }

    public static boolean isMetaDataFile(String file) {
        return file.charAt(0) == '.' && file.endsWith(".json");
    }

    public static synchronized Path getFileStoreDirPath(Path solrHome) {
        Path path = solrHome.resolve("filestore");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                log.info("Created filestore folder {}", (Object)path);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed creating 'filestore' folder in SOLR_HOME", (Throwable)e);
            }
        }
        return path;
    }

    private static String _getMetapath(String path) {
        int idx = path.lastIndexOf(47);
        return path.substring(0, idx + 1) + "." + path.substring(idx + 1) + ".json";
    }

    public static void _persistToFile(Path solrHome, String path, ByteBuffer data, ByteBuffer meta) throws IOException {
        Path realpath = DistribFileStore._getRealPath(path, solrHome);
        Files.createDirectories(realpath.getParent(), new FileAttribute[0]);
        Map m = (Map)Utils.fromJSON((byte[])meta.array(), (int)meta.arrayOffset(), (int)meta.limit());
        if (m == null || m.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid metadata , discarding : " + path);
        }
        Path metadataPath = DistribFileStore._getRealPath(DistribFileStore._getMetapath(path), solrHome);
        try (SeekableByteChannel channel = Files.newByteChannel(metadataPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            channel.write(meta);
        }
        IOUtils.fsync((Path)metadataPath, (boolean)false);
        channel = Files.newByteChannel(realpath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        try {
            channel.write(data);
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
        IOUtils.fsync((Path)realpath, (boolean)false);
    }

    @Override
    public Map<String, byte[]> getKeys() throws IOException {
        return DistribFileStore._getKeys(this.solrHome);
    }

    private static Map<String, byte[]> _getKeys(Path solrHome) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Path keysDir = DistribFileStore._getRealPath("/_trusted_/keys", solrHome);
        File[] keyFiles = keysDir.toFile().listFiles();
        if (keyFiles == null) {
            return result;
        }
        for (File keyFile : keyFiles) {
            if (!keyFile.isFile() || DistribFileStore.isMetaDataFile(keyFile.getName())) continue;
            result.put(keyFile.getName(), Files.readAllBytes(keyFile.toPath()));
        }
        return result;
    }

    public static void deleteZKFileEntry(SolrZkClient client, String path) {
        try {
            client.delete(ZK_PACKAGESTORE + path, -1, true);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("", e);
        }
    }

    class FileInfo {
        final String path;
        String metaPath;
        ByteBuffer fileData;
        ByteBuffer metaData;

        FileInfo(String path) {
            this.path = path;
        }

        ByteBuffer getFileData(boolean validate) throws IOException {
            if (this.fileData == null) {
                this.fileData = ByteBuffer.wrap(Files.readAllBytes(DistribFileStore.this.getRealpath(this.path)));
            }
            return this.fileData;
        }

        public String getMetaPath() {
            if (this.metaPath == null) {
                this.metaPath = DistribFileStore._getMetapath(this.path);
            }
            return this.metaPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistToFile(ByteBuffer data, ByteBuffer meta) throws IOException {
            DistribFileStore distribFileStore = DistribFileStore.this;
            synchronized (distribFileStore) {
                this.metaData = meta;
                this.fileData = data;
                DistribFileStore._persistToFile(DistribFileStore.this.solrHome, this.path, data, meta);
                if (log.isInfoEnabled()) {
                    log.info("persisted a file {} and metadata. sizes {} {}", new Object[]{this.path, data.limit(), meta.limit()});
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean exists(boolean validateContent, boolean fetchMissing) throws IOException {
            Path file = DistribFileStore.this.getRealpath(this.path);
            if (!Files.exists(file, new LinkOption[0])) {
                if (!fetchMissing) return false;
                return this.fetchFromAnyNode();
            }
            if (!validateContent) return true;
            FileStoreAPI.MetaData metaData = this.readMetaData();
            if (metaData == null) {
                return false;
            }
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                if (!Objects.equals(DigestUtils.sha512Hex((InputStream)is), metaData.sha512)) {
                    this.deleteFile();
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to parse metadata json file");
            }
        }

        private void deleteFile() {
            try {
                IOUtils.deleteFilesIfExist((Path[])new Path[]{DistribFileStore.this.getRealpath(this.path), DistribFileStore.this.getRealpath(this.getMetaPath())});
            }
            catch (IOException e) {
                log.error("Unable to delete files: {}", (Object)this.path);
            }
        }

        private boolean fetchFileFromNodeAndPersist(String fromNode) {
            log.info("fetching a file {} from {} ", (Object)this.path, (Object)fromNode);
            String url = DistribFileStore.this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(fromNode);
            if (url == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such node");
            }
            String baseUrl = url.replace("/solr", "/api");
            ByteBuffer metadata = null;
            Map m = null;
            try {
                metadata = (ByteBuffer)Utils.executeGET((HttpClient)DistribFileStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(baseUrl + "/node/files" + this.getMetaPath()), (Utils.InputStreamConsumer)Utils.newBytesConsumer((int)((int)MAX_PKG_SIZE)));
                m = (Map)Utils.fromJSON((byte[])metadata.array(), (int)metadata.arrayOffset(), (int)metadata.limit());
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching metadata", (Throwable)e);
            }
            try {
                ByteBuffer filedata = (ByteBuffer)Utils.executeGET((HttpClient)DistribFileStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)(baseUrl + "/node/files" + this.path), (Utils.InputStreamConsumer)Utils.newBytesConsumer((int)((int)MAX_PKG_SIZE)));
                filedata.mark();
                String sha512 = DigestUtils.sha512Hex((InputStream)new ByteBufferInputStream(filedata));
                String expected = (String)m.get("sha512");
                if (!sha512.equals(expected)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "sha512 mismatch downloading : " + this.path + " from node : " + fromNode);
                }
                filedata.reset();
                this.persistToFile(filedata, metadata);
                return true;
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching data", (Throwable)e);
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error persisting file", (Throwable)ioe);
            }
        }

        boolean fetchFromAnyNode() {
            ArrayList<String> l = DistribFileStore.this.coreContainer.getFileStoreAPI().shuffledNodes();
            for (String liveNode : l) {
                try {
                    boolean success;
                    String baseurl = DistribFileStore.this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(liveNode);
                    String url = baseurl.replace("/solr", "/api");
                    String reqUrl = url + "/node/files" + this.path + "?meta=true&wt=javabin&omitHeader=true";
                    boolean nodeHasBlob = false;
                    Object nl = Utils.executeGET((HttpClient)DistribFileStore.this.coreContainer.getUpdateShardHandler().getDefaultHttpClient(), (String)reqUrl, (Utils.InputStreamConsumer)Utils.JAVABINCONSUMER);
                    if (Utils.getObjectByPath((Object)nl, (boolean)false, Arrays.asList("files", this.path)) != null) {
                        nodeHasBlob = true;
                    }
                    if (!nodeHasBlob || !(success = this.fetchFileFromNodeAndPersist(liveNode))) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        String getSimpleName() {
            int idx = this.path.lastIndexOf(47);
            if (idx == -1) {
                return this.path;
            }
            return this.path.substring(idx + 1);
        }

        public Path realPath() {
            return DistribFileStore.this.getRealpath(this.path);
        }

        FileStoreAPI.MetaData readMetaData() throws IOException {
            File file = DistribFileStore.this.getRealpath(this.getMetaPath()).toFile();
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    FileStoreAPI.MetaData metaData = new FileStoreAPI.MetaData((Map)Utils.fromJSON((InputStream)fis));
                    return metaData;
                }
            }
            return null;
        }

        public FileStore.FileDetails getDetails() {
            final FileStore.FileType type = DistribFileStore.this.getType(this.path, false);
            return new FileStore.FileDetails(){

                @Override
                public FileStoreAPI.MetaData getMetaData() {
                    try {
                        return FileInfo.this.readMetaData();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Date getTimeStamp() {
                    return new Date(FileInfo.this.realPath().toFile().lastModified());
                }

                @Override
                public boolean isDir() {
                    return type == FileStore.FileType.DIRECTORY;
                }

                @Override
                public long size() {
                    return FileInfo.this.realPath().toFile().length();
                }

                public void writeMap(MapWriter.EntryWriter ew) throws IOException {
                    FileStoreAPI.MetaData metaData = FileInfo.this.readMetaData();
                    ew.put((CharSequence)"name", (CharSequence)FileInfo.this.getSimpleName());
                    if (type == FileStore.FileType.DIRECTORY) {
                        ew.put((CharSequence)"dir", true);
                        return;
                    }
                    ew.put((CharSequence)"size", this.size());
                    ew.put((CharSequence)"timestamp", (Object)this.getTimeStamp());
                    if (metaData != null) {
                        metaData.writeMap(ew);
                    }
                }
            };
        }

        public void readData(Consumer<FileStore.FileEntry> consumer) throws IOException {
            FileStoreAPI.MetaData meta = this.readMetaData();
            try (final FileInputStream is = new FileInputStream(this.realPath().toFile());){
                consumer.accept(new FileStore.FileEntry(null, meta, this.path){

                    @Override
                    public InputStream getInputStream() {
                        return is;
                    }
                });
            }
        }
    }
}

