/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.api.ReplicationAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/cores/{coreName}/replication")
public class CoreReplicationAPI
extends ReplicationAPIBase {
    @Inject
    public CoreReplicationAPI(SolrCore solrCore, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(solrCore, req, rsp);
    }

    @GET
    @Path(value="/indexversion")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public IndexVersionResponse fetchIndexVersion() throws IOException {
        return this.doFetchIndexVersion();
    }

    @GET
    @Path(value="/files")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public FileListResponse fetchFileList(@Parameter(description="The generation number of the index", required=true) @QueryParam(value="generation") long gen) {
        return this.doFetchFileList(gen);
    }

    public static class FileMetaData
    implements JacksonReflectMapWriter {
        @JsonProperty(value="size")
        public long size;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="checksum")
        public long checksum;
        @JsonProperty(value="alias")
        public String alias;

        public FileMetaData() {
        }

        public FileMetaData(long size, String name, long checksum) {
            this.size = size;
            this.name = name;
            this.checksum = checksum;
        }
    }

    public static class FileListResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="filelist")
        public List<FileMetaData> fileList;
        @JsonProperty(value="confFiles")
        public List<FileMetaData> confFiles;
        @JsonProperty(value="status")
        public String status;
        @JsonProperty(value="message")
        public String message;
        @JsonProperty(value="exception")
        public Exception exception;
    }

    public static class IndexVersionResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="indexversion")
        public Long indexVersion;
        @JsonProperty(value="generation")
        public Long generation;
        @JsonProperty(value="status")
        public String status;

        public IndexVersionResponse() {
        }

        public IndexVersionResponse(Long indexVersion, Long generation, String status) {
            this.indexVersion = indexVersion;
            this.generation = generation;
            this.status = status;
        }
    }
}

