/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import org.apache.solr.client.api.endpoint.GetNodeCommandStatusApi;
import org.apache.solr.client.api.model.GetNodeCommandStatusResponse;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class GetNodeCommandStatus
extends CoreAdminAPIBase
implements GetNodeCommandStatusApi {
    @Inject
    public GetNodeCommandStatus(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, coreAdminAsyncTracker, req, rsp);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public GetNodeCommandStatusResponse getCommandStatus(String requestId) {
        this.ensureRequiredParameterProvided("requestid", requestId);
        GetNodeCommandStatusResponse requestStatusResponse = new GetNodeCommandStatusResponse();
        if (this.coreAdminAsyncTracker.getRequestStatusMap("running").containsKey(requestId)) {
            requestStatusResponse.status = "running";
        } else if (this.coreAdminAsyncTracker.getRequestStatusMap("completed").containsKey(requestId)) {
            requestStatusResponse.status = "completed";
            requestStatusResponse.response = this.coreAdminAsyncTracker.getRequestStatusMap("completed").get(requestId).getRspObject();
            requestStatusResponse.response = this.coreAdminAsyncTracker.getRequestStatusMap("completed").get(requestId).getOperationRspObject();
        } else if (this.coreAdminAsyncTracker.getRequestStatusMap("failed").containsKey(requestId)) {
            requestStatusResponse.status = "failed";
            requestStatusResponse.response = this.coreAdminAsyncTracker.getRequestStatusMap("failed").get(requestId).getRspObject();
        } else {
            requestStatusResponse.status = "notfound";
            requestStatusResponse.msg = "No task found in running, completed or failed tasks";
        }
        return requestStatusResponse;
    }
}

