/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.InstallShardDataApi;
import org.apache.solr.client.api.model.InstallShardDataRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.api.collections.InstallShardDataCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.common.StringUtils;

public class InstallShardData
extends AdminAPIBase
implements InstallShardDataApi {
    @Inject
    public InstallShardData(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse installShardData(String collName, String shardName, InstallShardDataRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        InstallShardData.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request body missing");
        }
        if (StringUtils.isBlank((String)requestBody.location)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The Install Shard Data API requires a 'location' indicating the index data to install");
        }
        ClusterState clusterState = coreContainer.getZkController().getZkStateReader().getClusterState();
        InstallShardData.ensureCollectionAndShardExist(clusterState, collName, shardName);
        DocCollection dc = coreContainer.getZkController().getZkStateReader().getCollection(collName);
        if (!dc.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection must be in readOnly mode before installing data to shard");
        }
        ZkNodeProps remoteMessage = InstallShardData.createRemoteMessage(collName, shardName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.INSTALLSHARDDATA, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        return response;
    }

    public static void ensureCollectionAndShardExist(ClusterState clusterState, String collectionName, String shardName) {
        DocCollection installCollection = clusterState.getCollection(collectionName);
        Slice installSlice = installCollection.getSlice(shardName);
        if (installSlice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The specified shard [" + shardName + "] does not exist.");
        }
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, InstallShardDataRequestBody requestBody) {
        InstallShardDataCmd.RemoteMessage messageTyped = new InstallShardDataCmd.RemoteMessage();
        messageTyped.collection = collectionName;
        messageTyped.shard = shardName;
        if (requestBody != null) {
            messageTyped.location = requestBody.location;
            messageTyped.repository = requestBody.repository;
            messageTyped.asyncId = requestBody.async;
        }
        messageTyped.validate();
        return new ZkNodeProps(messageTyped.toMap(new HashMap()));
    }
}

