/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cores/{coreName}/replication/backups")
public class SnapshotBackupAPI
extends JerseyResource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore solrCore;
    private final ReplicationHandler.ReplicationHandlerConfig replicationHandlerConfig;

    @Inject
    public SnapshotBackupAPI(SolrCore solrCore, ReplicationHandler.ReplicationHandlerConfig replicationHandlerConfig) {
        this.solrCore = solrCore;
        this.replicationHandlerConfig = replicationHandlerConfig;
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @Operation(summary="Backup command using ReplicationHandler")
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public BackupReplicationResponse createBackup(@RequestBody BackupReplicationRequestBody backupReplicationPayload) throws Exception {
        this.ensureRequiredRequestBodyProvided(backupReplicationPayload);
        ReplicationHandler replicationHandler = (ReplicationHandler)this.solrCore.getRequestHandler("/replication");
        return this.doBackup(replicationHandler, backupReplicationPayload);
    }

    private BackupReplicationResponse doBackup(ReplicationHandler replicationHandler, BackupReplicationRequestBody backupReplicationPayload) {
        BackupReplicationResponse response = this.instantiateJerseyResponse(BackupReplicationResponse.class);
        int numberToKeep = backupReplicationPayload.numberToKeep;
        int numberBackupsToKeep = this.replicationHandlerConfig.getNumberBackupsToKeep();
        String location = backupReplicationPayload.location;
        String repoName = backupReplicationPayload.repository;
        String commitName = backupReplicationPayload.commitName;
        String name = backupReplicationPayload.name;
        Consumer<NamedList<?>> resultConsumer = result -> {
            response.result = result;
        };
        try {
            this.doSnapShoot(numberToKeep, numberBackupsToKeep, location, repoName, commitName, name, this.solrCore, resultConsumer);
            response.status = "OK";
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception while creating a snapshot", (Throwable)e);
            SnapshotBackupAPI.reportErrorOnResponse(response, "Error encountered while creating a snapshot: " + e.getMessage(), e);
        }
        return response;
    }

    protected void doSnapShoot(int numberToKeep, int numberBackupsToKeep, String location, String repoName, String commitName, String name, SolrCore solrCore, Consumer<NamedList<?>> resultConsumer) throws IOException {
        ReplicationHandler.doSnapShoot(numberToKeep, numberBackupsToKeep, location, repoName, commitName, name, solrCore, resultConsumer);
    }

    private static void reportErrorOnResponse(BackupReplicationResponse response, String message, Exception e) {
        response.status = "ERROR";
        response.message = message;
        if (e != null) {
            response.exception = e;
        }
    }

    public static class BackupReplicationResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="result")
        public NamedList<?> result;
        @JsonProperty(value="status")
        public String status;
        @JsonProperty(value="message")
        public String message;
        @JsonProperty(value="exception")
        public Exception exception;
    }

    public static class BackupReplicationRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="The path where the backup will be created")
        @JsonProperty
        public String location;
        @Schema(description="The backup will be created in a directory called snapshot.<name>")
        @JsonProperty
        public String name;
        @Schema(description="The number of backups to keep.")
        @JsonProperty
        public int numberToKeep;
        @Schema(description="The name of the repository to be used for e backup.")
        @JsonProperty
        public String repository;
        @Schema(description="The name of the commit which was used while taking a snapshot using the CREATESNAPSHOT command.")
        @JsonProperty
        public String commitName;

        public BackupReplicationRequestBody() {
        }

        public BackupReplicationRequestBody(String location, String name, int numberToKeep, String repository, String commitName) {
            this.location = location;
            this.name = name;
            this.numberToKeep = numberToKeep;
            this.repository = repository;
            this.commitName = commitName;
        }
    }
}

