/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.PivotFacet;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.PivotFacetProcessor;
import org.apache.solr.handler.component.PivotFacetValue;
import org.apache.solr.handler.component.RangeFacetProcessor;
import org.apache.solr.handler.component.RangeFacetRequest;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.SpatialHeatmapFacets;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.PointField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.SolrResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetComponent
extends SearchComponent {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_NAME = "facet";
    public static final String FACET_COUNTS_KEY = "facet_counts";
    public static final String FACET_QUERY_KEY = "facet_queries";
    public static final String FACET_FIELD_KEY = "facet_fields";
    public static final String FACET_RANGES_KEY = "facet_ranges";
    public static final String FACET_INTERVALS_KEY = "facet_intervals";
    private static final String PIVOT_KEY = "facet_pivot";
    private static final String PIVOT_REFINE_PREFIX = "{!fpt=";
    private static final String commandPrefix = "{!terms=$";
    public static String[] FACET_TYPE_PARAMS = new String[]{"facet.field", "facet.pivot", "facet.query", "facet.date", "facet.range", "facet.interval", "facet.heatmap"};

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doFacets = true;
            ModifiableSolrParams params = new ModifiableSolrParams();
            SolrParams origParams = rb.req.getParams();
            Iterator iter = origParams.getParameterNamesIterator();
            while (iter.hasNext()) {
                String paramName = (String)iter.next();
                if (!paramName.startsWith(COMPONENT_NAME)) {
                    params.add(paramName, origParams.getParams(paramName));
                    continue;
                }
                LinkedHashSet<String> deDupe = new LinkedHashSet<String>(Arrays.asList(origParams.getParams(paramName)));
                params.add(paramName, deDupe.toArray(new String[0]));
            }
            rb.req.setParams((SolrParams)params);
            FacetContext.initContext(rb);
        }
    }

    protected SimpleFacets newSimpleFacets(SolrQueryRequest req, DocSet docSet, SolrParams params, ResponseBuilder rb) {
        return new SimpleFacets(req, docSet, params, rb);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doFacets) {
            PivotFacetProcessor pivotProcessor;
            SimpleOrderedMap<List<NamedList<Object>>> v;
            SolrParams params = rb.req.getParams();
            SimpleFacets f = this.newSimpleFacets(rb.req, rb.getResults().docSet, params, rb);
            RTimer timer = null;
            FacetDebugInfo fdebug = null;
            if (rb.isDebug()) {
                fdebug = new FacetDebugInfo();
                rb.req.getContext().put("FacetDebugInfo-nonJson", fdebug);
                timer = new RTimer();
            }
            NamedList<Object> counts = FacetComponent.getFacetCounts(f, fdebug);
            String[] pivots = params.getParams("facet.pivot");
            if (pivots != null && Array.getLength(pivots) != 0 && (v = (pivotProcessor = new PivotFacetProcessor(rb.req, rb.getResults().docSet, params, rb)).process(pivots)) != null) {
                counts.add(PIVOT_KEY, v);
            }
            if (fdebug != null) {
                long timeElapsed = (long)timer.getTime();
                fdebug.setElapse(timeElapsed);
            }
            rb.rsp.add(FACET_COUNTS_KEY, counts);
        }
    }

    public static NamedList<Object> getFacetCounts(SimpleFacets simpleFacets) {
        return FacetComponent.getFacetCounts(simpleFacets, null);
    }

    public static NamedList<Object> getFacetCounts(SimpleFacets simpleFacets, FacetDebugInfo fdebug) {
        if (!simpleFacets.getGlobalParams().getBool(COMPONENT_NAME, true)) {
            return null;
        }
        RangeFacetProcessor rangeFacetProcessor = new RangeFacetProcessor(simpleFacets.getRequest(), simpleFacets.getDocsOrig(), simpleFacets.getGlobalParams(), simpleFacets.getResponseBuilder());
        SimpleOrderedMap counts = new SimpleOrderedMap();
        try {
            counts.add(FACET_QUERY_KEY, simpleFacets.getFacetQueryCounts());
            if (fdebug != null) {
                FacetDebugInfo fd = new FacetDebugInfo();
                fd.putInfoItem("action", "field facet");
                fd.setProcessor(simpleFacets.getClass().getSimpleName());
                fdebug.addChild(fd);
                simpleFacets.setFacetDebugInfo(fd);
                RTimer timer = new RTimer();
                counts.add(FACET_FIELD_KEY, simpleFacets.getFacetFieldCounts());
                long timeElapsed = (long)timer.getTime();
                fd.setElapse(timeElapsed);
            } else {
                counts.add(FACET_FIELD_KEY, simpleFacets.getFacetFieldCounts());
            }
            counts.add(FACET_RANGES_KEY, rangeFacetProcessor.getFacetRangeCounts());
            counts.add(FACET_INTERVALS_KEY, simpleFacets.getFacetIntervalCounts());
            counts.add("facet_heatmaps", simpleFacets.getHeatmapCounts());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return counts;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doFacets) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_DONE;
        }
        for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
            ArrayList<Object> distribFieldFacetRefinements = null;
            for (DistribFieldFacet dff : rb._facetInfo.facets.values()) {
                List<String> refList;
                if (!dff.needRefinements || (refList = dff._toRefine[shardNum]) == null || refList.size() == 0) continue;
                String key = dff.getKey();
                String termsKey = (String)key + "__terms";
                String termsVal = StrUtils.join(refList, (char)',');
                String termsKeyEncoded = ClientUtils.encodeLocalParamVal((String)termsKey);
                String facetCommand = dff.localParams != null ? commandPrefix + termsKeyEncoded + " " + dff.facetStr.substring(2) : commandPrefix + termsKeyEncoded + "}" + dff.field;
                if (distribFieldFacetRefinements == null) {
                    distribFieldFacetRefinements = new ArrayList<Object>();
                }
                distribFieldFacetRefinements.add(facetCommand);
                distribFieldFacetRefinements.add(termsKey);
                distribFieldFacetRefinements.add(termsVal);
            }
            if (distribFieldFacetRefinements != null) {
                String shard = rb.shards[shardNum];
                ShardRequest shardsRefineRequest = null;
                boolean newRequest = false;
                for (ShardRequest sreq : rb.outgoing) {
                    if ((sreq.purpose & 0x40) == 0 || sreq.shards == null || sreq.shards.length != 1 || !sreq.shards[0].equals(shard)) continue;
                    shardsRefineRequest = sreq;
                    break;
                }
                if (shardsRefineRequest == null) {
                    newRequest = true;
                    shardsRefineRequest = new ShardRequest();
                    shardsRefineRequest.shards = new String[]{rb.shards[shardNum]};
                    shardsRefineRequest.params = new ModifiableSolrParams(rb.req.getParams());
                    shardsRefineRequest.params.remove("start");
                    shardsRefineRequest.params.set("rows", new String[]{"0"});
                }
                shardsRefineRequest.purpose |= 0x20;
                shardsRefineRequest.params.set(COMPONENT_NAME, new String[]{"true"});
                this.removeMainFacetTypeParams(shardsRefineRequest);
                int i = 0;
                while (i < distribFieldFacetRefinements.size()) {
                    String facetCommand = (String)distribFieldFacetRefinements.get(i++);
                    String termsKey = (String)distribFieldFacetRefinements.get(i++);
                    String termsVal = (String)distribFieldFacetRefinements.get(i++);
                    shardsRefineRequest.params.add("facet.field", new String[]{facetCommand});
                    shardsRefineRequest.params.set(termsKey, new String[]{termsVal});
                }
                if (newRequest) {
                    rb.addRequest(this, shardsRefineRequest);
                }
            }
            if (!this.doAnyPivotFacetRefinementRequestsExistForShard(rb._facetInfo, shardNum)) continue;
            this.enqueuePivotFacetShardRequests(rb, shardNum);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    private void removeMainFacetTypeParams(ShardRequest shardsRefineRequest) {
        for (String param : FACET_TYPE_PARAMS) {
            shardsRefineRequest.params.remove(param);
        }
    }

    private void enqueuePivotFacetShardRequests(ResponseBuilder rb, int shardNum) {
        FacetInfo fi = rb._facetInfo;
        ShardRequest shardsRefineRequestPivot = new ShardRequest();
        shardsRefineRequestPivot.shards = new String[]{rb.shards[shardNum]};
        shardsRefineRequestPivot.params = new ModifiableSolrParams(rb.req.getParams());
        shardsRefineRequestPivot.params.remove("start");
        shardsRefineRequestPivot.params.set("rows", new String[]{"0"});
        shardsRefineRequestPivot.purpose |= 0x2000;
        shardsRefineRequestPivot.params.set(COMPONENT_NAME, new String[]{"true"});
        this.removeMainFacetTypeParams(shardsRefineRequestPivot);
        shardsRefineRequestPivot.params.set("facet.pivot.mincount", -1);
        shardsRefineRequestPivot.params.remove("facet.offset");
        for (int pivotIndex = 0; pivotIndex < fi.pivotFacets.size(); ++pivotIndex) {
            String pivotFacetKey = fi.pivotFacets.getName(pivotIndex);
            PivotFacet pivotFacet = (PivotFacet)fi.pivotFacets.getVal(pivotIndex);
            List<PivotFacetValue> queuedRefinementsForShard = pivotFacet.getQueuedRefinements(shardNum);
            if (!queuedRefinementsForShard.isEmpty()) {
                String fieldsKey = "fpt" + fi.pivotRefinementCounter;
                String command = pivotFacet.localParams != null ? PIVOT_REFINE_PREFIX + fi.pivotRefinementCounter + " " + pivotFacet.facetStr.substring(2) : PIVOT_REFINE_PREFIX + fi.pivotRefinementCounter + "}" + pivotFacet.getKey();
                shardsRefineRequestPivot.params.add("facet.pivot", new String[]{command});
                for (PivotFacetValue refinementValue : queuedRefinementsForShard) {
                    String refinementStr = PivotFacetHelper.encodeRefinementValuePath(refinementValue.getValuePath());
                    shardsRefineRequestPivot.params.add(fieldsKey, new String[]{refinementStr});
                }
            }
            ++fi.pivotRefinementCounter;
        }
        rb.addRequest(this, shardsRefineRequestPivot);
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x10;
            FacetInfo fi = rb._facetInfo;
            if (fi == null) {
                rb._facetInfo = fi = new FacetInfo();
                fi.parse(rb.req.getParams(), rb);
            }
            this.modifyRequestForFieldFacets(rb, sreq, fi);
            this.modifyRequestForRangeFacets(sreq);
            this.modifyRequestForPivotFacets(rb, sreq, fi.pivotFacets);
            SpatialHeatmapFacets.distribModifyRequest(sreq, fi.heatmapFacets);
            sreq.params.remove("facet.mincount");
            sreq.params.remove("facet.offset");
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    private void modifyRequestForRangeFacets(ShardRequest sreq) {
        String[] fields = sreq.params.getParams("facet.range");
        if (fields != null) {
            for (String field : fields) {
                sreq.params.set("f." + field + ".facet.mincount", new String[]{"0"});
            }
        }
    }

    private void modifyRequestForFieldFacets(ResponseBuilder rb, ShardRequest sreq, FacetInfo fi) {
        for (DistribFieldFacet dff : fi.facets.values()) {
            String paramStart = "f." + dff.field + ".";
            sreq.params.remove(paramStart + "facet.mincount");
            sreq.params.remove(paramStart + "facet.offset");
            int n = dff.initialLimit = dff.limit <= 0 ? dff.limit : dff.offset + dff.limit;
            if (dff.sort.equals("count")) {
                if (dff.limit > 0) {
                    dff.initialLimit = this.doOverRequestMath(dff.initialLimit, dff.overrequestRatio, dff.overrequestCount);
                }
                dff.initialMincount = Math.min(dff.minCount, 1);
            } else {
                dff.initialMincount = dff.minCount <= 1 ? dff.minCount : (int)Math.ceil((double)dff.minCount / (double)rb.slices.length);
            }
            dff.initialLimit = rb.req.getParams().getInt("facet.shard.limit", dff.initialLimit);
            sreq.params.set(paramStart + "facet.limit", dff.initialLimit);
            sreq.params.set(paramStart + "facet.mincount", dff.initialMincount);
        }
    }

    private void modifyRequestForPivotFacets(ResponseBuilder rb, ShardRequest sreq, SimpleOrderedMap<PivotFacet> pivotFacets) {
        for (Map.Entry pfwEntry : pivotFacets) {
            PivotFacet pivot = (PivotFacet)pfwEntry.getValue();
            for (String pivotField : StrUtils.splitSmart((String)pivot.getKey(), (char)',')) {
                this.modifyRequestForIndividualPivotFacets(rb, sreq, pivotField);
            }
        }
    }

    private void modifyRequestForIndividualPivotFacets(ResponseBuilder rb, ShardRequest sreq, String fieldToOverRequest) {
        SolrParams originalParams = rb.req.getParams();
        String paramStart = "f." + fieldToOverRequest + ".";
        int requestedLimit = originalParams.getFieldInt(fieldToOverRequest, "facet.limit", 100);
        sreq.params.remove(paramStart + "facet.limit");
        int offset = originalParams.getFieldInt(fieldToOverRequest, "facet.offset", 0);
        sreq.params.remove(paramStart + "facet.offset");
        double overRequestRatio = originalParams.getFieldDouble(fieldToOverRequest, "facet.overrequest.ratio", 1.5);
        sreq.params.remove(paramStart + "facet.overrequest.ratio");
        int overRequestCount = originalParams.getFieldInt(fieldToOverRequest, "facet.overrequest.count", 10);
        sreq.params.remove(paramStart + "facet.overrequest.count");
        int requestedMinCount = originalParams.getFieldInt(fieldToOverRequest, "facet.pivot.mincount", 1);
        sreq.params.remove(paramStart + "facet.pivot.mincount");
        String defaultSort = requestedLimit > 0 ? "count" : "index";
        String sort = originalParams.getFieldParam(fieldToOverRequest, "facet.sort", defaultSort);
        int shardLimit = requestedLimit + offset;
        int shardMinCount = Math.min(requestedMinCount, 1);
        if ("index".equals(sort) && 1 < requestedMinCount && 0 < requestedLimit) {
            shardMinCount = (int)Math.ceil((double)requestedMinCount / (double)rb.slices.length);
            shardLimit = this.doOverRequestMath(shardLimit, overRequestRatio, overRequestCount);
        } else if ("count".equals(sort) && 0 < requestedLimit) {
            shardLimit = this.doOverRequestMath(shardLimit, overRequestRatio, overRequestCount);
        }
        sreq.params.set(paramStart + "facet.limit", shardLimit);
        sreq.params.set(paramStart + "facet.pivot.mincount", shardMinCount);
    }

    private int doOverRequestMath(int limit, double ratio, int count) {
        int adjustedLimit = (int)((double)limit * ratio) + count;
        return Math.max(limit, adjustedLimit);
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 0x10) != 0) {
            this.countFacets(rb, sreq);
        } else {
            if ((sreq.purpose & 0x20) != 0) {
                this.refineFacets(rb, sreq);
            }
            if ((sreq.purpose & 0x2000) != 0) {
                this.refinePivotFacets(rb, sreq);
            }
        }
    }

    private void countFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            SimpleOrderedMap rangesFromShard;
            NamedList facet_fields;
            int shardNum = rb.getShardNum(srsp.getShard());
            NamedList facet_counts = (NamedList)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, FACET_COUNTS_KEY, false);
            if (facet_counts == null) continue;
            NamedList facet_queries = (NamedList)facet_counts.get(FACET_QUERY_KEY);
            if (facet_queries != null) {
                for (int i = 0; i < facet_queries.size(); ++i) {
                    String returnedKey = facet_queries.getName(i);
                    long count = ((Number)facet_queries.getVal(i)).longValue();
                    QueryFacet qf = fi.queryFacets.get(returnedKey);
                    qf.count += count;
                }
            }
            if ((facet_fields = (NamedList)facet_counts.get(FACET_FIELD_KEY)) != null) {
                for (DistribFieldFacet dff : fi.facets.values()) {
                    dff.add(shardNum, (NamedList)facet_fields.get(dff.getKey()), dff.initialLimit);
                }
            }
            if ((rangesFromShard = (SimpleOrderedMap)facet_counts.get(FACET_RANGES_KEY)) != null) {
                RangeFacetRequest.DistribRangeFacet.mergeFacetRangesFromShardResponse(fi.rangeFacets, (SimpleOrderedMap<SimpleOrderedMap<Object>>)rangesFromShard);
            }
            this.doDistribIntervals(fi, facet_counts);
            this.doDistribPivots(rb, shardNum, facet_counts);
            SpatialHeatmapFacets.distribHandleResponse(fi.heatmapFacets, facet_counts);
        }
        for (Map.Entry pivotFacet : fi.pivotFacets) {
            ((PivotFacet)pivotFacet.getValue()).queuePivotRefinementRequests();
        }
        for (DistribFieldFacet dff : fi.facets.values()) {
            if (dff.initialLimit <= 0 && dff.initialMincount <= 1 || dff.minCount <= 1 && dff.sort.equals("index")) continue;
            List[] tmp = (List[])Array.newInstance(List.class, rb.shards.length);
            dff._toRefine = tmp;
            ShardFacetCount[] counts = dff.getCountSorted();
            int ntop = Math.min(counts.length, dff.limit >= 0 ? dff.offset + dff.limit : Integer.MAX_VALUE);
            long smallestCount = counts.length == 0 ? 0L : counts[ntop - 1].count;
            for (int i = 0; i < counts.length; ++i) {
                ShardFacetCount sfc = counts[i];
                boolean needRefinement = false;
                if (i < ntop) {
                    needRefinement = true;
                } else {
                    long maxCount = sfc.count;
                    for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                        FixedBitSet fbs = dff.counted[shardNum];
                        if (fbs == null || sfc.termNum < fbs.length() && fbs.get(sfc.termNum)) continue;
                        maxCount += dff.maxPossible(shardNum);
                    }
                    if (maxCount >= smallestCount) {
                        needRefinement = true;
                    }
                }
                if (!needRefinement) continue;
                for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                    FixedBitSet fbs = dff.counted[shardNum];
                    if (fbs == null || sfc.termNum < fbs.length() && fbs.get(sfc.termNum) || dff.maxPossible(shardNum) <= 0L) continue;
                    dff.needRefinements = true;
                    List<String> lst = dff._toRefine[shardNum];
                    if (lst == null) {
                        lst = dff._toRefine[shardNum] = new ArrayList<String>();
                    }
                    lst.add(sfc.name);
                }
            }
        }
        this.removeFieldFacetsUnderLimits(rb);
        this.removeRangeFacetsUnderLimits(rb);
        this.removeQueryFacetsUnderLimits(rb);
    }

    private void removeQueryFacetsUnderLimits(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        LinkedHashMap<String, QueryFacet> query_facets = fi.queryFacets;
        if (query_facets == null) {
            return;
        }
        LinkedHashMap<String, QueryFacet> newQueryFacets = new LinkedHashMap<String, QueryFacet>();
        int minCount = rb.req.getParams().getInt("facet.mincount", 0);
        boolean replace = false;
        for (Map.Entry ent : query_facets.entrySet()) {
            if (((QueryFacet)ent.getValue()).count >= (long)minCount) {
                newQueryFacets.put((String)ent.getKey(), (QueryFacet)ent.getValue());
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("Removing facetQuery/key: {}/{} mincount={}", new Object[]{ent.getKey(), ent.getValue(), minCount});
            }
            replace = true;
        }
        if (replace) {
            fi.queryFacets = newQueryFacets;
        }
    }

    private void removeRangeFacetsUnderLimits(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        for (Map.Entry<String, RangeFacetRequest.DistribRangeFacet> entry : fi.rangeFacets.entrySet()) {
            String field = entry.getKey();
            RangeFacetRequest.DistribRangeFacet rangeFacet = entry.getValue();
            int minCount = rb.req.getParams().getFieldInt(field, "facet.mincount", 0);
            if (minCount == 0) continue;
            rangeFacet.removeRangeFacetsUnderLimits(minCount);
        }
    }

    private void removeFieldFacetsUnderLimits(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_DONE) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        if (fi.facets == null) {
            return;
        }
        for (Map.Entry<String, DistribFieldFacet> ent : fi.facets.entrySet()) {
            String field = ent.getKey();
            int minCount = rb.req.getParams().getFieldInt(field, "facet.mincount", 0);
            if (minCount == 0) continue;
            ent.getValue().respectMinCount(minCount);
        }
    }

    private void doDistribIntervals(FacetInfo fi, NamedList<?> facet_counts) {
        SimpleOrderedMap facet_intervals = (SimpleOrderedMap)facet_counts.get(FACET_INTERVALS_KEY);
        if (facet_intervals != null) {
            for (Map.Entry entry : facet_intervals) {
                String field = (String)entry.getKey();
                SimpleOrderedMap existingCounts = (SimpleOrderedMap)fi.intervalFacets.get(field);
                if (existingCounts == null) {
                    fi.intervalFacets.add(field, (Object)((SimpleOrderedMap)entry.getValue()));
                    continue;
                }
                Iterator newItr = ((SimpleOrderedMap)entry.getValue()).iterator();
                for (Map.Entry exItem : existingCounts) {
                    if (!newItr.hasNext()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response missing key: " + (String)exItem.getKey());
                    }
                    Map.Entry newItem = (Map.Entry)newItr.next();
                    if (!((String)newItem.getKey()).equals(exItem.getKey())) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response has extra key: " + (String)newItem.getKey());
                    }
                    exItem.setValue((Integer)exItem.getValue() + (Integer)newItem.getValue());
                }
                if (!newItr.hasNext()) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response has at least one extra key: " + (String)((Map.Entry)newItr.next()).getKey());
            }
        }
    }

    private void doDistribPivots(ResponseBuilder rb, int shardNum, NamedList<?> facet_counts) {
        SimpleOrderedMap facet_pivot = (SimpleOrderedMap)facet_counts.get(PIVOT_KEY);
        if (facet_pivot != null) {
            for (Map.Entry pivot : facet_pivot) {
                String pivotName = (String)pivot.getKey();
                PivotFacet facet = (PivotFacet)rb._facetInfo.pivotFacets.get(pivotName);
                facet.mergeResponseFromShard(shardNum, rb, (List)pivot.getValue());
            }
        }
    }

    private void refineFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            NamedList facet_fields;
            NamedList facet_counts = (NamedList)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, FACET_COUNTS_KEY, false);
            if (facet_counts == null || (facet_fields = (NamedList)facet_counts.get(FACET_FIELD_KEY)) == null) continue;
            for (int i = 0; i < facet_fields.size(); ++i) {
                String key = facet_fields.getName(i);
                DistribFieldFacet dff = fi.facets.get(key);
                if (dff == null) continue;
                NamedList shardCounts = (NamedList)facet_fields.getVal(i);
                for (int j = 0; j < shardCounts.size(); ++j) {
                    String name = shardCounts.getName(j);
                    long count = ((Number)shardCounts.getVal(j)).longValue();
                    ShardFacetCount sfc = dff.counts.get(name);
                    if (sfc == null) {
                        log.error("Unexpected term returned for facet refining. key='{}'  term='{}'\n\trequest params={}\n\ttoRefine={}\n\tresponse={}", new Object[]{key, name, sreq.params, dff._toRefine, shardCounts});
                        continue;
                    }
                    sfc.count += count;
                }
            }
        }
    }

    private void refinePivotFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            int shardNumber = rb.getShardNum(srsp.getShard());
            NamedList facetCounts = (NamedList)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, FACET_COUNTS_KEY, false);
            if (facetCounts == null) continue;
            NamedList pivotFacetResponsesFromShard = (NamedList)facetCounts.get(PIVOT_KEY);
            if (null == pivotFacetResponsesFromShard) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No pivot refinement response from shard: " + srsp.getShard());
            }
            for (Map.Entry pivotFacetResponseFromShard : pivotFacetResponsesFromShard) {
                PivotFacet aggregatedPivotFacet = (PivotFacet)fi.pivotFacets.get((String)pivotFacetResponseFromShard.getKey());
                aggregatedPivotFacet.mergeResponseFromShard(shardNumber, rb, (List)pivotFacetResponseFromShard.getValue());
                aggregatedPivotFacet.removeAllRefinementsForShard(shardNumber);
            }
        }
        if (this.allPivotFacetsAreFullyRefined(fi)) {
            for (Map.Entry pf : fi.pivotFacets) {
                ((PivotFacet)pf.getValue()).queuePivotRefinementRequests();
            }
            this.reQueuePivotFacetShardRequests(rb);
        }
    }

    private boolean allPivotFacetsAreFullyRefined(FacetInfo fi) {
        for (Map.Entry pf : fi.pivotFacets) {
            if (!((PivotFacet)pf.getValue()).isRefinementsRequired()) continue;
            return false;
        }
        return true;
    }

    private boolean doAnyPivotFacetRefinementRequestsExistForShard(FacetInfo fi, int shardNum) {
        for (int i = 0; i < fi.pivotFacets.size(); ++i) {
            PivotFacet pf = (PivotFacet)fi.pivotFacets.getVal(i);
            if (pf.getQueuedRefinements(shardNum).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void reQueuePivotFacetShardRequests(ResponseBuilder rb) {
        for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
            if (!this.doAnyPivotFacetRefinementRequestsExistForShard(rb._facetInfo, shardNum)) continue;
            this.enqueuePivotFacetShardRequests(rb, shardNum);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doFacets || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        SimpleOrderedMap facet_counts = new SimpleOrderedMap();
        SimpleOrderedMap facet_queries = new SimpleOrderedMap();
        facet_counts.add(FACET_QUERY_KEY, (Object)facet_queries);
        for (QueryFacet queryFacet : fi.queryFacets.values()) {
            facet_queries.add(queryFacet.getKey(), (Object)FacetComponent.num(queryFacet.count));
        }
        SimpleOrderedMap facet_fields = new SimpleOrderedMap();
        facet_counts.add(FACET_FIELD_KEY, (Object)facet_fields);
        for (DistribFieldFacet dff : fi.facets.values()) {
            ShardFacetCount[] counts;
            NamedList fieldCounts = new NamedList();
            facet_fields.add(dff.getKey(), (Object)fieldCounts);
            boolean countSorted = dff.sort.equals("count");
            if (countSorted) {
                counts = dff.countSorted;
                if (counts == null || dff.needRefinements) {
                    counts = dff.getCountSorted();
                }
            } else {
                counts = dff.sort.equals("index") ? dff.getLexSorted() : dff.getLexSorted();
            }
            if (countSorted) {
                int end = dff.limit < 0 ? counts.length : Math.min(dff.offset + dff.limit, counts.length);
                for (int i = dff.offset; i < end && counts[i].count >= (long)dff.minCount; ++i) {
                    fieldCounts.add(counts[i].name, (Object)FacetComponent.num(counts[i].count));
                }
            } else {
                int off = dff.offset;
                int lim = dff.limit >= 0 ? dff.limit : Integer.MAX_VALUE;
                for (int i = 0; i < counts.length; ++i) {
                    long count = counts[i].count;
                    if (count < (long)dff.minCount) continue;
                    if (off > 0) {
                        --off;
                        continue;
                    }
                    if (lim > 0) {
                        --lim;
                        fieldCounts.add(counts[i].name, (Object)FacetComponent.num(count));
                        continue;
                    }
                    break;
                }
            }
            if (!dff.missing) continue;
            fieldCounts.add(null, (Object)FacetComponent.num(dff.missingCount));
        }
        SimpleOrderedMap simpleOrderedMap = new SimpleOrderedMap();
        for (Map.Entry<String, RangeFacetRequest.DistribRangeFacet> entry : fi.rangeFacets.entrySet()) {
            String key = entry.getKey();
            RangeFacetRequest.DistribRangeFacet value = entry.getValue();
            simpleOrderedMap.add(key, value.rangeFacet);
        }
        facet_counts.add(FACET_RANGES_KEY, (Object)simpleOrderedMap);
        facet_counts.add(FACET_INTERVALS_KEY, fi.intervalFacets);
        facet_counts.add("facet_heatmaps", SpatialHeatmapFacets.distribFinish(fi.heatmapFacets, rb));
        if (fi.pivotFacets != null && fi.pivotFacets.size() > 0) {
            facet_counts.add(PIVOT_KEY, this.createPivotFacetOutput(rb));
        }
        rb.rsp.add(FACET_COUNTS_KEY, facet_counts);
        rb._facetInfo = null;
    }

    private SimpleOrderedMap<List<NamedList<Object>>> createPivotFacetOutput(ResponseBuilder rb) {
        SimpleOrderedMap combinedPivotFacets = new SimpleOrderedMap();
        for (Map.Entry entry : rb._facetInfo.pivotFacets) {
            String key = (String)entry.getKey();
            PivotFacet pivot = (PivotFacet)entry.getValue();
            List<Object> trimmedPivots = pivot.getTrimmedPivotsAsListOfNamedLists();
            if (null == trimmedPivots) {
                trimmedPivots = Collections.emptyList();
            }
            combinedPivotFacets.add(key, trimmedPivots);
        }
        return combinedPivotFacets;
    }

    static Number num(long val) {
        if (val < Integer.MAX_VALUE) {
            return (int)val;
        }
        return val;
    }

    static Number num(Long val) {
        if (val < Integer.MAX_VALUE) {
            return val.intValue();
        }
        return val;
    }

    @Override
    public String getDescription() {
        return "Handle Faceting";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    private static final class DistribFacetExistsField
    extends DistribFieldFacet {
        private DistribFacetExistsField(ResponseBuilder rb, String facetStr) {
            super(rb, facetStr);
            SimpleFacets.checkMincountOnExists(this.field, this.minCount);
        }

        @Override
        protected void incCount(ShardFacetCount sfc, long count) {
            if (count > 0L) {
                sfc.count = 1L;
            }
        }
    }

    public static class ShardFacetCount {
        public String name;
        public BytesRef indexed;
        public long count;
        public int termNum;

        public String toString() {
            return "{term=" + this.name + ",termNum=" + this.termNum + ",count=" + this.count + "}";
        }
    }

    public static class DistribFieldFacet
    extends FieldFacet {
        public List<String>[] _toRefine;
        public long missingMaxPossible;
        public long[] missingMax;
        public FixedBitSet[] counted;
        public HashMap<String, ShardFacetCount> counts = CollectionUtil.newHashMap((int)128);
        public int termNum;
        public int initialLimit;
        public int initialMincount;
        public double overrequestRatio;
        public int overrequestCount;
        public boolean needRefinements;
        public ShardFacetCount[] countSorted;

        DistribFieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, facetStr);
            this.missingMax = new long[rb.shards.length];
            this.counted = new FixedBitSet[rb.shards.length];
        }

        @Override
        protected void fillParams(ResponseBuilder rb, SolrParams params, String field) {
            super.fillParams(rb, params, field);
            this.overrequestRatio = params.getFieldDouble(field, "facet.overrequest.ratio", 1.5);
            this.overrequestCount = params.getFieldInt(field, "facet.overrequest.count", 10);
        }

        void add(int shardNum, NamedList<?> shardCounts, int numRequested) {
            int sz;
            int numReceived = sz = shardCounts == null ? 0 : shardCounts.size();
            FixedBitSet terms = new FixedBitSet(this.termNum + sz);
            long last = 0L;
            for (int i = 0; i < sz; ++i) {
                String name = shardCounts.getName(i);
                long count = ((Number)shardCounts.getVal(i)).longValue();
                if (name == null) {
                    this.missingCount += count;
                    --numReceived;
                    continue;
                }
                ShardFacetCount sfc = this.counts.get(name);
                if (sfc == null) {
                    sfc = new ShardFacetCount();
                    sfc.name = name;
                    sfc.indexed = this.ftype == null ? null : (this.ftype.isPointField() ? ((PointField)this.ftype).toInternalByteRef(sfc.name) : new BytesRef((CharSequence)this.ftype.toInternal(sfc.name)));
                    ++this.termNum;
                    sfc.termNum = sfc.termNum;
                    this.counts.put(name, sfc);
                }
                this.incCount(sfc, count);
                terms.set(sfc.termNum);
                last = count;
            }
            if (numRequested < 0 || numRequested != 0 && numReceived < numRequested) {
                last = Math.max(0, this.initialMincount - 1);
            }
            this.missingMaxPossible += last;
            this.missingMax[shardNum] = last;
            this.counted[shardNum] = terms;
        }

        protected void incCount(ShardFacetCount sfc, long count) {
            sfc.count += count;
        }

        public ShardFacetCount[] getLexSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[0]);
            Arrays.sort(arr, (o1, o2) -> o1.indexed.compareTo(o2.indexed));
            this.countSorted = arr;
            return arr;
        }

        public ShardFacetCount[] getCountSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[0]);
            Arrays.sort(arr, (o1, o2) -> {
                if (o2.count < o1.count) {
                    return -1;
                }
                if (o1.count < o2.count) {
                    return 1;
                }
                return o1.indexed.compareTo(o2.indexed);
            });
            this.countSorted = arr;
            return arr;
        }

        long maxPossible(int shardNum) {
            return this.missingMax[shardNum];
        }

        public void respectMinCount(long minCount) {
            HashMap<String, ShardFacetCount> newOne = new HashMap<String, ShardFacetCount>();
            boolean replace = false;
            for (Map.Entry<String, ShardFacetCount> ent : this.counts.entrySet()) {
                if (ent.getValue().count >= minCount) {
                    newOne.put(ent.getKey(), ent.getValue());
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Removing facet/key: {}/{} mincount={}", new Object[]{ent.getKey(), ent.getValue(), minCount});
                }
                replace = true;
            }
            if (replace) {
                this.counts = newOne;
            }
        }
    }

    public static class FieldFacet
    extends FacetBase {
        public String field;
        public FieldType ftype;
        public int offset;
        public int limit;
        public int minCount;
        public String sort;
        public boolean missing;
        public String prefix;
        public long missingCount;

        public FieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.field", facetStr);
            this.fillParams(rb, rb.req.getParams(), this.facetOn);
        }

        protected void fillParams(ResponseBuilder rb, SolrParams params, String field) {
            this.field = field;
            this.ftype = rb.req.getSchema().getFieldTypeNoEx(this.field);
            this.offset = params.getFieldInt(field, "facet.offset", 0);
            this.limit = params.getFieldInt(field, "facet.limit", 100);
            Integer mincount = params.getFieldInt(field, "facet.mincount");
            if (mincount == null) {
                Boolean zeros = params.getFieldBool(field, "facet.zeros");
                mincount = zeros != null && zeros == false ? 1 : 0;
            }
            this.minCount = mincount;
            this.missing = params.getFieldBool(field, "facet.missing", false);
            this.sort = params.getFieldParam(field, "facet.sort", this.limit > 0 ? "count" : "index");
            if (this.sort.equals("true")) {
                this.sort = "count";
            } else if (this.sort.equals("false")) {
                this.sort = "index";
            }
            this.prefix = params.getFieldParam(field, "facet.prefix");
        }
    }

    public static class QueryFacet
    extends FacetBase {
        public long count;

        public QueryFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.query", facetStr);
        }
    }

    public static class FacetBase {
        String facetType;
        String facetStr;
        String facetOn;
        private String key;
        SolrParams localParams;
        private List<String> tags = Collections.emptyList();
        private List<String> excludeTags = Collections.emptyList();
        private int threadCount = -1;

        public FacetBase(ResponseBuilder rb, String facetType, String facetStr) {
            this.facetType = facetType;
            this.facetStr = facetStr;
            try {
                this.localParams = QueryParsing.getLocalParams(facetStr, rb.req.getParams());
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            this.facetOn = facetStr;
            this.key = facetStr;
            if (this.localParams != null) {
                if (!facetType.equals("facet.query")) {
                    this.key = this.facetOn = this.localParams.get("v");
                }
                this.key = this.localParams.get("key", this.key);
                String tagStr = this.localParams.get("tag");
                this.tags = tagStr == null ? Collections.emptyList() : StrUtils.splitSmart((String)tagStr, (char)',');
                String threadStr = this.localParams.get("threads");
                this.threadCount = threadStr != null ? Integer.parseInt(threadStr) : -1;
                String excludeStr = this.localParams.get("ex");
                this.excludeTags = StrUtils.isNullOrEmpty((String)excludeStr) ? Collections.emptyList() : StrUtils.splitSmart((String)excludeStr, (char)',');
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.facetType;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public List<String> getExcludeTags() {
            return this.excludeTags;
        }

        public int getThreadCount() {
            return this.threadCount;
        }
    }

    public static class FacetInfo {
        int pivotRefinementCounter = 0;
        public LinkedHashMap<String, QueryFacet> queryFacets;
        public LinkedHashMap<String, DistribFieldFacet> facets;
        public SimpleOrderedMap<SimpleOrderedMap<Object>> dateFacets = new SimpleOrderedMap();
        public LinkedHashMap<String, RangeFacetRequest.DistribRangeFacet> rangeFacets = new LinkedHashMap();
        public SimpleOrderedMap<SimpleOrderedMap<Integer>> intervalFacets = new SimpleOrderedMap();
        public SimpleOrderedMap<PivotFacet> pivotFacets = new SimpleOrderedMap();
        public LinkedHashMap<String, SpatialHeatmapFacets.HeatmapFacet> heatmapFacets;

        void parse(SolrParams params, ResponseBuilder rb) {
            String[] facetPFs;
            String[] facetFs;
            this.queryFacets = new LinkedHashMap();
            this.facets = new LinkedHashMap();
            String[] facetQs = params.getParams("facet.query");
            if (facetQs != null) {
                for (String query : facetQs) {
                    QueryFacet queryFacet = new QueryFacet(rb, query);
                    this.queryFacets.put(queryFacet.getKey(), queryFacet);
                }
            }
            if ((facetFs = params.getParams("facet.field")) != null) {
                for (String field : facetFs) {
                    DistribFieldFacet ff = params.getFieldBool(field, "facet.exists", false) ? new DistribFacetExistsField(rb, field) : new DistribFieldFacet(rb, field);
                    this.facets.put(ff.getKey(), ff);
                }
            }
            if ((facetPFs = params.getParams("facet.pivot")) != null) {
                for (String fieldGroup : facetPFs) {
                    PivotFacet pf = new PivotFacet(rb, fieldGroup);
                    this.pivotFacets.add(pf.getKey(), (Object)pf);
                }
            }
            this.heatmapFacets = SpatialHeatmapFacets.distribParse(params, rb);
        }
    }

    public static class FacetContext {
        private static final String FACET_CONTEXT_KEY = "_facet.context";
        private final List<RangeFacetRequest> allRangeFacets;
        private final List<FacetBase> allQueryFacets;
        private final Map<String, List<RangeFacetRequest>> taggedRangeFacets;
        private final Map<String, List<FacetBase>> taggedQueryFacets;

        public static void initContext(ResponseBuilder rb) {
            String[] queries;
            ArrayList<RangeFacetRequest> facetRanges = null;
            ArrayList<FacetBase> facetQueries = null;
            String[] ranges = rb.req.getParams().getParams("facet.range");
            if (ranges != null) {
                facetRanges = new ArrayList<RangeFacetRequest>(ranges.length);
                for (String range : ranges) {
                    RangeFacetRequest rangeFacetRequest = new RangeFacetRequest(rb, range);
                    facetRanges.add(rangeFacetRequest);
                }
            }
            if ((queries = rb.req.getParams().getParams("facet.query")) != null) {
                facetQueries = new ArrayList<FacetBase>(queries.length);
                for (String query : queries) {
                    facetQueries.add(new FacetBase(rb, "facet.query", query));
                }
            }
            rb.req.getContext().put(FACET_CONTEXT_KEY, new FacetContext(facetRanges, facetQueries));
        }

        private FacetContext(List<RangeFacetRequest> allRangeFacets, List<FacetBase> allQueryFacets) {
            List<FacetBase> list;
            this.allRangeFacets = allRangeFacets == null ? Collections.emptyList() : allRangeFacets;
            this.allQueryFacets = allQueryFacets == null ? Collections.emptyList() : allQueryFacets;
            this.taggedRangeFacets = new HashMap<String, List<RangeFacetRequest>>();
            for (RangeFacetRequest rf : this.allRangeFacets) {
                for (String tag : rf.getTags()) {
                    list = this.taggedRangeFacets.get(tag);
                    if (list == null) {
                        list = new ArrayList<RangeFacetRequest>(1);
                        this.taggedRangeFacets.put(tag, list);
                    }
                    list.add(rf);
                }
            }
            this.taggedQueryFacets = new HashMap<String, List<FacetBase>>();
            for (FacetBase qf : this.allQueryFacets) {
                for (String tag : qf.getTags()) {
                    list = this.taggedQueryFacets.get(tag);
                    if (list == null) {
                        list = new ArrayList(1);
                        this.taggedQueryFacets.put(tag, list);
                    }
                    list.add((RangeFacetRequest)qf);
                }
            }
        }

        public static FacetContext getFacetContext(SolrQueryRequest req) throws IllegalStateException {
            FacetContext result = (FacetContext)req.getContext().get(FACET_CONTEXT_KEY);
            if (null == result) {
                throw new IllegalStateException("FacetContext can't be accessed before it's initialized in request context");
            }
            return result;
        }

        public List<RangeFacetRequest> getAllRangeFacetRequests() {
            return this.allRangeFacets;
        }

        public List<FacetBase> getAllQueryFacets() {
            return this.allQueryFacets;
        }

        public List<RangeFacetRequest> getRangeFacetRequestsForTag(String tag) {
            List<RangeFacetRequest> list = this.taggedRangeFacets.get(tag);
            return list == null ? Collections.emptyList() : list;
        }

        public List<FacetBase> getQueryFacetsForTag(String tag) {
            List<FacetBase> list = this.taggedQueryFacets.get(tag);
            return list == null ? Collections.emptyList() : list;
        }
    }
}

