/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jcip.annotations.ThreadSafe;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuditEvent;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationUtils;
import org.apache.solr.security.HttpServletAuthorizationContext;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.ServletUtils;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.TimeOut;
import org.apache.solr.util.tracing.TraceUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@ThreadSafe
public class HttpSolrCall {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ORIGINAL_USER_PRINCIPAL_HEADER = "originalUserPrincipal";
    public static final String INTERNAL_REQUEST_COUNT = "_forwardedCount";
    public static final Random random;
    protected final SolrDispatchFilter solrDispatchFilter;
    protected final CoreContainer cores;
    protected final HttpServletRequest req;
    protected final HttpServletResponse response;
    protected final boolean retry;
    protected SolrCore core = null;
    protected SolrQueryRequest solrReq = null;
    private boolean mustClearSolrRequestInfo = false;
    protected SolrRequestHandler handler = null;
    protected SolrParams queryParams;
    protected String path;
    protected SolrDispatchFilter.Action action;
    protected String coreUrl;
    protected SolrConfig config;
    protected Map<String, Integer> invalidStates;
    protected String origCorename;
    protected List<String> collectionsList;
    protected AuthorizationContext.RequestType requestType;
    static final String CONNECTION_HEADER = "Connection";
    static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    static final String CONTENT_LENGTH_HEADER = "Content-Length";
    List<CommandOperation> parsedCommands;

    public HttpSolrCall(SolrDispatchFilter solrDispatchFilter, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        this.solrDispatchFilter = solrDispatchFilter;
        this.cores = cores;
        this.req = request;
        this.response = response;
        this.retry = retry;
        this.requestType = AuthorizationContext.RequestType.UNKNOWN;
        this.req.setAttribute(HttpSolrCall.class.getName(), (Object)this);
        this.req.setAttribute("org.apache.solr.RequestTimer", (Object)new RTimerTree());
        this.req.setAttribute("org.apache.solr.CoreContainer", (Object)cores);
        this.path = ServletUtils.getPathAfterContext(this.req);
    }

    public String getPath() {
        return this.path;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public SolrParams getQueryParams() {
        return this.queryParams;
    }

    public List<String> getCollectionsList() {
        return this.collectionsList != null ? this.collectionsList : Collections.emptyList();
    }

    @SuppressForbidden(reason="Set the thread contextClassLoader for all 3rd party dependencies that we cannot control")
    protected void init() throws Exception {
        String alternate = this.cores.getManagementPath();
        if (alternate != null && this.path.startsWith(alternate)) {
            this.path = this.path.substring(0, alternate.length());
        }
        this.queryParams = SolrRequestParsers.parseQueryString(this.req.getQueryString());
        int idx = this.path.indexOf(58);
        if (idx > 0) {
            this.path = this.path.substring(0, idx);
        }
        this.handler = this.cores.getRequestHandler(this.path);
        if (this.handler != null) {
            this.solrReq = SolrRequestParsers.DEFAULT.parse(null, this.path, this.req);
            this.solrReq.getContext().put(CoreContainer.class.getName(), this.cores);
            this.requestType = AuthorizationContext.RequestType.ADMIN;
            this.action = SolrDispatchFilter.Action.ADMIN;
            return;
        }
        idx = this.path.indexOf(47, 1);
        if (idx > 1) {
            this.origCorename = this.path.substring(1, idx);
            this.core = this.cores.getCore(this.origCorename);
            if (this.core != null) {
                this.path = this.path.substring(idx);
            } else {
                if (this.cores.isCoreLoading(this.origCorename)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCore is loading");
                }
                this.core = this.cores.getCore(this.origCorename);
                if (this.core != null) {
                    this.path = this.path.substring(idx);
                } else if (!this.cores.isZooKeeperAware()) {
                    this.core = this.cores.getCore("");
                }
            }
        }
        if (this.cores.isZooKeeperAware()) {
            String def = this.core != null ? this.core.getCoreDescriptor().getCollectionName() : this.origCorename;
            this.collectionsList = this.resolveCollectionListOrAlias(this.queryParams.get("collection", def));
            if (this.core == null) {
                String collectionName = this.collectionsList.isEmpty() ? null : this.collectionsList.get(0);
                boolean isPreferLeader = this.path.endsWith("/update") || this.path.contains("/update/");
                this.core = this.getCoreByCollection(collectionName, isPreferLeader);
                if (this.core != null) {
                    if (idx > 0) {
                        this.path = this.path.substring(idx);
                    }
                } else {
                    if (idx > 0) {
                        this.extractRemotePath(collectionName, this.origCorename);
                        if (this.action == SolrDispatchFilter.Action.REMOTEQUERY) {
                            this.path = this.path.substring(idx);
                            return;
                        }
                    }
                    this.autoCreateSystemColl(collectionName);
                    if (this.action != null) {
                        return;
                    }
                }
            }
        }
        if (this.core != null) {
            Thread.currentThread().setContextClassLoader(this.core.getResourceLoader().getClassLoader());
            this.config = this.core.getSolrConfig();
            SolrRequestParsers parser = this.config.getRequestParsers();
            this.extractHandlerFromURLPath(parser);
            if (this.action != null) {
                return;
            }
            if (this.handler != null) {
                if (this.solrReq == null) {
                    this.solrReq = parser.parse(this.core, this.path, this.req);
                }
                this.invalidStates = this.checkStateVersionsAreValid(this.solrReq.getParams().get("_stateVer_"));
                this.addCollectionParamIfNeeded(this.getCollectionsList());
                this.action = SolrDispatchFilter.Action.PROCESS;
                return;
            }
        }
        log.debug("no handler or core retrieved for {}, follow through...", (Object)this.path);
        this.action = SolrDispatchFilter.Action.PASSTHROUGH;
    }

    protected void autoCreateSystemColl(String corename) throws Exception {
        if (this.core == null && ".system".equals(corename) && "POST".equals(this.req.getMethod()) && !this.cores.getZkController().getClusterState().hasCollection(".system")) {
            log.info("Going to auto-create {} collection", (Object)".system");
            SolrQueryResponse rsp = new SolrQueryResponse();
            String repFactor = String.valueOf(Math.min(3, this.cores.getZkController().getClusterState().getLiveNodes().size()));
            this.cores.getCollectionsHandler().handleRequestBody(new LocalSolrQueryRequest(null, (SolrParams)new ModifiableSolrParams().add("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()}).add("name", new String[]{".system"}).add("replicationFactor", new String[]{repFactor})), rsp);
            if (rsp.getValues().get("success") == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not auto-create .system collection: " + Utils.toJSONString(rsp.getValues()));
            }
            TimeOut timeOut = new TimeOut(3L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
            while (this.cores.getZkController().getClusterState().getCollectionOrNull(".system") == null) {
                if (timeOut.hasTimedOut()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find .system collection even after 3 seconds");
                }
                timeOut.sleep(50L);
            }
            this.action = SolrDispatchFilter.Action.RETRY;
        }
    }

    protected List<String> resolveCollectionListOrAlias(String collectionStr) {
        if (collectionStr == null || collectionStr.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List result = null;
        LinkedHashSet uniqueList = null;
        Aliases aliases = this.cores.getAliases();
        List inputCollections = StrUtils.splitSmart((String)collectionStr, (String)",", (boolean)true);
        if (inputCollections.size() > 1) {
            uniqueList = new LinkedHashSet();
        }
        for (String inputCollection : inputCollections) {
            List resolvedCollections = aliases.resolveAliases(inputCollection);
            if (uniqueList != null) {
                uniqueList.addAll(resolvedCollections);
                continue;
            }
            result = resolvedCollections;
        }
        if (uniqueList != null) {
            return new ArrayList<String>(uniqueList);
        }
        return result;
    }

    protected void extractHandlerFromURLPath(SolrRequestParsers parser) throws Exception {
        if (this.handler == null && this.path.length() > 1) {
            this.handler = this.core.getRequestHandler(this.path);
            if (this.handler == null && parser.isHandleSelect() && ("/select".equals(this.path) || "/select/".equals(this.path))) {
                this.solrReq = parser.parse(this.core, this.path, this.req);
                String qt = this.solrReq.getParams().get("qt");
                this.handler = this.core.getRequestHandler(qt);
                if (this.handler == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                }
                if (qt != null && qt.startsWith("/") && this.handler instanceof ContentStreamHandlerBase) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                }
            }
        }
    }

    protected void extractRemotePath(String collectionName, String origCorename) throws KeeperException, InterruptedException, SolrException {
        assert (this.core == null);
        this.coreUrl = this.getRemoteCoreUrl(collectionName, origCorename);
        this.invalidStates = this.checkStateVersionsAreValid(this.queryParams.get("_stateVer_"));
        if (this.coreUrl != null && this.queryParams.get("update.distrib") == null) {
            if (this.invalidStates != null) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, new String(Utils.toJSON(this.invalidStates), StandardCharsets.UTF_8));
            }
            this.action = SolrDispatchFilter.Action.REMOTEQUERY;
        } else if (!this.retry) {
            if (!this.cores.getZkController().getZkStateReader().aliasesManager.update() && !this.cores.getZkController().zkStateReader.getZkClient().exists(DocCollection.getCollectionPath((String)collectionName), true).booleanValue()) {
                return;
            }
            this.cores.getZkController().zkStateReader.forceUpdateCollection(collectionName);
            this.action = SolrDispatchFilter.Action.RETRY;
        }
    }

    protected void sendRemoteQuery() throws IOException {
        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.req, new SolrQueryResponse(), this.action));
        this.mustClearSolrRequestInfo = true;
        this.remoteQuery(this.coreUrl + this.path, this.response);
    }

    public SolrDispatchFilter.Action call() throws IOException {
        if (this.cores == null) {
            this.sendError(503, "Server is shutting down or failed to initialize");
            return SolrDispatchFilter.Action.RETURN;
        }
        if (this.solrDispatchFilter.abortErrorMessage != null) {
            this.sendError(500, this.solrDispatchFilter.abortErrorMessage);
            if (this.shouldAudit(AuditEvent.EventType.ERROR)) {
                this.cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.ERROR, this.getReq()));
            }
            return SolrDispatchFilter.Action.RETURN;
        }
        try {
            AuthorizationContext authzContext;
            AuthorizationUtils.AuthorizationFailure authzFailure;
            this.init();
            TraceUtils.ifNotNoop(this.getSpan(), this::populateTracingSpan);
            if (this.cores.getAuthorizationPlugin() != null && this.shouldAuthorize() && this.action != SolrDispatchFilter.Action.REMOTEQUERY && this.action != SolrDispatchFilter.Action.FORWARD && (authzFailure = AuthorizationUtils.authorize(this.req, this.response, this.cores, authzContext = this.getAuthCtx())) != null) {
                this.sendError(authzFailure.getStatusCode(), authzFailure.getMessage());
                return SolrDispatchFilter.Action.RETURN;
            }
            HttpServletResponse resp = this.response;
            switch (this.action) {
                case ADMIN_OR_REMOTEQUERY: {
                    this.handleAdminOrRemoteRequest();
                    return SolrDispatchFilter.Action.RETURN;
                }
                case ADMIN: {
                    this.handleAdminRequest();
                    return SolrDispatchFilter.Action.RETURN;
                }
                case REMOTEQUERY: {
                    this.sendRemoteQuery();
                    return SolrDispatchFilter.Action.RETURN;
                }
                case PROCESS: {
                    Method reqMethod = Method.getMethod(this.req.getMethod());
                    HttpCacheHeaderUtil.setCacheControlHeader(this.config, resp, reqMethod);
                    if (this.config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(this.solrReq, this.req, reqMethod, resp)) {
                        SolrQueryResponse solrRsp = new SolrQueryResponse();
                        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.solrReq, solrRsp, this.action));
                        this.mustClearSolrRequestInfo = true;
                        this.executeCoreRequest(solrRsp);
                        if (HttpSolrCall.shouldAudit(this.cores)) {
                            AuditEvent.EventType eventType;
                            AuditEvent.EventType eventType2 = eventType = solrRsp.getException() == null ? AuditEvent.EventType.COMPLETED : AuditEvent.EventType.ERROR;
                            if (HttpSolrCall.shouldAudit(this.cores, eventType)) {
                                this.cores.getAuditLoggerPlugin().doAudit(new AuditEvent(eventType, this.req, this.getAuthCtx(), this.solrReq.getRequestTimer().getTime(), solrRsp.getException()));
                            }
                        }
                        HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                        Iterator<Map.Entry<String, String>> headers = solrRsp.httpHeaders();
                        while (headers.hasNext()) {
                            Map.Entry<String, String> entry = headers.next();
                            resp.addHeader(entry.getKey(), entry.getValue());
                        }
                        QueryResponseWriter responseWriter = this.getResponseWriter();
                        if (this.invalidStates != null) {
                            this.solrReq.getContext().put("_stateVer_", this.invalidStates);
                        }
                        this.writeResponse(solrRsp, responseWriter, reqMethod);
                    }
                    return SolrDispatchFilter.Action.RETURN;
                }
            }
            return this.action;
        }
        catch (Throwable ex) {
            if (this.shouldAudit(AuditEvent.EventType.ERROR)) {
                this.cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.ERROR, ex, this.req));
            }
            this.sendError(ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof Error)) continue;
                if (t != ex) {
                    log.error("An Error was wrapped in another exception - please report complete stacktrace on SOLR-6161", ex);
                }
                throw (Error)t;
            }
            return SolrDispatchFilter.Action.RETURN;
        }
    }

    protected void handleAdminOrRemoteRequest() throws IOException {
        throw new IllegalStateException("handleOrForwardRequest should not be invoked when serving v1 requests.");
    }

    protected Span getSpan() {
        return (Span)Objects.requireNonNull(this.req.getAttribute(Span.class.getName()));
    }

    protected void populateTracingSpan(Span span) {
        String coreOrColName = this.getCoreOrColName();
        if (coreOrColName != null) {
            span.setTag((Tag)Tags.DB_INSTANCE, (Object)coreOrColName);
        }
        Object path = this.getPath();
        if (coreOrColName != null) {
            path = this.getCore() != null && this.getCore().getName().equals(coreOrColName) ? "/{core}" + (String)path : "/{collection}" + (String)path;
        }
        String verb = this.getQueryParams().get("action", this.req.getMethod()).toLowerCase(Locale.ROOT);
        span.setOperationName(verb + ":" + (String)path);
    }

    protected String getCoreOrColName() {
        String coreOrColName = this.origCorename;
        if (coreOrColName == null && this.getCore() != null) {
            coreOrColName = this.getCore().getName();
        }
        return coreOrColName;
    }

    public boolean shouldAudit() {
        return HttpSolrCall.shouldAudit(this.cores);
    }

    public boolean shouldAudit(AuditEvent.EventType eventType) {
        return HttpSolrCall.shouldAudit(this.cores, eventType);
    }

    public static boolean shouldAudit(CoreContainer cores) {
        return cores.getAuditLoggerPlugin() != null;
    }

    public static boolean shouldAudit(CoreContainer cores, AuditEvent.EventType eventType) {
        return HttpSolrCall.shouldAudit(cores) && cores.getAuditLoggerPlugin().shouldLog(eventType);
    }

    private boolean shouldAuthorize() {
        if ("/admin/info/key".equals(this.path)) {
            return false;
        }
        if ("/".equals(this.path) || "/solr/".equals(this.path)) {
            return false;
        }
        if (this.cores.getPkiAuthenticationSecurityBuilder() != null && this.req.getUserPrincipal() != null) {
            boolean b = this.cores.getPkiAuthenticationSecurityBuilder().needsAuthorization(this.req);
            log.debug("PkiAuthenticationPlugin says authorization required : {} ", (Object)b);
            return b;
        }
        return true;
    }

    void destroy() {
        try {
            if (this.solrReq != null) {
                log.debug("Closing out SolrRequest: {}", (Object)this.solrReq);
                this.solrReq.close();
            }
        }
        finally {
            try {
                if (this.core != null) {
                    this.core.close();
                }
            }
            finally {
                if (this.mustClearSolrRequestInfo) {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            AuthenticationPlugin authcPlugin = this.cores.getAuthenticationPlugin();
            if (authcPlugin != null) {
                authcPlugin.closeRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteQuery(String coreUrl, HttpServletResponse resp) throws IOException {
        HttpEntity httpEntity = null;
        ModifiableSolrParams updatedQueryParams = new ModifiableSolrParams(this.queryParams);
        int forwardCount = this.queryParams.getInt(INTERNAL_REQUEST_COUNT, 0) + 1;
        updatedQueryParams.set(INTERNAL_REQUEST_COUNT, forwardCount);
        String queryStr = updatedQueryParams.toQueryString();
        try {
            HttpGet method;
            boolean isPostOrPutRequest;
            String urlstr = coreUrl + queryStr;
            boolean bl = isPostOrPutRequest = "POST".equals(this.req.getMethod()) || "PUT".equals(this.req.getMethod());
            if ("GET".equals(this.req.getMethod())) {
                method = new HttpGet(urlstr);
            } else if ("HEAD".equals(this.req.getMethod())) {
                method = new HttpHead(urlstr);
            } else if (isPostOrPutRequest) {
                HttpPost entityRequest = "POST".equals(this.req.getMethod()) ? new HttpPost(urlstr) : new HttpPut(urlstr);
                ServletInputStream in = this.req.getInputStream();
                InputStreamEntity entity = new InputStreamEntity((InputStream)in, (long)this.req.getContentLength());
                entityRequest.setEntity((HttpEntity)entity);
                method = entityRequest;
            } else if ("DELETE".equals(this.req.getMethod())) {
                method = new HttpDelete(urlstr);
            } else if ("OPTIONS".equals(this.req.getMethod())) {
                method = new HttpOptions(urlstr);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected method type: " + this.req.getMethod());
            }
            Enumeration e = this.req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                if ("host".equalsIgnoreCase(headerName) || "authorization".equalsIgnoreCase(headerName) || "accept".equalsIgnoreCase(headerName)) continue;
                method.addHeader(headerName, this.req.getHeader(headerName));
            }
            if (method instanceof HttpEntityEnclosingRequest) {
                method.removeHeaders(TRANSFER_ENCODING_HEADER);
                method.removeHeaders(CONTENT_LENGTH_HEADER);
            }
            HttpResponse response = this.solrDispatchFilter.getHttpClient().execute((HttpUriRequest)method, (HttpContext)HttpClientUtil.createNewHttpClientRequestContext());
            int httpStatus = response.getStatusLine().getStatusCode();
            httpEntity = response.getEntity();
            resp.setStatus(httpStatus);
            HeaderIterator responseHeaders = response.headerIterator();
            while (responseHeaders.hasNext()) {
                Header header = responseHeaders.nextHeader();
                if (header == null || header.getName().equalsIgnoreCase(TRANSFER_ENCODING_HEADER) || header.getName().equalsIgnoreCase(CONNECTION_HEADER)) continue;
                resp.setHeader(header.getName(), header.getValue());
            }
            if (httpEntity != null) {
                if (httpEntity.getContentEncoding() != null) {
                    resp.setHeader(httpEntity.getContentEncoding().getName(), httpEntity.getContentEncoding().getValue());
                }
                if (httpEntity.getContentType() != null) {
                    resp.setContentType(httpEntity.getContentType().getValue());
                }
                InputStream is = httpEntity.getContent();
                ServletOutputStream os = resp.getOutputStream();
                is.transferTo((OutputStream)os);
            }
            Utils.consumeFully((HttpEntity)httpEntity);
        }
        catch (IOException e) {
            this.sendError(new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error trying to proxy request for url: " + coreUrl + " with _forwardCount: " + forwardCount, (Throwable)e));
        }
        finally {
            Utils.consumeFully(httpEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendError(Throwable ex) throws IOException {
        Exception exp = null;
        SolrCore localCore = null;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        if (ex instanceof Exception) {
            solrResp.setException((Exception)ex);
        } else {
            solrResp.setException(new RuntimeException(ex));
        }
        localCore = this.core;
        if (this.solrReq == null) {
            void var5_9;
            if (this.req != null) {
                MultiMapSolrParams multiMapSolrParams = SolrRequestParsers.parseQueryString(this.req.getQueryString());
            } else {
                MapSolrParams mapSolrParams = new MapSolrParams(Collections.emptyMap());
            }
            this.solrReq = new SolrQueryRequestBase(this.core, (SolrParams)var5_9){};
        }
        QueryResponseWriter queryResponseWriter = this.getResponseWriter();
        this.writeResponse(solrResp, queryResponseWriter, Method.GET);
        try {
            if (exp == null) return;
            SimpleOrderedMap info = new SimpleOrderedMap();
            int n = ResponseUtils.getErrorInfo(ex, (NamedList<Object>)info, log, localCore != null && localCore.getCoreContainer().hideStackTrace());
            this.sendError(n, info.toString());
            return;
        }
        finally {
            if (this.core == null && localCore != null) {
                localCore.close();
            }
        }
        catch (Exception e) {
            try {
                exp = e;
            }
            catch (Throwable throwable) {
                try {
                    if (exp == null) throw throwable;
                    SimpleOrderedMap info = new SimpleOrderedMap();
                    int code = ResponseUtils.getErrorInfo(ex, (NamedList<Object>)info, log, localCore != null && localCore.getCoreContainer().hideStackTrace());
                    this.sendError(code, info.toString());
                    throw throwable;
                }
                finally {
                    if (this.core == null && localCore != null) {
                        localCore.close();
                    }
                }
            }
            try {
                if (exp == null) return;
                SimpleOrderedMap info = new SimpleOrderedMap();
                int n = ResponseUtils.getErrorInfo(ex, (NamedList<Object>)info, log, localCore != null && localCore.getCoreContainer().hideStackTrace());
                this.sendError(n, info.toString());
                return;
            }
            finally {
                if (this.core == null && localCore != null) {
                    localCore.close();
                }
            }
        }
    }

    protected void sendError(int code, String message) throws IOException {
        try {
            this.response.sendError(code, message);
        }
        catch (EOFException e) {
            log.info("Unable to write error response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    protected void executeCoreRequest(SolrQueryResponse rsp) {
        this.solrReq.getContext().put("webapp", this.req.getContextPath());
        this.solrReq.getCore().execute(this.handler, this.solrReq, rsp);
    }

    private void handleAdminRequest() throws IOException {
        SolrQueryResponse solrResp = new SolrQueryResponse();
        this.handleAdmin(solrResp);
        this.logAndFlushAdminRequest(solrResp);
    }

    protected void logAndFlushAdminRequest(SolrQueryResponse solrResp) throws IOException {
        QueryResponseWriter respWriter;
        if (solrResp.getToLog().size() > 0 && log.isInfoEnabled()) {
            log.info(this.handler != null ? MarkerFactory.getMarker((String)this.handler.getClass().getName()) : MarkerFactory.getMarker((String)HttpSolrCall.class.getName()), solrResp.getToLogAsString("[admin]"));
        }
        if ((respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(this.solrReq.getParams().get("wt"))) == null) {
            respWriter = this.getResponseWriter();
        }
        this.writeResponse(solrResp, respWriter, Method.getMethod(this.req.getMethod()));
        if (this.shouldAudit()) {
            AuditEvent.EventType eventType;
            AuditEvent.EventType eventType2 = eventType = solrResp.getException() == null ? AuditEvent.EventType.COMPLETED : AuditEvent.EventType.ERROR;
            if (this.shouldAudit(eventType)) {
                this.cores.getAuditLoggerPlugin().doAudit(new AuditEvent(eventType, this.req, this.getAuthCtx(), this.solrReq.getRequestTimer().getTime(), solrResp.getException()));
            }
        }
    }

    protected QueryResponseWriter getResponseWriter() {
        String wt = this.solrReq.getParams().get("wt");
        if (this.core != null) {
            return this.core.getQueryResponseWriter(wt);
        }
        return SolrCore.DEFAULT_RESPONSE_WRITERS.getOrDefault(wt, SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard"));
    }

    protected void handleAdmin(SolrQueryResponse solrResp) {
        SolrCore.preDecorateResponse(this.solrReq, solrResp);
        this.handler.handleRequest(this.solrReq, solrResp);
        SolrCore.postDecorateResponse(this.handler, this.solrReq, solrResp);
    }

    protected void addCollectionParamIfNeeded(List<String> collections) {
        if (collections.isEmpty()) {
            return;
        }
        assert (this.cores.isZooKeeperAware());
        String collectionParam = this.queryParams.get("collection");
        if (collectionParam == null && this.core != null && collections.equals(Collections.singletonList(this.core.getCoreDescriptor().getCollectionName()))) {
            return;
        }
        String newCollectionParam = StrUtils.join(collections, (char)',');
        if (newCollectionParam.equals(collectionParam)) {
            return;
        }
        ModifiableSolrParams params = new ModifiableSolrParams(this.solrReq.getParams());
        params.set("collection", new String[]{newCollectionParam});
        this.solrReq.setParams((SolrParams)params);
    }

    protected void writeResponse(SolrQueryResponse solrRsp, QueryResponseWriter responseWriter, Method reqMethod) throws IOException {
        try {
            String ct;
            Object invalidStates = this.solrReq.getContext().get("_stateVer_");
            if (invalidStates != null) {
                solrRsp.add("_stateVer_", invalidStates);
            }
            if (null != (ct = responseWriter.getContentType(this.solrReq, solrRsp))) {
                this.response.setContentType(ct);
            }
            if (solrRsp.getException() != null) {
                SimpleOrderedMap info = new SimpleOrderedMap();
                int code = ResponseUtils.getErrorInfo(solrRsp.getException(), (NamedList<Object>)info, log, this.core != null && this.core.getCoreContainer().hideStackTrace());
                solrRsp.add("error", info);
                this.response.setStatus(code);
            }
            if (Method.HEAD != reqMethod) {
                ServletOutputStream out = this.response.getOutputStream();
                QueryResponseWriterUtil.writeQueryResponse((OutputStream)out, responseWriter, this.solrReq, solrRsp, ct);
            }
        }
        catch (EOFException e) {
            log.info("Unable to write response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    private Map<String, Integer> checkStateVersionsAreValid(String stateVer) {
        HashMap<String, Integer> result = null;
        if (stateVer != null && !stateVer.isEmpty() && this.cores.isZooKeeperAware()) {
            String[] pairs;
            for (String pair : pairs = stateVer.split("\\|")) {
                Integer status;
                String[] pcs = pair.split(":");
                if (pcs.length != 2 || pcs[0].isEmpty() || pcs[1].isEmpty() || (status = this.cores.getZkController().getZkStateReader().compareStateVersions(pcs[0], Integer.parseInt(pcs[1]))) == null) continue;
                if (result == null) {
                    result = new HashMap<String, Integer>();
                }
                result.put(pcs[0], status);
            }
        }
        return result;
    }

    protected SolrCore getCoreByCollection(String collectionName, boolean isPreferLeader) {
        List leaderReplicas;
        SolrCore core;
        ZkStateReader zkStateReader = this.cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection collection = clusterState.getCollectionOrNull(collectionName, true);
        if (collection == null) {
            return null;
        }
        Set liveNodes = clusterState.getLiveNodes();
        if (isPreferLeader && (core = this.randomlyGetSolrCore(liveNodes, leaderReplicas = collection.getLeaderReplicas(this.cores.getZkController().getNodeName()))) != null) {
            return core;
        }
        List replicas = collection.getReplicas(this.cores.getZkController().getNodeName());
        return this.randomlyGetSolrCore(liveNodes, replicas);
    }

    private SolrCore randomlyGetSolrCore(Set<String> liveNodes, List<Replica> replicas) {
        if (replicas != null) {
            RandomIterator<Replica> it = new RandomIterator<Replica>(random, replicas);
            while (it.hasNext()) {
                SolrCore core;
                Replica replica = it.next();
                if (!liveNodes.contains(replica.getNodeName()) || replica.getState() != Replica.State.ACTIVE || (core = this.checkProps((ZkNodeProps)replica)) == null) continue;
                return core;
            }
        }
        return null;
    }

    private SolrCore checkProps(ZkNodeProps zkProps) {
        SolrCore core = null;
        if (this.cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = this.cores.getCore(corename);
        }
        return core;
    }

    private void getSlicesForCollections(ClusterState clusterState, Collection<Slice> slices, boolean activeSlices) {
        if (activeSlices) {
            for (Map.Entry entry : clusterState.getCollectionsMap().entrySet()) {
                Slice[] activeCollectionSlices = ((DocCollection)entry.getValue()).getActiveSlicesArr();
                if (activeCollectionSlices == null) continue;
                Collections.addAll(slices, activeCollectionSlices);
            }
        } else {
            for (Map.Entry entry : clusterState.getCollectionsMap().entrySet()) {
                Collection collectionSlices = ((DocCollection)entry.getValue()).getSlices();
                if (collectionSlices == null) continue;
                slices.addAll(collectionSlices);
            }
        }
    }

    protected String getRemoteCoreUrl(String collectionName, String origCorename) throws SolrException {
        ClusterState clusterState = this.cores.getZkController().getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(collectionName);
        Slice[] slices = docCollection != null ? docCollection.getActiveSlicesArr() : null;
        ArrayList<Slice> activeSlices = new ArrayList<Slice>();
        boolean byCoreName = false;
        int totalReplicas = 0;
        if (slices == null) {
            byCoreName = true;
            activeSlices = new ArrayList();
            this.getSlicesForCollections(clusterState, activeSlices, true);
            if (activeSlices.isEmpty()) {
                this.getSlicesForCollections(clusterState, activeSlices, false);
            }
        } else {
            Collections.addAll(activeSlices, slices);
        }
        for (Slice s : activeSlices) {
            totalReplicas += s.getReplicas().size();
        }
        if (activeSlices.isEmpty()) {
            return null;
        }
        if (!this.collectionsList.contains(collectionName)) {
            this.collectionsList = new ArrayList<String>(this.collectionsList);
            this.collectionsList.add(collectionName);
        }
        if (this.queryParams.getInt(INTERNAL_REQUEST_COUNT, 0) > totalReplicas) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "No active replicas found for collection: " + collectionName);
        }
        String coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, activeSlices, byCoreName, true);
        if (coreUrl == null) {
            coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, activeSlices, byCoreName, false);
        }
        return coreUrl;
    }

    private String getCoreUrl(String collectionName, String origCorename, ClusterState clusterState, List<Slice> slices, boolean byCoreName, boolean activeReplicas) {
        Set liveNodes = clusterState.getLiveNodes();
        Collections.shuffle(slices, random);
        for (Slice slice : slices) {
            ArrayList randomizedReplicas = new ArrayList(slice.getReplicas());
            Collections.shuffle(randomizedReplicas, random);
            for (Replica replica : randomizedReplicas) {
                Object coreUrl;
                if (activeReplicas && (!liveNodes.contains(replica.getNodeName()) || replica.getState() != Replica.State.ACTIVE) || byCoreName && !Objects.equals(origCorename, replica.getStr("core")) || Objects.equals(replica.getBaseUrl(), this.cores.getZkController().getBaseUrl())) continue;
                if (origCorename != null) {
                    coreUrl = replica.getBaseUrl() + "/" + origCorename;
                } else {
                    coreUrl = replica.getCoreUrl();
                    if (((String)coreUrl).endsWith("/")) {
                        coreUrl = ((String)coreUrl).substring(0, ((String)coreUrl).length() - 1);
                    }
                }
                return coreUrl;
            }
        }
        return null;
    }

    protected Object _getHandler() {
        return this.handler;
    }

    private AuthorizationContext getAuthCtx() {
        final String resource = this.getPath();
        final List<AuthorizationContext.CollectionRequest> collectionRequests = AuthorizationUtils.getCollectionRequests(this.getPath(), this.getCollectionsList(), this.getQueryParams());
        if (this.requestType == AuthorizationContext.RequestType.UNKNOWN) {
            if (resource.startsWith("/select") || resource.startsWith("/get")) {
                this.requestType = AuthorizationContext.RequestType.READ;
            }
            if (resource.startsWith("/update")) {
                this.requestType = AuthorizationContext.RequestType.WRITE;
            }
        }
        return new HttpServletAuthorizationContext(this.getReq()){

            @Override
            public SolrParams getParams() {
                return null == HttpSolrCall.this.solrReq ? null : HttpSolrCall.this.solrReq.getParams();
            }

            @Override
            public List<AuthorizationContext.CollectionRequest> getCollectionRequests() {
                return collectionRequests;
            }

            @Override
            public String getResource() {
                return HttpSolrCall.this.path;
            }

            @Override
            public AuthorizationContext.RequestType getRequestType() {
                return HttpSolrCall.this.requestType;
            }

            @Override
            public Object getHandler() {
                return HttpSolrCall.this._getHandler();
            }

            public String toString() {
                StringBuilder response = new StringBuilder("userPrincipal: [").append(this.getUserPrincipal()).append("]").append(" type: [").append(HttpSolrCall.this.requestType.toString()).append("], collections: [");
                for (AuthorizationContext.CollectionRequest collectionRequest : collectionRequests) {
                    response.append(collectionRequest.collectionName).append(", ");
                }
                if (collectionRequests.size() > 0) {
                    response.delete(response.length() - 1, response.length());
                }
                response.append("], Path: [").append(resource).append("]");
                response.append(" path : ").append(HttpSolrCall.this.path).append(" params :").append(this.getParams());
                return response.toString();
            }
        };
    }

    public List<CommandOperation> getCommands(boolean validateInput) {
        if (this.parsedCommands == null) {
            Iterable<ContentStream> contentStreams = this.solrReq.getContentStreams();
            this.parsedCommands = contentStreams == null ? Collections.emptyList() : ApiBag.getCommandOperations(contentStreams.iterator().next(), this.getValidators(), validateInput);
        }
        return CommandOperation.clone(this.parsedCommands);
    }

    protected ValidatingJsonMap getSpec() {
        return null;
    }

    protected Map<String, JsonSchemaValidator> getValidators() {
        return Collections.emptyMap();
    }

    static {
        String seed = System.getProperty("tests.seed");
        random = seed == null ? new Random() : new Random(seed.hashCode());
    }

    private static class RandomIterator<E>
    implements Iterator<E> {
        private Random rand;
        private ArrayList<E> elements;
        private int size;

        public RandomIterator(Random rand, Collection<E> elements) {
            this.rand = rand;
            this.elements = new ArrayList<E>(elements);
            this.size = elements.size();
        }

        @Override
        public boolean hasNext() {
            return this.size > 0;
        }

        @Override
        public E next() {
            int idx = this.rand.nextInt(this.size);
            E e1 = this.elements.get(idx);
            E e2 = this.elements.get(this.size - 1);
            this.elements.set(idx, e2);
            --this.size;
            return e1;
        }
    }
}

