/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uninverting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.uninverting.FieldCache;

public class UninvertingReader
extends FilterLeafReader {
    final Function<String, Type> mapping;
    final FieldInfos fieldInfos;

    public static DirectoryReader wrap(DirectoryReader reader, Map<String, Type> mapping) throws IOException {
        return UninvertingReader.wrap(reader, mapping::get);
    }

    public static DirectoryReader wrap(DirectoryReader in, Function<String, Type> mapper) throws IOException {
        return new UninvertingDirectoryReader(in, mapper);
    }

    public static LeafReader wrap(LeafReader in, Function<String, Type> mapping) {
        boolean wrap = false;
        ArrayList<FieldInfo> newFieldInfos = new ArrayList<FieldInfo>(in.getFieldInfos().size());
        for (FieldInfo fi : in.getFieldInfos()) {
            Type t;
            DocValuesType type = fi.getDocValuesType();
            if (type == DocValuesType.NONE && (fi.getIndexOptions() != IndexOptions.NONE || fi.getPointNumBytes() > 0 && fi.getPointDimensionCount() == 1) && (t = mapping.apply(fi.name)) != null) {
                if (t == Type.INTEGER_POINT || t == Type.LONG_POINT || t == Type.FLOAT_POINT || t == Type.DOUBLE_POINT ? fi.getPointDimensionCount() == 0 : fi.getIndexOptions() == IndexOptions.NONE) continue;
                switch (t) {
                    case INTEGER_POINT: 
                    case LONG_POINT: 
                    case FLOAT_POINT: 
                    case DOUBLE_POINT: 
                    case LEGACY_INTEGER: 
                    case LEGACY_LONG: 
                    case LEGACY_FLOAT: 
                    case LEGACY_DOUBLE: {
                        type = DocValuesType.NUMERIC;
                        break;
                    }
                    case BINARY: {
                        type = DocValuesType.BINARY;
                        break;
                    }
                    case SORTED: {
                        type = DocValuesType.SORTED;
                        break;
                    }
                    case SORTED_SET_BINARY: 
                    case SORTED_SET_INTEGER: 
                    case SORTED_SET_FLOAT: 
                    case SORTED_SET_LONG: 
                    case SORTED_SET_DOUBLE: {
                        type = DocValuesType.SORTED_SET;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            if (type != fi.getDocValuesType()) {
                wrap = true;
                newFieldInfos.add(new FieldInfo(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), type, fi.getDocValuesGen(), fi.attributes(), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField()));
                continue;
            }
            newFieldInfos.add(fi);
        }
        if (!wrap) {
            return in;
        }
        FieldInfos fieldInfos = new FieldInfos(newFieldInfos.toArray(new FieldInfo[0]));
        return new UninvertingReader(in, mapping, fieldInfos);
    }

    private UninvertingReader(LeafReader in, Function<String, Type> mapping, FieldInfos fieldInfos) {
        super(in);
        this.mapping = mapping;
        this.fieldInfos = fieldInfos;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        NumericDocValues values = super.getNumericDocValues(field);
        if (values != null) {
            return values;
        }
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case INTEGER_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.INT_POINT_PARSER);
                }
                case FLOAT_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.FLOAT_POINT_PARSER);
                }
                case LONG_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LONG_POINT_PARSER);
                }
                case DOUBLE_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.DOUBLE_POINT_PARSER);
                }
                case LEGACY_INTEGER: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_INT_PARSER);
                }
                case LEGACY_FLOAT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_FLOAT_PARSER);
                }
                case LEGACY_LONG: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_LONG_PARSER);
                }
                case LEGACY_DOUBLE: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_DOUBLE_PARSER);
                }
            }
        }
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues values = this.in.getBinaryDocValues(field);
        if (values != null) {
            return values;
        }
        Type v = this.getType(field);
        if (v == Type.BINARY) {
            return FieldCache.DEFAULT.getTerms(this.in, field);
        }
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        SortedDocValues values = this.in.getSortedDocValues(field);
        if (values != null) {
            return values;
        }
        Type v = this.getType(field);
        if (v == Type.SORTED) {
            return FieldCache.DEFAULT.getTermsIndex(this.in, field);
        }
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        SortedSetDocValues values = this.in.getSortedSetDocValues(field);
        if (values != null) {
            return values;
        }
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case SORTED_SET_INTEGER: 
                case SORTED_SET_FLOAT: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT32_TERM_PREFIX);
                }
                case SORTED_SET_LONG: 
                case SORTED_SET_DOUBLE: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT64_TERM_PREFIX);
                }
                case SORTED_SET_BINARY: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, null);
                }
            }
        }
        return null;
    }

    private Type getType(String field) {
        return this.mapping.apply(field);
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public String toString() {
        return "Uninverting(" + this.in.toString() + ")";
    }

    public static FieldCacheStats getUninvertedStats() {
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        long totalBytesUsed = 0L;
        String[] info = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            info[i] = entries[i].toString();
            totalBytesUsed += entries[i].getValue().ramBytesUsed();
        }
        String totalSize = RamUsageEstimator.humanReadableUnits((long)totalBytesUsed);
        return new FieldCacheStats(totalSize, info);
    }

    public static int getUninvertedStatsSize() {
        return FieldCache.DEFAULT.getCacheEntries().length;
    }

    public static class FieldCacheStats {
        public String totalSize;
        public String[] info;

        public FieldCacheStats(String totalSize, String[] info) {
            this.totalSize = totalSize;
            this.info = info;
        }
    }

    static class UninvertingDirectoryReader
    extends FilterDirectoryReader {
        final Function<String, Type> mapper;

        public UninvertingDirectoryReader(DirectoryReader in, final Function<String, Type> mapper) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return UninvertingReader.wrap(reader, (Function<String, Type>)mapper);
                }
            });
            this.mapper = mapper;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new UninvertingDirectoryReader(in, this.mapper);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    public static enum Type {
        INTEGER_POINT,
        LONG_POINT,
        FLOAT_POINT,
        DOUBLE_POINT,
        LEGACY_INTEGER,
        LEGACY_LONG,
        LEGACY_FLOAT,
        LEGACY_DOUBLE,
        BINARY,
        SORTED,
        SORTED_SET_BINARY,
        SORTED_SET_INTEGER,
        SORTED_SET_FLOAT,
        SORTED_SET_LONG,
        SORTED_SET_DOUBLE;

    }
}

