/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.LongSet;
import org.apache.solr.util.OrderedExecutor;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLog
implements PluginInfoInitialized,
SolrMetricProducer {
    private static final long STATUS_TIME = TimeUnit.NANOSECONDS.convert(60L, TimeUnit.SECONDS);
    public static String LOG_FILENAME_PATTERN = "%s.%019d";
    public static String TLOG_NAME = "tlog";
    public static String BUFFER_TLOG_NAME = "buffer.tlog";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();
    private boolean trace = log.isTraceEnabled();
    private boolean usableForChildDocs;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int DELETE_BY_QUERY = 3;
    public static final int COMMIT = 4;
    public static final int UPDATE_INPLACE = 8;
    public static final int OPERATION_MASK = 15;
    public static final int FLAGS_IDX = 0;
    public static final int VERSION_IDX = 1;
    public static final int PREV_POINTER_IDX = 2;
    public static final int PREV_VERSION_IDX = 3;
    protected long id = -1L;
    protected volatile State state = State.ACTIVE;
    protected TransactionLog bufferTlog;
    protected TransactionLog tlog;
    protected TransactionLog prevTlog;
    protected TransactionLog prevTlogOnPrecommit;
    protected final Deque<TransactionLog> logs = new ArrayDeque<TransactionLog>();
    protected Deque<TransactionLog> newestLogsOnStartup = new ArrayDeque<TransactionLog>();
    protected int numOldRecords;
    protected Map<BytesRef, LogPtr> map = new HashMap<BytesRef, LogPtr>();
    protected Map<BytesRef, LogPtr> prevMap;
    protected Map<BytesRef, LogPtr> prevMap2;
    protected TransactionLog prevMapLog;
    protected TransactionLog prevMapLog2;
    protected final int numDeletesToKeep = 1000;
    protected final int numDeletesByQueryToKeep = 100;
    protected int numRecordsToKeep;
    protected int maxNumLogsToKeep;
    protected int numVersionBuckets;
    protected boolean existOldBufferLog = false;
    protected LinkedHashMap<BytesRef, LogPtr> oldDeletes = new OldDeletesLinkedHashMap(this.numDeletesToKeep);
    protected LinkedList<DBQ> deleteByQueries = new LinkedList();
    protected String[] tlogFiles;
    protected Path tlogDir;
    protected Collection<String> globalStrings;
    protected String dataDir;
    protected String lastDataDir;
    protected VersionInfo versionInfo;
    protected SyncLevel defaultSyncLevel = SyncLevel.FLUSH;
    protected volatile UpdateHandler uhandler;
    protected volatile boolean cancelApplyBufferUpdate;
    protected List<Long> startingVersions;
    protected Gauge<Integer> bufferedOpsGauge;
    protected Meter applyingBufferedOpsMeter;
    protected Meter replayOpsMeter;
    protected Meter copyOverOldUpdatesMeter;
    protected SolrMetricsContext solrMetricsContext;
    public static Runnable testing_logReplayHook;
    public static Runnable testing_logReplayFinishHook;
    protected RecoveryInfo recoveryInfo;
    ThreadPoolExecutor recoveryExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("recoveryExecutor"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalLogsSize() {
        long size = 0L;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            for (TransactionLog log : this.logs) {
                size += log.getLogSize();
            }
        }
        return size;
    }

    public synchronized long getCurrentLogSizeFromStream() {
        return this.tlog == null ? 0L : this.tlog.getLogSizeFromStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalLogsNumber() {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            return this.logs.size();
        }
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public int getNumRecordsToKeep() {
        return this.numRecordsToKeep;
    }

    public int getMaxNumLogsToKeep() {
        return this.maxNumLogsToKeep;
    }

    public int getNumVersionBuckets() {
        return this.numVersionBuckets;
    }

    protected static int objToInt(Object obj, int def) {
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return def;
    }

    @Override
    public void init(PluginInfo info) {
        this.dataDir = (String)info.initArgs.get("dir");
        this.defaultSyncLevel = SyncLevel.getSyncLevel((String)info.initArgs.get("syncLevel"));
        this.numRecordsToKeep = UpdateLog.objToInt(info.initArgs.get("numRecordsToKeep"), 100);
        this.maxNumLogsToKeep = UpdateLog.objToInt(info.initArgs.get("maxNumLogsToKeep"), 10);
        this.numVersionBuckets = UpdateLog.objToInt(info.initArgs.get("numVersionBuckets"), 65536);
        if (this.numVersionBuckets <= 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Number of version buckets must be greater than 0!");
        }
        log.info("Initializing UpdateLog: dataDir={} defaultSyncLevel={} numRecordsToKeep={} maxNumLogsToKeep={} numVersionBuckets={}", new Object[]{this.dataDir, this.defaultSyncLevel, this.numRecordsToKeep, this.maxNumLogsToKeep, this.numVersionBuckets});
    }

    public void init(UpdateHandler uhandler, SolrCore core) {
        this.dataDir = core.getUlogDir();
        this.uhandler = uhandler;
        this.usableForChildDocs = core.getLatestSchema().isUsableForChildDocs();
        if (this.dataDir.equals(this.lastDataDir)) {
            this.versionInfo.reload();
            core.getCoreMetricManager().registerMetricProducer(SolrInfoBean.Category.TLOG.toString(), this);
            if (this.debug) {
                log.debug("UpdateHandler init: tlogDir={}, next id={} this is a reopen...nothing else to do", (Object)this.tlogDir, (Object)this.id);
            }
            return;
        }
        this.lastDataDir = this.dataDir;
        this.tlogDir = Path.of(this.dataDir, TLOG_NAME);
        try {
            Files.createDirectories(this.tlogDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not set up tlogs", (Throwable)e);
        }
        this.tlogFiles = this.getLogList(this.tlogDir.toFile());
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir={}, existing tlogs={}, next id={}", new Object[]{this.tlogDir, Arrays.asList(this.tlogFiles), this.id});
        }
        String prefix = BUFFER_TLOG_NAME + ".";
        try (Stream<Path> bufferedTLogs = Files.walk(this.tlogDir, 1, new FileVisitOption[0]);){
            this.existOldBufferLog = bufferedTLogs.anyMatch(path -> path.getFileName().toString().startsWith(prefix));
        }
        catch (IOException e) {
            log.debug("Could not read {} directory searching for buffered transaction log files.", (Object)this.tlogDir, (Object)e);
            this.existOldBufferLog = false;
        }
        TransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            Path path2 = this.tlogDir.resolve(oldLogName);
            try {
                oldLog = this.newTransactionLog(path2, null, true);
                this.addOldLog(oldLog, false);
            }
            catch (RuntimeException e) {
                log.error("Failure to open existing log file (non fatal) {} ", (Object)path2, (Object)e);
                UpdateLog.deleteFile(path2);
            }
        }
        for (TransactionLog ll : this.logs) {
            this.newestLogsOnStartup.addFirst(ll);
            if (this.newestLogsOnStartup.size() < 2) continue;
            break;
        }
        try {
            this.versionInfo = new VersionInfo(this, this.numVersionBuckets);
        }
        catch (SolrException e) {
            log.error("Unable to use updateLog: ", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to use updateLog: " + e.getMessage(), (Throwable)e);
        }
        try (RecentUpdates startingUpdates = this.getRecentUpdates();){
            int i;
            this.startingVersions = startingUpdates.getVersions(this.numRecordsToKeep);
            for (i = startingUpdates.deleteList.size() - 1; i >= 0; --i) {
                DeleteUpdate du = startingUpdates.deleteList.get(i);
                this.oldDeletes.put(new BytesRef(du.id), new LogPtr(-1L, du.version));
            }
            for (i = startingUpdates.deleteByQueryList.size() - 1; i >= 0; --i) {
                Update update = startingUpdates.deleteByQueryList.get(i);
                List dbq = (List)update.log.lookup(update.pointer);
                long version = (Long)dbq.get(1);
                String q = (String)dbq.get(2);
                this.trackDeleteByQuery(q, version);
            }
        }
        core.getCoreMetricManager().registerMetricProducer(SolrInfoBean.Category.TLOG.toString(), this);
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.bufferedOpsGauge = () -> {
            if (this.state == State.BUFFERING) {
                if (this.bufferTlog == null) {
                    return 0;
                }
                return this.bufferTlog.numRecords() - 1;
            }
            if (this.tlog == null) {
                return 0;
            }
            if (this.state == State.APPLYING_BUFFERED) {
                return this.tlog.numRecords() - 1 - this.recoveryInfo.adds - this.recoveryInfo.deleteByQuery - this.recoveryInfo.deletes - this.recoveryInfo.errors.get();
            }
            return 0;
        };
        this.solrMetricsContext.gauge(this.bufferedOpsGauge, true, "ops", scope, "buffered");
        this.solrMetricsContext.gauge(() -> this.logs.size(), true, "logs", scope, "replay", "remaining");
        this.solrMetricsContext.gauge(() -> this.getTotalLogsSize(), true, "bytes", scope, "replay", "remaining");
        this.applyingBufferedOpsMeter = this.solrMetricsContext.meter("ops", scope, "applyingBuffered");
        this.replayOpsMeter = this.solrMetricsContext.meter("ops", scope, "replay");
        this.copyOverOldUpdatesMeter = this.solrMetricsContext.meter("ops", scope, "copyOverOldUpdates");
        this.solrMetricsContext.gauge(() -> this.state.getValue(), true, "state", scope);
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    public TransactionLog newTransactionLog(Path tlogFile, Collection<String> globalStrings, boolean openExisting) {
        return new TransactionLog(tlogFile, globalStrings, openExisting);
    }

    public String getLogDir() {
        return this.tlogDir.toAbsolutePath().toString();
    }

    public List<Long> getStartingVersions() {
        return this.startingVersions;
    }

    public boolean existOldBufferLog() {
        return this.existOldBufferLog;
    }

    protected synchronized void addOldLog(TransactionLog oldLog, boolean removeOld) {
        TransactionLog log;
        int nrec;
        if (oldLog == null) {
            return;
        }
        this.numOldRecords += oldLog.numRecords();
        int currRecords = this.numOldRecords;
        if (oldLog != this.tlog && this.tlog != null) {
            currRecords += this.tlog.numRecords();
        }
        while (removeOld && this.logs.size() > 0 && (currRecords - (nrec = (log = this.logs.peekLast()).numRecords()) >= this.numRecordsToKeep || this.maxNumLogsToKeep > 0 && this.logs.size() >= this.maxNumLogsToKeep)) {
            currRecords -= nrec;
            this.numOldRecords -= nrec;
            this.logs.removeLast().decref();
        }
        this.logs.addFirst(oldLog);
    }

    private boolean updateFromOldTlogs(UpdateCommand cmd) {
        return (cmd.getFlags() & UpdateCommand.REPLAY) != 0 && this.state == State.REPLAYING;
    }

    public String[] getLogList(File directory) {
        String prefix = TLOG_NAME + ".";
        Object[] names = directory.list((dir, name) -> name.startsWith(prefix));
        if (names == null) {
            throw new RuntimeException(new FileNotFoundException(directory.getAbsolutePath()));
        }
        Arrays.sort(names);
        return names;
    }

    public long getLastLogId() {
        if (this.id != -1L) {
            return this.id;
        }
        if (this.tlogFiles.length == 0) {
            return -1L;
        }
        String last = this.tlogFiles[this.tlogFiles.length - 1];
        return Long.parseLong(last.substring(TLOG_NAME.length() + 1));
    }

    public void add(AddUpdateCommand cmd) {
        this.add(cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddUpdateCommand cmd, boolean clearCaches) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if ((cmd.getFlags() & UpdateCommand.BUFFERING) != 0) {
                this.ensureBufferTlog();
                this.bufferTlog.write(cmd);
                return;
            }
            long pos = -1L;
            long prevPointer = this.getPrevPointerForUpdate(cmd);
            if (!this.updateFromOldTlogs(cmd)) {
                this.ensureLog();
                pos = this.tlog.write(cmd, prevPointer);
            }
            if (!clearCaches) {
                LogPtr ptr = new LogPtr(pos, cmd.getVersion(), prevPointer);
                this.map.put(cmd.getIndexedId(), ptr);
                if (this.trace) {
                    log.trace("TLOG: added id {} to {} {} map={}", new Object[]{cmd.getPrintableId(), this.tlog, ptr, System.identityHashCode(this.map)});
                }
            } else {
                this.openRealtimeSearcher();
                if (log.isTraceEnabled()) {
                    log.trace("TLOG: added id {} to {} clearCaches=true", (Object)cmd.getPrintableId(), (Object)this.tlog);
                }
            }
        }
    }

    private synchronized long getPrevPointerForUpdate(AddUpdateCommand cmd) {
        if (cmd.isInPlaceUpdate()) {
            BytesRef indexedId = cmd.getIndexedId();
            for (Map currentMap : Arrays.asList(this.map, this.prevMap, this.prevMap2)) {
                LogPtr prevEntry;
                if (currentMap == null || null == (prevEntry = (LogPtr)currentMap.get(indexedId))) continue;
                return prevEntry.pointer;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteUpdateCommand cmd) {
        BytesRef br = cmd.getIndexedId();
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if ((cmd.getFlags() & UpdateCommand.BUFFERING) != 0) {
                this.ensureBufferTlog();
                this.bufferTlog.writeDelete(cmd);
                return;
            }
            long pos = -1L;
            if (!this.updateFromOldTlogs(cmd)) {
                this.ensureLog();
                pos = this.tlog.writeDelete(cmd);
            }
            LogPtr ptr = new LogPtr(pos, cmd.version);
            this.map.put(br, ptr);
            this.oldDeletes.put(br, ptr);
            if (this.trace) {
                log.trace("TLOG: added delete for id {} to {} {} map={}", new Object[]{cmd.id, this.tlog, ptr, System.identityHashCode(this.map)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByQuery(DeleteUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if ((cmd.getFlags() & UpdateCommand.BUFFERING) != 0) {
                this.ensureBufferTlog();
                this.bufferTlog.writeDeleteByQuery(cmd);
                return;
            }
            long pos = -1L;
            if (!this.updateFromOldTlogs(cmd)) {
                this.ensureLog();
                pos = this.tlog.writeDeleteByQuery(cmd);
            }
            if ((cmd.getFlags() & UpdateCommand.IGNORE_INDEXWRITER) == 0) {
                this.openRealtimeSearcher();
                this.trackDeleteByQuery(cmd.getQuery(), cmd.getVersion());
                if (this.trace) {
                    LogPtr ptr = new LogPtr(pos, cmd.getVersion());
                    int hash = System.identityHashCode(this.map);
                    log.trace("TLOG: added deleteByQuery {} to {} {} map = {}.", new Object[]{cmd.query, this.tlog, ptr, hash});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRealtimeSearcher() {
        log.debug("openRealtimeSearcher");
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            try {
                RefCounted<SolrIndexSearcher> holder = this.uhandler.core.openNewSearcher(true, true);
                holder.decref();
            }
            catch (Exception e) {
                log.error("Error opening realtime searcher", (Throwable)e);
                return;
            }
            if (this.map != null) {
                this.map.clear();
            }
            if (this.prevMap != null) {
                this.prevMap.clear();
            }
            if (this.prevMap2 != null) {
                this.prevMap2.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            try {
                RefCounted<SolrIndexSearcher> holder = this.uhandler.core.openNewSearcher(true, true);
                holder.decref();
            }
            catch (Exception e) {
                log.error("Error opening realtime searcher for deleteByQuery", (Throwable)e);
            }
            if (this.map != null) {
                this.map.clear();
            }
            if (this.prevMap != null) {
                this.prevMap.clear();
            }
            if (this.prevMap2 != null) {
                this.prevMap2.clear();
            }
            this.oldDeletes.clear();
            this.deleteByQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackDeleteByQuery(String q, long version) {
        version = Math.abs(version);
        DBQ dbq = new DBQ();
        dbq.q = q;
        dbq.version = version;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.deleteByQueries.isEmpty() || this.deleteByQueries.getFirst().version < version) {
                this.deleteByQueries.addFirst(dbq);
            } else {
                ListIterator<DBQ> iter = this.deleteByQueries.listIterator();
                iter.next();
                while (iter.hasNext()) {
                    DBQ oldDBQ = (DBQ)iter.next();
                    if (oldDBQ.version < version) {
                        iter.previous();
                        break;
                    }
                    if (oldDBQ.version != version || !oldDBQ.q.equals(q)) continue;
                    return;
                }
                iter.add(dbq);
            }
            if (this.deleteByQueries.size() > 100) {
                this.deleteByQueries.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBQ> getDBQNewer(long version) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.deleteByQueries.isEmpty() || this.deleteByQueries.getFirst().version < version) {
                return null;
            }
            ArrayList<DBQ> dbqList = new ArrayList<DBQ>();
            for (DBQ dbq : this.deleteByQueries) {
                if (dbq.version <= version) break;
                dbqList.add(dbq);
            }
            return dbqList;
        }
    }

    protected void newMap() {
        this.prevMap2 = this.prevMap;
        this.prevMapLog2 = this.prevMapLog;
        this.prevMap = this.map;
        this.prevMapLog = this.tlog;
        this.map = new HashMap<BytesRef, LogPtr>();
    }

    private void clearOldMaps() {
        this.prevMap = null;
        this.prevMap2 = null;
    }

    public boolean hasUncommittedChanges() {
        return this.tlog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                log.debug("TLOG: preCommit");
            }
            if (this.getState() != State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                return;
            }
            this.newMap();
            if (this.prevTlog != null) {
                this.globalStrings = this.prevTlog.getGlobalStrings();
            }
            if (this.prevTlog != null) {
                this.postCommit(cmd);
            }
            this.prevTlog = this.tlog;
            this.tlog = null;
            ++this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                log.debug("TLOG: postCommit");
            }
            if (this.prevTlog != null) {
                this.prevTlog.writeCommit(cmd);
                this.addOldLog(this.prevTlog, true);
                this.prevTlog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSoftCommit(CommitUpdateCommand cmd) {
        this.debug = log.isDebugEnabled();
        this.trace = log.isTraceEnabled();
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (!cmd.softCommit) {
                return;
            }
            this.newMap();
            this.map = new HashMap<BytesRef, LogPtr>();
            if (this.debug) {
                log.debug("TLOG: preSoftCommit: prevMap={} new map={}", (Object)System.identityHashCode(this.prevMap), (Object)System.identityHashCode(this.map));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSoftCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                SolrCore.verbose("TLOG: postSoftCommit: disposing of prevMap=" + System.identityHashCode(this.prevMap) + ", prevMap2=" + System.identityHashCode(this.prevMap2));
            }
            this.clearOldMaps();
        }
    }

    public synchronized long applyPartialUpdates(BytesRef id, long prevPointer, long prevVersion, Set<String> onlyTheseFields, SolrDocumentBase<?, ?> latestPartialDoc) {
        SolrInputDocument partialUpdateDoc = null;
        List<TransactionLog> lookupLogs = Arrays.asList(this.tlog, this.prevMapLog, this.prevMapLog2);
        while (prevPointer >= 0L) {
            List<?> entry = this.getEntryFromTLog(prevPointer, prevVersion, lookupLogs);
            if (entry == null) {
                return prevPointer;
            }
            int flags = (Integer)entry.get(0);
            if ((flags & 1) != 1 && (flags & 8) != 8) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, entry + " should've been either ADD or UPDATE_INPLACE update, while looking for id=" + new String(id.bytes, StandardCharsets.UTF_8));
            }
            if ((flags & 1) == 1) {
                partialUpdateDoc = (SolrInputDocument)entry.get(entry.size() - 1);
                this.applyOlderUpdates(latestPartialDoc, partialUpdateDoc, onlyTheseFields);
                return 0L;
            }
            if (entry.size() < 5) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, entry + " is not a partial doc, while looking for id=" + new String(id.bytes, StandardCharsets.UTF_8));
            }
            partialUpdateDoc = (SolrInputDocument)entry.get(entry.size() - 1);
            this.applyOlderUpdates(latestPartialDoc, partialUpdateDoc, onlyTheseFields);
            prevPointer = (Long)entry.get(2);
            prevVersion = (Long)entry.get(3);
            if (onlyTheseFields == null || !latestPartialDoc.keySet().containsAll(onlyTheseFields)) continue;
            return 0L;
        }
        return -1L;
    }

    private void applyOlderUpdates(SolrDocumentBase<?, ?> newerDoc, SolrInputDocument olderDoc, Set<String> mergeFields) {
        for (String fieldName : olderDoc.getFieldNames()) {
            if (newerDoc.containsKey((Object)fieldName) || mergeFields != null && !mergeFields.contains(fieldName)) continue;
            Collection values = olderDoc.getFieldValues(fieldName);
            if (values == null) {
                newerDoc.addField(fieldName, null);
                continue;
            }
            for (Object val : values) {
                newerDoc.addField(fieldName, val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<?> getEntryFromTLog(long lookupPointer, long lookupVersion, List<TransactionLog> lookupLogs) {
        for (TransactionLog lookupLog : lookupLogs) {
            if (lookupLog == null || lookupLog.getLogSize() <= lookupPointer) continue;
            lookupLog.incref();
            try {
                List tmpEntry;
                Object obj = null;
                try {
                    obj = lookupLog.lookup(lookupPointer);
                }
                catch (Error | Exception ex) {
                    log.debug("Exception reading the log (this is expected, don't worry)={}, for version={}. This can be ignored", (Object)lookupLog, (Object)lookupVersion);
                }
                if (obj == null || !(obj instanceof List) || (tmpEntry = (List)obj).size() < 2 || !(tmpEntry.get(1) instanceof Long) || !((Long)tmpEntry.get(1)).equals(lookupVersion)) continue;
                List list = tmpEntry;
                return list;
            }
            finally {
                lookupLog.decref();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(BytesRef indexedId) {
        TransactionLog lookupLog;
        LogPtr entry;
        Object object = this;
        synchronized (object) {
            entry = this.map.get(indexedId);
            lookupLog = this.tlog;
            if (entry == null && this.prevMap != null) {
                entry = this.prevMap.get(indexedId);
                lookupLog = this.prevMapLog;
            }
            if (entry == null && this.prevMap2 != null) {
                entry = this.prevMap2.get(indexedId);
                lookupLog = this.prevMapLog2;
            }
            if (entry == null) {
                return null;
            }
            lookupLog.incref();
        }
        try {
            object = lookupLog.lookup(entry.pointer);
            return object;
        }
        finally {
            lookupLog.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lookupVersion(BytesRef indexedId) {
        LogPtr entry;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            entry = this.map.get(indexedId);
            TransactionLog lookupLog = this.tlog;
            if (entry == null && this.prevMap != null) {
                entry = this.prevMap.get(indexedId);
                lookupLog = this.prevMapLog;
            }
            if (entry == null && this.prevMap2 != null) {
                entry = this.prevMap2.get(indexedId);
                lookupLog = this.prevMapLog2;
            }
        }
        if (entry != null) {
            return entry.version;
        }
        Long version = this.versionInfo.getVersionFromIndex(indexedId);
        if (version != null) {
            return version;
        }
        UpdateLog updateLog2 = this;
        synchronized (updateLog2) {
            entry = this.oldDeletes.get(indexedId);
        }
        if (entry != null) {
            return entry.version;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(SyncLevel syncLevel) {
        TransactionLog currLog;
        if (syncLevel == null) {
            syncLevel = this.defaultSyncLevel;
        }
        if (syncLevel == SyncLevel.NONE) {
            return;
        }
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            currLog = this.tlog;
            if (currLog == null) {
                return;
            }
            currLog.incref();
        }
        try {
            currLog.finish(syncLevel);
        }
        finally {
            currLog.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RecoveryInfo> recoverFromLog() {
        this.recoveryInfo = new RecoveryInfo();
        ArrayList<TransactionLog> recoverLogs = new ArrayList<TransactionLog>(1);
        for (TransactionLog ll : this.newestLogsOnStartup) {
            block8: {
                if (!ll.try_incref()) continue;
                try {
                    if (ll.endsWithCommit()) {
                        ll.closeOutput();
                        ll.decref();
                    }
                    break block8;
                }
                catch (IOException e) {
                    log.error("Error inspecting tlog {}", (Object)ll, (Object)e);
                    ll.closeOutput();
                    ll.decref();
                }
                continue;
            }
            recoverLogs.add(ll);
        }
        if (recoverLogs.isEmpty()) {
            return null;
        }
        ExecutorCompletionService<RecoveryInfo> cs = new ExecutorCompletionService<RecoveryInfo>(this.recoveryExecutor);
        LogReplayer replayer = new LogReplayer(recoverLogs, false);
        this.versionInfo.blockUpdates();
        try {
            this.state = State.REPLAYING;
            this.deleteByQueries.clear();
            this.oldDeletes.clear();
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        return cs.submit(replayer, this.recoveryInfo);
    }

    public Future<RecoveryInfo> recoverFromCurrentLog() {
        if (this.tlog == null) {
            return null;
        }
        this.map.clear();
        this.recoveryInfo = new RecoveryInfo();
        this.tlog.incref();
        ExecutorCompletionService<RecoveryInfo> cs = new ExecutorCompletionService<RecoveryInfo>(this.recoveryExecutor);
        LogReplayer replayer = new LogReplayer(Collections.singletonList(this.tlog), false, true);
        this.versionInfo.blockUpdates();
        try {
            this.state = State.REPLAYING;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        return cs.submit(replayer, this.recoveryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOverBufferingUpdates(CommitUpdateCommand cuc) {
        this.versionInfo.blockUpdates();
        try {
            UpdateLog updateLog = this;
            synchronized (updateLog) {
                block8: {
                    this.state = State.ACTIVE;
                    if (this.bufferTlog != null) break block8;
                    return;
                }
                this.copyOverOldUpdates(cuc.getVersion(), this.bufferTlog);
                this.dropBufferTlog();
            }
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAndSwitchToNewTlog(CommitUpdateCommand cuc) {
        this.versionInfo.blockUpdates();
        try {
            UpdateLog updateLog = this;
            synchronized (updateLog) {
                block11: {
                    if (this.tlog != null) break block11;
                    return;
                }
                this.preCommit(cuc);
                try {
                    this.copyOverOldUpdates(cuc.getVersion());
                }
                finally {
                    this.postCommit(cuc);
                }
            }
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
    }

    public void copyOverOldUpdates(long commitVersion) {
        TransactionLog oldTlog = this.prevTlog;
        if (oldTlog == null && !this.logs.isEmpty()) {
            oldTlog = this.logs.getFirst();
        }
        if (oldTlog == null || oldTlog.refcount.get() == 0) {
            return;
        }
        try {
            if (oldTlog.endsWithCommit()) {
                return;
            }
        }
        catch (IOException e) {
            log.warn("Exception reading log", (Throwable)e);
            return;
        }
        this.copyOverOldUpdates(commitVersion, oldTlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOverOldUpdates(long commitVersion, TransactionLog oldTlog) {
        this.copyOverOldUpdatesMeter.mark();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.uhandler.core, (SolrParams)new ModifiableSolrParams());
        Object o = null;
        try (TransactionLog.LogReader logReader = null;){
            logReader = oldTlog.getReader(0L);
            block14: while ((o = logReader.next()) != null) {
                try {
                    List entry = (List)o;
                    int operationAndFlags = (Integer)entry.get(0);
                    int oper = operationAndFlags & 0xF;
                    long version = (Long)entry.get(1);
                    if (Math.abs(version) <= commitVersion) continue;
                    switch (oper) {
                        case 1: 
                        case 8: {
                            AddUpdateCommand cmd = UpdateLog.convertTlogEntryToAddUpdateCommand(req, entry, oper, version);
                            cmd.setFlags(UpdateCommand.IGNORE_AUTOCOMMIT);
                            this.add(cmd);
                            continue block14;
                        }
                        case 2: {
                            byte[] idBytes = (byte[])entry.get(2);
                            DeleteUpdateCommand cmd = new DeleteUpdateCommand(req);
                            cmd.setIndexedId(new BytesRef(idBytes));
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.IGNORE_AUTOCOMMIT);
                            this.delete(cmd);
                            continue block14;
                        }
                        case 3: {
                            String query = (String)entry.get(2);
                            DeleteUpdateCommand cmd = new DeleteUpdateCommand(req);
                            cmd.query = query;
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.IGNORE_AUTOCOMMIT);
                            this.deleteByQuery(cmd);
                            continue block14;
                        }
                    }
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                }
                catch (ClassCastException e) {
                    log.warn("Unexpected log entry or corrupt log.  Entry={}", o, (Object)e);
                }
            }
            if (this.prevTlog == oldTlog) {
                this.prevMap = null;
            }
        }
    }

    protected void ensureBufferTlog() {
        if (this.bufferTlog != null) {
            return;
        }
        String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, BUFFER_TLOG_NAME, System.nanoTime());
        this.bufferTlog = this.newTransactionLog(this.tlogDir.resolve(newLogName), this.globalStrings, false);
        this.bufferTlog.isBuffer = true;
    }

    protected void deleteBufferLogs() {
        try (Stream<Path> tlogs = Files.walk(this.tlogDir, 1, new FileVisitOption[0]);){
            String prefix = BUFFER_TLOG_NAME + ".";
            tlogs.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(prefix)).forEach(UpdateLog::deleteFile);
        }
        catch (IOException e) {
            log.warn("Could not clean up buffered transaction logs in {}", (Object)this.tlogDir, (Object)e);
        }
    }

    protected void ensureLog() {
        if (this.tlog == null) {
            String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id);
            this.tlog = this.newTransactionLog(this.tlogDir.resolve(newLogName), this.globalStrings, false);
        }
    }

    private void doClose(TransactionLog theLog, boolean writeCommit) {
        if (theLog != null) {
            if (writeCommit) {
                log.info("Recording current closed for {} log={}", (Object)this.uhandler.core, (Object)theLog);
                CommitUpdateCommand cmd = new CommitUpdateCommand(new LocalSolrQueryRequest(this.uhandler.core, (SolrParams)new ModifiableSolrParams((SolrParams)null)), false);
                theLog.writeCommit(cmd);
            }
            theLog.deleteOnClose = false;
            theLog.decref();
            theLog.forceClose();
        }
    }

    public void close(boolean committed) {
        this.close(committed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean committed, boolean deleteOnClose) {
        this.recoveryExecutor.shutdown();
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            this.doClose(this.prevTlog, committed);
            this.doClose(this.tlog, committed);
            for (TransactionLog log : this.logs) {
                if (log == this.prevTlog || log == this.tlog) continue;
                log.deleteOnClose = false;
                log.decref();
                log.forceClose();
            }
            if (this.bufferTlog != null) {
                this.bufferTlog.deleteOnClose = false;
                this.bufferTlog.decref();
                this.bufferTlog.forceClose();
            }
        }
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.recoveryExecutor);
        }
        catch (Exception e) {
            log.error("Exception shutting down recoveryExecutor", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecentUpdates getRecentUpdates() {
        ArrayDeque<TransactionLog> logList;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            logList = new ArrayDeque<TransactionLog>(this.logs);
            for (TransactionLog log : logList) {
                log.incref();
            }
            if (this.prevTlog != null) {
                this.prevTlog.incref();
                logList.addFirst(this.prevTlog);
            }
            if (this.tlog != null) {
                this.tlog.incref();
                logList.addFirst(this.tlog);
            }
            if (this.bufferTlog != null) {
                this.bufferTlog.incref();
                logList.addFirst(this.bufferTlog);
            }
        }
        return new RecentUpdates(logList);
    }

    public void bufferUpdates() {
        this.versionInfo.blockUpdates();
        try {
            if (this.state != State.ACTIVE && this.state != State.BUFFERING) {
                log.warn("Unexpected state for bufferUpdates: {}, Ignoring request", (Object)this.state);
                return;
            }
            this.dropBufferTlog();
            this.deleteBufferLogs();
            this.recoveryInfo = new RecoveryInfo();
            if (log.isInfoEnabled()) {
                log.info("Starting to buffer updates. {}", (Object)this);
            }
            this.state = State.BUFFERING;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
    }

    public boolean dropBufferedUpdates() {
        this.versionInfo.blockUpdates();
        try {
            if (this.state != State.BUFFERING) {
                boolean bl = false;
                return bl;
            }
            if (log.isInfoEnabled()) {
                log.info("Dropping buffered updates {}", (Object)this);
            }
            this.dropBufferTlog();
            this.state = State.ACTIVE;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropBufferTlog() {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.bufferTlog != null) {
                this.bufferTlog.decref();
                this.bufferTlog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RecoveryInfo> applyBufferedUpdates() {
        this.versionInfo.blockUpdates();
        try {
            this.cancelApplyBufferUpdate = false;
            if (this.state != State.BUFFERING) {
                Future<RecoveryInfo> future = null;
                return future;
            }
            UpdateLog updateLog = this;
            synchronized (updateLog) {
                block11: {
                    if (this.bufferTlog != null) break block11;
                    this.state = State.ACTIVE;
                    Future<RecoveryInfo> future = null;
                    return future;
                }
                this.bufferTlog.incref();
            }
            this.state = State.APPLYING_BUFFERED;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        if (ExecutorUtil.isShutdown((ExecutorService)this.recoveryExecutor)) {
            throw new RuntimeException("executor is not running...");
        }
        ExecutorCompletionService<RecoveryInfo> cs = new ExecutorCompletionService<RecoveryInfo>(this.recoveryExecutor);
        LogReplayer replayer = new LogReplayer(Collections.singletonList(this.bufferTlog), true);
        return cs.submit(() -> {
            replayer.run();
            this.dropBufferTlog();
        }, this.recoveryInfo);
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return "FSUpdateLog{state=" + this.getState() + ", tlog=" + this.tlog + "}";
    }

    public static AddUpdateCommand convertTlogEntryToAddUpdateCommand(SolrQueryRequest req, List<?> entry, int operation, long version) {
        assert (operation == 1 || operation == 8);
        SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
        AddUpdateCommand cmd = new AddUpdateCommand(req);
        cmd.solrDoc = sdoc;
        cmd.setVersion(version);
        if (operation == 8) {
            long prevVersion;
            cmd.prevVersion = prevVersion = ((Long)entry.get(3)).longValue();
        }
        return cmd;
    }

    public static void deleteFile(Path file) {
        boolean success = false;
        try {
            Files.deleteIfExists(file);
            success = true;
        }
        catch (Exception e) {
            log.error("Error deleting file: {}", (Object)file, (Object)e);
        }
        if (!success) {
            try {
                file.toFile().deleteOnExit();
            }
            catch (Exception e) {
                log.error("Error deleting file on exit: {}", (Object)file, (Object)e);
            }
        }
    }

    protected String getTlogDir(SolrCore core, PluginInfo info) {
        String dataDir = (String)info.initArgs.get("dir");
        String ulogDir = core.getCoreDescriptor().getUlogDir();
        if (ulogDir != null) {
            dataDir = ulogDir;
        }
        if (dataDir == null || dataDir.length() == 0) {
            dataDir = core.getDataDir();
        }
        return dataDir + "/" + TLOG_NAME;
    }

    public void clearLog(SolrCore core, PluginInfo ulogPluginInfo) {
        if (ulogPluginInfo == null) {
            return;
        }
        Path tlogPath = Path.of(this.getTlogDir(core, ulogPluginInfo), new String[0]);
        if (Files.exists(tlogPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(tlogPath, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException cause) {
                        log.error("Could not remove tlog file: {}", path, (Object)cause);
                    }
                });
            }
            catch (IOException e) {
                log.error("Could not clear old tlogs in {}", (Object)tlogPath);
            }
        }
    }

    @SuppressForbidden(reason="extends linkedhashmap")
    private static class OldDeletesLinkedHashMap
    extends LinkedHashMap<BytesRef, LogPtr> {
        private final int numDeletesToKeepInternal;

        public OldDeletesLinkedHashMap(int numDeletesToKeep) {
            super(numDeletesToKeep);
            this.numDeletesToKeepInternal = numDeletesToKeep;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<BytesRef, LogPtr> eldest) {
            return this.size() > this.numDeletesToKeepInternal;
        }
    }

    class LogReplayer
    implements Runnable {
        private Logger loglog = log;
        Deque<TransactionLog> translogs;
        TransactionLog.LogReader tlogReader;
        boolean activeLog;
        boolean finishing = false;
        boolean debug = this.loglog.isDebugEnabled();
        boolean inSortedOrder;
        private SolrQueryRequest req;
        private SolrQueryResponse rsp;

        public LogReplayer(List<TransactionLog> translogs, boolean activeLog) {
            this.translogs = new ArrayDeque<TransactionLog>();
            this.translogs.addAll(translogs);
            this.activeLog = activeLog;
        }

        public LogReplayer(List<TransactionLog> translogs, boolean activeLog, boolean inSortedOrder) {
            this(translogs, activeLog);
            this.inSortedOrder = inSortedOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
            params.set("log_replay", new String[]{"true"});
            this.req = new LocalSolrQueryRequest(UpdateLog.this.uhandler.core, (SolrParams)params);
            this.rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.req, this.rsp));
            try {
                Object translog;
                while ((translog = this.translogs.pollFirst()) != null) {
                    this.doReplay((TransactionLog)translog);
                }
                UpdateLog.this.state = State.ACTIVE;
                if (this.finishing) {
                    UpdateLog.this.versionInfo.unblockUpdates();
                }
            }
            catch (SolrException e) {
                if (e.code() == SolrException.ErrorCode.SERVICE_UNAVAILABLE.code) {
                    log.error("Replay failed service unavailable", (Throwable)e);
                    UpdateLog.this.recoveryInfo.failed = true;
                }
                UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                log.error("Replay failed due to exception", (Throwable)e);
            }
            catch (Exception e2) {
                UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                log.error("Replay failed due to exception", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                UpdateLog.this.state = State.ACTIVE;
                if (this.finishing) {
                    UpdateLog.this.versionInfo.unblockUpdates();
                }
                for (TransactionLog translog : this.translogs) {
                    log.error("ERROR: didn't get to recover from tlog {}", (Object)translog);
                    translog.decref();
                }
            }
            for (TransactionLog translog : this.translogs) {
                log.error("ERROR: didn't get to recover from tlog {}", (Object)translog);
                translog.decref();
            }
            this.loglog.warn("Log replay finished. recoveryInfo={}", (Object)UpdateLog.this.recoveryInfo);
            if (testing_logReplayFinishHook != null) {
                testing_logReplayFinishHook.run();
            }
            SolrRequestInfo.clearRequestInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doReplay(TransactionLog translog) {
            try {
                long commitVersion;
                AtomicReference<SolrException> exceptionOnExecuteUpdate;
                AtomicInteger pendingTasks;
                List<UpdateRequestProcessor> procPool;
                block39: {
                    this.loglog.warn("Starting log replay {}  active={} starting pos={} inSortedOrder={}", new Object[]{translog, this.activeLog, UpdateLog.this.recoveryInfo.positionOfStart, this.inSortedOrder});
                    long lastStatusTime = System.nanoTime();
                    try {
                        this.tlogReader = this.inSortedOrder ? translog.getSortedReader(UpdateLog.this.recoveryInfo.positionOfStart) : translog.getReader(UpdateLog.this.recoveryInfo.positionOfStart);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    UpdateRequestProcessorChain processorChain = this.req.getCore().getUpdateProcessingChain(null);
                    procPool = Collections.synchronizedList(new ArrayList());
                    ThreadLocal<UpdateRequestProcessor> procThreadLocal = ThreadLocal.withInitial(() -> {
                        UpdateRequestProcessor proc = processorChain.createProcessor(this.req, this.rsp);
                        procPool.add(proc);
                        return proc;
                    });
                    OrderedExecutor executor = this.inSortedOrder ? null : this.req.getCoreContainer().getReplayUpdatesExecutor();
                    pendingTasks = new AtomicInteger(0);
                    exceptionOnExecuteUpdate = new AtomicReference<SolrException>();
                    commitVersion = 0L;
                    int operationAndFlags = 0;
                    long nextCount = 0L;
                    while (true) {
                        Object o = null;
                        if (UpdateLog.this.cancelApplyBufferUpdate) break block39;
                        try {
                            long now;
                            if (testing_logReplayHook != null) {
                                testing_logReplayHook.run();
                            }
                            if (nextCount++ % 1000L == 0L && (now = System.nanoTime()) - lastStatusTime > STATUS_TIME) {
                                lastStatusTime = now;
                                long cpos = this.tlogReader.currentPos();
                                long csize = this.tlogReader.currentSize();
                                if (log.isInfoEnabled()) {
                                    this.loglog.info("log replay status {} active={} starting pos={} current pos={} current size={} % read={}", new Object[]{translog, this.activeLog, UpdateLog.this.recoveryInfo.positionOfStart, cpos, csize, Math.floor((double)cpos / (double)csize * 100.0)});
                                }
                            }
                            o = null;
                            o = this.tlogReader.next();
                            if (o == null && this.activeLog && !this.finishing) {
                                this.waitForAllUpdatesGetExecuted(pendingTasks);
                                executor = null;
                                UpdateLog.this.versionInfo.blockUpdates();
                                this.finishing = true;
                                o = this.tlogReader.next();
                            }
                        }
                        catch (Exception e) {
                            log.error("Exception during replay", (Throwable)e);
                        }
                        if (o == null) break block39;
                        if (exceptionOnExecuteUpdate.get() != null) {
                            throw (SolrException)((Object)exceptionOnExecuteUpdate.get());
                        }
                        try {
                            List entry = (List)o;
                            operationAndFlags = (Integer)entry.get(0);
                            int oper = operationAndFlags & 0xF;
                            long version = (Long)entry.get(1);
                            switch (oper) {
                                case 1: 
                                case 8: {
                                    ++UpdateLog.this.recoveryInfo.adds;
                                    AddUpdateCommand cmd = UpdateLog.convertTlogEntryToAddUpdateCommand(this.req, entry, oper, version);
                                    cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                    if (this.debug) {
                                        log.debug("{} {}", (Object)(oper == 1 ? "add" : "update"), (Object)cmd);
                                    }
                                    this.execute(cmd, executor, pendingTasks, procThreadLocal, exceptionOnExecuteUpdate);
                                    break;
                                }
                                case 2: {
                                    ++UpdateLog.this.recoveryInfo.deletes;
                                    byte[] idBytes = (byte[])entry.get(2);
                                    DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
                                    cmd.setIndexedId(new BytesRef(idBytes));
                                    cmd.setVersion(version);
                                    cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                    if (this.debug) {
                                        log.debug("delete {}", (Object)cmd);
                                    }
                                    this.execute(cmd, executor, pendingTasks, procThreadLocal, exceptionOnExecuteUpdate);
                                    break;
                                }
                                case 3: {
                                    ++UpdateLog.this.recoveryInfo.deleteByQuery;
                                    String query = (String)entry.get(2);
                                    DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
                                    cmd.query = query;
                                    cmd.setVersion(version);
                                    cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                    if (this.debug) {
                                        log.debug("deleteByQuery {}", (Object)cmd);
                                    }
                                    this.waitForAllUpdatesGetExecuted(pendingTasks);
                                    this.execute(cmd, null, pendingTasks, procThreadLocal, exceptionOnExecuteUpdate);
                                    break;
                                }
                                case 4: {
                                    commitVersion = version;
                                    break;
                                }
                                default: {
                                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                                }
                            }
                            if (this.rsp.getException() != null) {
                                this.loglog.error("REPLAY_ERR: Exception replaying log {}", (Throwable)this.rsp.getException());
                                throw this.rsp.getException();
                            }
                            if (UpdateLog.this.state == State.REPLAYING) {
                                UpdateLog.this.replayOpsMeter.mark();
                                continue;
                            }
                            if (UpdateLog.this.state != State.APPLYING_BUFFERED) continue;
                            UpdateLog.this.applyingBufferedOpsMeter.mark();
                        }
                        catch (ClassCastException cl) {
                            UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                            this.loglog.warn("REPLAY_ERR: Unexpected log entry or corrupt log.  Entry={}", o, (Object)cl);
                        }
                        catch (Exception ex) {
                            UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                            this.loglog.warn("REPLAY_ERR: Exception replaying log", (Throwable)ex);
                        }
                        assert (TestInjection.injectUpdateLogReplayRandomPause());
                    }
                }
                this.waitForAllUpdatesGetExecuted(pendingTasks);
                if (exceptionOnExecuteUpdate.get() != null) {
                    throw (SolrException)((Object)exceptionOnExecuteUpdate.get());
                }
                CommitUpdateCommand cmd = new CommitUpdateCommand(this.req, false);
                cmd.setVersion(commitVersion);
                cmd.softCommit = false;
                cmd.waitSearcher = true;
                cmd.setFlags(UpdateCommand.REPLAY);
                try {
                    if (this.debug) {
                        log.debug("commit {}", (Object)cmd);
                    }
                    UpdateLog.this.uhandler.commit(cmd);
                }
                catch (IOException ex) {
                    UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                    this.loglog.error("Replay exception: final commit.", (Throwable)ex);
                }
                if (!this.activeLog) {
                    translog.writeCommit(cmd);
                }
                for (UpdateRequestProcessor proc : procPool) {
                    try {
                        proc.finish();
                    }
                    catch (IOException ex) {
                        UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                        this.loglog.error("Replay exception: finish()", (Throwable)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)proc);
                    }
                }
            }
            finally {
                if (this.tlogReader != null) {
                    this.tlogReader.close();
                }
                translog.decref();
            }
        }

        private void waitForAllUpdatesGetExecuted(AtomicInteger pendingTasks) {
            TimeOut timeOut = new TimeOut(Integer.MAX_VALUE, TimeUnit.MILLISECONDS, TimeSource.CURRENT_TIME);
            try {
                timeOut.waitFor("Timeout waiting for replay updates finish", () -> pendingTasks.get() == 0);
            }
            catch (TimeoutException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }

        private Integer getBucketHash(UpdateCommand cmd) {
            if (cmd instanceof AddUpdateCommand) {
                BytesRef idBytes = ((AddUpdateCommand)cmd).getIndexedId();
                if (idBytes == null) {
                    return null;
                }
                return DistributedUpdateProcessor.bucketHash(idBytes);
            }
            if (cmd instanceof DeleteUpdateCommand) {
                BytesRef idBytes = ((DeleteUpdateCommand)cmd).getIndexedId();
                if (idBytes == null) {
                    return null;
                }
                return DistributedUpdateProcessor.bucketHash(idBytes);
            }
            return null;
        }

        private void execute(UpdateCommand cmd, OrderedExecutor executor, AtomicInteger pendingTasks, ThreadLocal<UpdateRequestProcessor> procTl, AtomicReference<SolrException> exceptionHolder) {
            assert (cmd instanceof AddUpdateCommand || cmd instanceof DeleteUpdateCommand);
            if (executor != null) {
                executor.execute(this.getBucketHash(cmd), () -> {
                    try {
                        if (exceptionHolder.get() != null) {
                            return;
                        }
                        this.invokeCmdOnProc(cmd, (UpdateRequestProcessor)procTl.get());
                    }
                    catch (IOException e) {
                        UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                        this.loglog.warn("REPLAY_ERR: IOException reading log", (Throwable)e);
                    }
                    catch (SolrException e) {
                        if (e.code() == SolrException.ErrorCode.SERVICE_UNAVAILABLE.code) {
                            exceptionHolder.compareAndSet(null, e);
                            return;
                        }
                        UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                        this.loglog.warn("REPLAY_ERR: SolrException reading log", (Throwable)e);
                    }
                    finally {
                        pendingTasks.decrementAndGet();
                    }
                });
                pendingTasks.incrementAndGet();
            } else {
                try {
                    this.invokeCmdOnProc(cmd, procTl.get());
                }
                catch (IOException e) {
                    UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                    this.loglog.warn("REPLAY_ERR: IOException replaying log", (Throwable)e);
                }
                catch (SolrException e) {
                    if (e.code() == SolrException.ErrorCode.SERVICE_UNAVAILABLE.code) {
                        throw e;
                    }
                    UpdateLog.this.recoveryInfo.errors.incrementAndGet();
                    this.loglog.warn("REPLAY_ERR: SolrException replaying log", (Throwable)e);
                }
            }
        }

        private void invokeCmdOnProc(UpdateCommand cmd, UpdateRequestProcessor proc) throws IOException {
            if (cmd instanceof AddUpdateCommand) {
                proc.processAdd((AddUpdateCommand)cmd);
            } else {
                proc.processDelete((DeleteUpdateCommand)cmd);
            }
        }
    }

    public class RecentUpdates
    implements Closeable {
        final Deque<TransactionLog> logList;
        List<List<Update>> updateList;
        HashMap<Long, Update> updates;
        public List<Update> deleteByQueryList;
        public List<DeleteUpdate> deleteList;
        Set<Long> bufferUpdates = new HashSet<Long>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RecentUpdates(Deque<TransactionLog> logList) {
            this.logList = logList;
            boolean success = false;
            try {
                this.update();
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        public List<Long> getVersions(int n) {
            return this.getVersions(n, Long.MAX_VALUE);
        }

        public Set<Long> getBufferUpdates() {
            return Collections.unmodifiableSet(this.bufferUpdates);
        }

        public List<Long> getVersions(int n, long maxVersion) {
            ArrayList<Long> ret = new ArrayList<Long>(n);
            LongSet set = new LongSet(n);
            int nInput = n;
            for (List<Update> singleList : this.updateList) {
                for (Update ptr : singleList) {
                    if (Math.abs(ptr.version) > Math.abs(maxVersion)) continue;
                    if (!set.add(ptr.version)) {
                        if (!UpdateLog.this.debug) continue;
                        log.debug("getVersions(n={}, maxVersion={}) not returning duplicate version = {}", new Object[]{nInput, maxVersion, ptr.version});
                        continue;
                    }
                    ret.add(ptr.version);
                    if (--n > 0) continue;
                    return ret;
                }
            }
            return ret;
        }

        public Object lookup(long version) {
            Update update = this.updates.get(version);
            if (update == null) {
                return null;
            }
            return update.log.lookup(update.pointer);
        }

        public List<Object> getDeleteByQuery(long afterVersion, LongSet updateVersions) {
            ArrayList<Object> result = new ArrayList<Object>(this.deleteByQueryList.size());
            for (Update update : this.deleteByQueryList) {
                if (Math.abs(update.version) <= afterVersion) continue;
                if (updateVersions.add(update.version)) {
                    Object dbq = update.log.lookup(update.pointer);
                    result.add(dbq);
                    continue;
                }
                if (!UpdateLog.this.debug) continue;
                log.debug("UpdateLog.RecentUpdates.getDeleteByQuery(afterVersion={}) not returning duplicate version = {}", (Object)afterVersion, (Object)update.version);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            int numUpdates = 0;
            this.updateList = new ArrayList<List<Update>>(this.logList.size());
            this.deleteByQueryList = new ArrayList<Update>();
            this.deleteList = new ArrayList<DeleteUpdate>();
            this.updates = CollectionUtil.newHashMap((int)UpdateLog.this.numRecordsToKeep);
            for (TransactionLog oldLog : this.logList) {
                ArrayList<Update> updatesForLog = new ArrayList<Update>();
                try (TransactionLog.ReverseReader reader = null;){
                    reader = oldLog.getReverseReader();
                    while (numUpdates < UpdateLog.this.numRecordsToKeep) {
                        Object o = null;
                        try {
                            o = reader.next();
                            if (o == null) {
                                break;
                            }
                            List entry = (List)o;
                            int opAndFlags = (Integer)entry.get(0);
                            int oper = opAndFlags & 0xF;
                            long version = (Long)entry.get(1);
                            if (oldLog.isBuffer) {
                                this.bufferUpdates.add(version);
                            }
                            switch (oper) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 8: {
                                    Update update = new Update();
                                    update.log = oldLog;
                                    update.pointer = reader.position();
                                    update.version = version;
                                    if (oper == 8 && entry.size() == 5) {
                                        update.previousVersion = (Long)entry.get(3);
                                    }
                                    updatesForLog.add(update);
                                    this.updates.put(version, update);
                                    if (oper == 3) {
                                        this.deleteByQueryList.add(update);
                                        break;
                                    }
                                    if (oper == 2) {
                                        this.deleteList.add(new DeleteUpdate(version, (byte[])entry.get(2)));
                                    }
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                default: {
                                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                                }
                            }
                        }
                        catch (ClassCastException cl) {
                            log.warn("Unexpected log entry or corrupt log.  Entry={}", o, (Object)cl);
                        }
                        catch (Exception ex) {
                            log.warn("Exception reverse reading log", (Throwable)ex);
                            break;
                        }
                        ++numUpdates;
                    }
                }
                this.updateList.add(updatesForLog);
            }
        }

        @Override
        public void close() {
            for (TransactionLog log : this.logList) {
                log.decref();
            }
        }

        public long getMaxRecentVersion() {
            long maxRecentVersion = 0L;
            if (this.updates != null) {
                for (Long key : this.updates.keySet()) {
                    maxRecentVersion = Math.max(maxRecentVersion, Math.abs(key));
                }
            }
            return maxRecentVersion;
        }
    }

    protected static class DeleteUpdate {
        public long version;
        public byte[] id;

        public DeleteUpdate(long version, byte[] id) {
            this.version = version;
            this.id = id;
        }
    }

    protected static class Update {
        public TransactionLog log;
        long version;
        long previousVersion;
        public long pointer;

        protected Update() {
        }
    }

    public static class LogPtr {
        final long pointer;
        final long version;
        final long previousPointer;

        public LogPtr(long pointer, long version) {
            this(pointer, version, -1L);
        }

        public LogPtr(long pointer, long version, long previousPointer) {
            this.pointer = pointer;
            this.version = version;
            this.previousPointer = previousPointer;
        }

        public String toString() {
            return "LogPtr(" + this.pointer + ")";
        }
    }

    public static class DBQ {
        public String q;
        public long version;

        public String toString() {
            return "DBQ{version=" + this.version + ",q=" + this.q + "}";
        }
    }

    public static class RecoveryInfo {
        public long positionOfStart;
        public int adds;
        public int deletes;
        public int deleteByQuery;
        public AtomicInteger errors = new AtomicInteger(0);
        public boolean failed;

        public String toString() {
            return "RecoveryInfo{adds=" + this.adds + " deletes=" + this.deletes + " deleteByQuery=" + this.deleteByQuery + " errors=" + this.errors + " positionOfStart=" + this.positionOfStart + "}";
        }
    }

    public static enum State {
        REPLAYING(0),
        BUFFERING(1),
        APPLYING_BUFFERED(2),
        ACTIVE(3);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SyncLevel {
        NONE,
        FLUSH,
        FSYNC;


        public static SyncLevel getSyncLevel(String level) {
            if (level == null) {
                return FLUSH;
            }
            try {
                return SyncLevel.valueOf(level.toUpperCase(Locale.ROOT));
            }
            catch (Exception ex) {
                log.warn("There was an error reading the SyncLevel - default to {}", (Object)FLUSH, (Object)ex);
                return FLUSH;
            }
        }
    }
}

