/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.rc;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class RateCvrt
extends AudioCodec {
    public RateCvrt() {
        ((BasicCodec)((Object)this)).inputFormats = new Format[]{new AudioFormat("LINEAR")};
    }

    public String getName() {
        return "Rate Conversion";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            int ssize = af.getSampleSizeInBits();
            int chnl = af.getChannels();
            int endian = af.getEndian();
            int signed = af.getSigned();
            ((BasicCodec)((Object)this)).outputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 11025.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 16000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 22050.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 32000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 44100.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 48000.0, ssize, chnl, endian, signed)};
        } else {
            ((BasicCodec)((Object)this)).outputFormats = new Format[0];
        }
        return ((BasicCodec)((Object)this)).outputFormats;
    }

    public synchronized int process(Buffer in, Buffer out) {
        if (!((BasicCodec)((Object)this)).checkInputBuffer(in)) {
            return 1;
        }
        if (((BasicCodec)((Object)this)).isEOM(in)) {
            ((BasicCodec)((Object)this)).propagateEOM(out);
            return 0;
        }
        int inOffset = in.getOffset();
        int inLen = in.getLength();
        double inRate = ((AudioFormat)((BasicCodec)((Object)this)).inputFormat).getSampleRate();
        double outRate = ((AudioFormat)((BasicCodec)((Object)this)).outputFormat).getSampleRate();
        int chnl = ((AudioFormat)((BasicCodec)((Object)this)).inputFormat).getChannels();
        int bsize = ((AudioFormat)((BasicCodec)((Object)this)).inputFormat).getSampleSizeInBits() / 8;
        int step = 0;
        step = chnl == 2 ? (bsize == 2 ? 4 : 2) : (bsize == 2 ? 2 : 1);
        if (outRate == 0.0 || inRate == 0.0) {
            return 1;
        }
        double ratio = inRate / outRate;
        int outLen = (int)((double)(inLen - inOffset) * outRate / inRate + 0.5);
        switch (step) {
            case 2: {
                if (outLen % 2 != 1) break;
                ++outLen;
                break;
            }
            case 4: {
                if (outLen % 4 == 0) break;
                outLen = outLen / 4 + 1 << 2;
            }
        }
        if (((BasicCodec)((Object)this)).inputFormat.getDataType() == Format.byteArray) {
            return this.doByteCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        if (((BasicCodec)((Object)this)).inputFormat.getDataType() == Format.shortArray) {
            return this.doShortCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        if (((BasicCodec)((Object)this)).inputFormat.getDataType() == Format.intArray) {
            return this.doIntCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        return 1;
    }

    private int doByteCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        byte[] inData = (byte[])in.getData();
        byte[] outData = ((BasicPlugIn)((Object)this)).validateByteArraySize(out, outLen);
        int outOffset = 0;
        out.setData(outData);
        out.setFormat(((BasicCodec)((Object)this)).outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        double sum = 0.0;
        int inPtr = inOffset;
        int outPtr = outOffset;
        int inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    ++i;
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            byte[] d = new byte[step];
            while (inPtr <= inEnd - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                    ++i;
                }
                while ((sum += ratio) < 1.0) {
                    if (outPtr > outLen - step) continue;
                    int i2 = 0;
                    while (i2 < step) {
                        outData[outPtr++] = d[i2];
                        ++i2;
                    }
                }
                sum -= 1.0;
                inPtr += step;
            }
        }
        return 0;
    }

    private int doShortCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        short[] inData = (short[])in.getData();
        short[] outData = ((BasicPlugIn)((Object)this)).validateShortArraySize(out, outLen);
        int outOffset = 0;
        out.setData(outData);
        out.setFormat(((BasicCodec)((Object)this)).outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        double sum = 0.0;
        int inPtr = inOffset;
        int outPtr = outOffset;
        int inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    ++i;
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            short[] d = new short[step];
            while (inPtr <= inEnd - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                    ++i;
                }
                while ((sum += ratio) < 1.0) {
                    if (outPtr > outLen - step) continue;
                    int i2 = 0;
                    while (i2 < step) {
                        outData[outPtr++] = d[i2];
                        ++i2;
                    }
                }
                sum -= 1.0;
                inPtr += step;
            }
        }
        return 0;
    }

    private int doIntCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        int[] inData = (int[])in.getData();
        int[] outData = ((BasicPlugIn)((Object)this)).validateIntArraySize(out, outLen);
        int outOffset = 0;
        out.setData(outData);
        out.setFormat(((BasicCodec)((Object)this)).outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        double sum = 0.0;
        int inPtr = inOffset;
        int outPtr = outOffset;
        int inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    ++i;
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            int[] d = new int[step];
            while (inPtr <= inEnd - step) {
                int i = 0;
                while (i < step) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                    ++i;
                }
                while ((sum += ratio) < 1.0) {
                    if (outPtr > outLen - step) continue;
                    int i2 = 0;
                    while (i2 < step) {
                        outData[outPtr++] = d[i2];
                        ++i2;
                    }
                }
                sum -= 1.0;
                inPtr += step;
            }
        }
        return 0;
    }
}

