/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tomcat.Jar;

public class JarFileUrlJar
implements Jar {
    private final JarFile jarFile;
    private final URL jarFileURL;
    private final boolean multiRelease;
    private Enumeration<JarEntry> entries;
    private Set<String> entryNamesSeen;
    private JarEntry entry = null;

    public JarFileUrlJar(URL uRL, boolean bl) throws IOException {
        Object object;
        if (bl) {
            object = (JarURLConnection)uRL.openConnection();
            ((URLConnection)object).setUseCaches(false);
            this.jarFile = ((JarURLConnection)object).getJarFile();
            this.jarFileURL = ((JarURLConnection)object).getJarFileURL();
        } else {
            try {
                object = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
            this.jarFile = new JarFile((File)object, true, 1, Runtime.version());
            this.jarFileURL = uRL;
        }
        boolean bl2 = false;
        try {
            bl2 = this.jarFile.isMultiRelease();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.multiRelease = bl2;
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public InputStream getInputStream(String string) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        return this.jarFile.getInputStream(zipEntry);
    }

    public long getLastModified(String string) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null) {
            return -1L;
        }
        return zipEntry.getTime();
    }

    public boolean exists(String string) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        return zipEntry != null;
    }

    public String getURL(String string) {
        return "jar:" + this.getJarFileURL().toExternalForm() + "!/" + string;
    }

    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void nextEntry() {
        block6: {
            if (this.entries == null) {
                this.entries = this.jarFile.entries();
                if (this.multiRelease) {
                    this.entryNamesSeen = new HashSet<String>();
                }
            }
            if (this.multiRelease) {
                while (this.entries.hasMoreElements()) {
                    this.entry = this.entries.nextElement();
                    String string = this.entry.getName();
                    if (string.startsWith("META-INF/versions/")) {
                        int n = string.indexOf(47, 18);
                        if (n == -1) continue;
                        string = string.substring(n + 1);
                    }
                    if (string.isEmpty() || this.entryNamesSeen.contains(string)) continue;
                    this.entryNamesSeen.add(string);
                    this.entry = this.jarFile.getJarEntry(this.entry.getName());
                    break block6;
                }
                this.entry = null;
            } else {
                this.entry = this.entries.hasMoreElements() ? this.entries.nextElement() : null;
            }
        }
    }

    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    public InputStream getEntryInputStream() throws IOException {
        if (this.entry == null) {
            return null;
        }
        return this.jarFile.getInputStream(this.entry);
    }

    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    public void reset() throws IOException {
        this.entries = null;
        this.entryNamesSeen = null;
        this.entry = null;
    }
}

