/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Method;
import org.apache.catalina.Executor;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.Attributes;

public class ConnectorCreateRule
extends Rule {
    private static final Log log = LogFactory.getLog(ConnectorCreateRule.class);
    protected static final StringManager sm = StringManager.getManager(ConnectorCreateRule.class);

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        String string3;
        Service service = (Service)this.digester.peek();
        Executor executor = null;
        if (attributes.getValue("executor") != null) {
            executor = service.getExecutor(attributes.getValue("executor"));
        }
        Connector connector = new Connector(attributes.getValue("protocol"));
        if (executor != null) {
            ConnectorCreateRule.setExecutor(connector, executor);
        }
        if ((string3 = attributes.getValue("sslImplementationName")) != null) {
            ConnectorCreateRule.setSSLImplementationName(connector, string3);
        }
        this.digester.push((Object)connector);
    }

    private static void setExecutor(Connector connector, Executor executor) throws Exception {
        Method method = IntrospectionUtils.findMethod(connector.getProtocolHandler().getClass(), (String)"setExecutor", (Class[])new Class[]{java.util.concurrent.Executor.class});
        if (method != null) {
            method.invoke((Object)connector.getProtocolHandler(), executor);
        } else {
            log.warn((Object)sm.getString("connector.noSetExecutor", new Object[]{connector}));
        }
    }

    private static void setSSLImplementationName(Connector connector, String string) throws Exception {
        Method method = IntrospectionUtils.findMethod(connector.getProtocolHandler().getClass(), (String)"setSslImplementationName", (Class[])new Class[]{String.class});
        if (method != null) {
            method.invoke((Object)connector.getProtocolHandler(), string);
        } else {
            log.warn((Object)sm.getString("connector.noSetSSLImplementationName", new Object[]{connector}));
        }
    }

    public void end(String string, String string2) throws Exception {
        this.digester.pop();
    }
}

