/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.request;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;

public class RequestHeaderStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger logger = LogManager.getLogger(RequestHeaderStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null) {
            return "";
        }
        return this.httpMessage.getRequestHeader().toString().replaceAll("\r\n", "\n");
    }

    @Override
    public void setData(String data) {
        if (this.httpMessage == null) {
            return;
        }
        String header = data.replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setRequestHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn("Could not Save Header: " + header, (Throwable)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
    }
}

