/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.net.ssh.SSHSession;
import org.jkiss.dbeaver.model.net.ssh.SSHSessionController;
import org.jkiss.dbeaver.model.net.ssh.SSHTunnelImpl;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

public class SSHTunnelView
extends ViewPart {
    private ObjectListControl<SSHSession> viewer;
    private AbstractJob updateJob;

    public void createPartControl(Composite parent) {
        this.viewer = new ObjectListControl<SSHSession>(parent, 0x10000000, (IContentProvider)new ListContentProvider()){

            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return ((Object)((Object)this)).getClass().getName();
            }

            protected LoadingJob<Collection<SSHSession>> createLoadService(boolean forUpdate) {
                return null;
            }
        };
        this.viewer.appendListData(List.of());
        this.viewer.getControl().addPaintListener(e -> {
            if (this.viewer.getListData().isEmpty()) {
                UIUtils.drawMessageOverControl((Control)this.viewer.getControl(), (PaintEvent)e, (String)"No active SSH tunnels", (int)0);
            }
        });
        this.updateJob = new AbstractJob("Refresh SSH tunnels"){

            protected IStatus run(DBRProgressMonitor monitor) {
                SSHTunnelView.this.refreshTunnels();
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
        };
        this.updateJob.setUser(false);
        this.updateJob.setSystem(true);
        this.updateJob.schedule();
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
            this.updateJob = null;
        }
        super.dispose();
    }

    private void refreshTunnels() {
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (project == null) {
            UIUtils.asyncExec(() -> this.viewer.clearListData());
            return;
        }
        List sessions = project.getDataSourceRegistry().getDataSources().stream().map(DBPDataSourceContainer::getActiveNetworkHandlers).flatMap(dBWNetworkHandlerArray -> Stream.of(dBWNetworkHandlerArray)).filter(handler -> handler instanceof SSHTunnelImpl).map(handler -> ((SSHTunnelImpl)handler).getController()).filter(Objects::nonNull).distinct().map(SSHSessionController::getSessions).flatMap(sSHSessionArray -> Stream.of(sSHSessionArray)).toList();
        UIUtils.asyncExec(() -> {
            if (this.viewer.getControl().isDisposed()) {
                return;
            }
            this.viewer.getControl().setRedraw(false);
            this.viewer.clearListData();
            this.viewer.appendListData((Collection)sessions);
            this.viewer.getControl().setRedraw(true);
        });
    }
}

