/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.freeplane.core.ui.components.UITools;

public class TextIcon
implements Icon {
    private final String text;
    private final FontMetrics fontMetrics;
    private Color iconTextColor;
    private Color iconBackgroundColor;
    private Color iconBorderColor;
    private BasicStroke borderStroke;
    private int padding = 0;

    public TextIcon(String text, FontMetrics fontMetrics) {
        this.text = text;
        this.fontMetrics = fontMetrics;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color textColor;
        Graphics2D g2d = (Graphics2D)g;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        if (this.iconBackgroundColor != null) {
            g2d.setColor(this.iconBackgroundColor);
            g2d.fillRect(x, y, iconWidth, iconHeight);
        }
        Color color = textColor = this.iconTextColor != null ? this.iconTextColor : c.getForeground();
        if (this.borderStroke != null) {
            Color borderColor = this.iconBorderColor != null ? this.iconBorderColor : textColor;
            g2d.setColor(borderColor);
            g2d.setStroke(this.borderStroke);
            int lineWidth = (int)((double)(this.borderStroke.getLineWidth() / 2.0f) + 0.99);
            g2d.drawRoundRect(x + lineWidth, y + lineWidth, iconWidth - 2 * lineWidth - 1, iconHeight - 2 * lineWidth - 1, iconHeight / 8, iconHeight / 8);
        }
        if (this.text != null) {
            g2d.setColor(textColor);
            g2d.setFont(this.fontMetrics.getFont());
            int textX = x + this.padding;
            int textY = y + this.padding + this.fontMetrics.getAscent();
            g2d.drawString(this.text, textX, textY);
        }
    }

    public Color getIconTextColor() {
        return this.iconTextColor;
    }

    public TextIcon setIconTextColor(Color iconTextColor) {
        this.iconTextColor = iconTextColor;
        return this;
    }

    public Color getIconBackgroundColor() {
        return this.iconBackgroundColor;
    }

    public TextIcon setIconBackgroundColor(Color iconBackgroundColor) {
        this.iconBackgroundColor = iconBackgroundColor;
        if (this.iconTextColor == null) {
            this.iconTextColor = UITools.getTextColorForBackground(iconBackgroundColor);
        }
        return this;
    }

    public Color getIconBorderColor() {
        return this.iconBorderColor;
    }

    public TextIcon setIconBorderColor(Color iconBorderColor) {
        this.iconBorderColor = iconBorderColor;
        return this;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    public TextIcon setBorderStroke(BasicStroke borderStroke) {
        this.borderStroke = borderStroke;
        return this;
    }

    @Override
    public int getIconWidth() {
        return (this.text == null ? 0 : this.fontMetrics.stringWidth(this.text)) + 2 * this.padding;
    }

    @Override
    public int getIconHeight() {
        return this.fontMetrics.getHeight() + 2 * this.padding;
    }

    int getPadding() {
        return this.padding;
    }

    void setPadding(int padding) {
        this.padding = padding;
    }

    public String getText() {
        return this.text;
    }
}

