/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.util;

import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.stream.Stream;

public class Minify {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Minify.main(stringArray, System.out, System.err);
    }

    static void main(String[] stringArray, PrintStream printStream, PrintStream printStream2) throws URISyntaxException, IOException {
        if (stringArray == null || stringArray.length != 1) {
            Minify.printUsage(printStream2);
            return;
        }
        URI uRI = new URI(stringArray[0]);
        Path path = Paths.get(uRI);
        printStream.print(Minify.minifyCSS(path));
    }

    private static void printUsage(PrintStream printStream) {
        printStream.println("Usage: " + Minify.class.getName() + " <style-sheet-uri>");
    }

    public static String minifyCSS(String string) {
        AbstractCSSStyleSheet abstractCSSStyleSheet = Minify.createStyleSheet();
        try {
            if (abstractCSSStyleSheet.parseStyleSheet(new StringReader(string), (short)0)) {
                return abstractCSSStyleSheet.toMinifiedString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String minifyCSS(Path path) throws IOException {
        AbstractCSSStyleSheet abstractCSSStyleSheet = Minify.createStyleSheet();
        try (Object object = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            if (abstractCSSStyleSheet.parseStyleSheet((Reader)object, (short)0)) {
                String string = abstractCSSStyleSheet.toMinifiedString();
                return string;
            }
        }
        object = new StringBuilder(256);
        try (Stream<String> stream = Files.lines(path, StandardCharsets.UTF_8);){
            stream.forEach(arg_0 -> Minify.lambda$minifyCSS$0((StringBuilder)object, arg_0));
        }
        return ((StringBuilder)object).toString();
    }

    private static AbstractCSSStyleSheet createStyleSheet() {
        CSSDOMImplementation cSSDOMImplementation = new CSSDOMImplementation(EnumSet.allOf(Parser.Flag.class));
        return ((AbstractCSSStyleSheetFactory)cSSDOMImplementation).createStyleSheet(null, null);
    }

    private static /* synthetic */ void lambda$minifyCSS$0(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(' ');
    }
}

