#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-9mDXHRVUz0g2UoYZhAq8Qi
key:                  hOpenPGP-2.10.1-9mDXHRVUz0g2UoYZhAq8Qi
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  f9f3d2140d85882fb149a004e0956e14
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-9mDXHRVUz0g2UoYZhAq8Qi
depends:
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j
    asn1-encoding-0.9.6-BMfMARxbpBe2ttVffR1gAO
    attoparsec-0.14.4-FNzLUtPfSaOE1atMnsd5YT base-4.17.2.1
    base16-bytestring-1.0.2.0-H62yvQKnYXI2vVR0tnIhus
    bifunctors-5.6.2-GP7hKvADZuoI70Iothr3vs binary-0.8.9.1
    binary-conduit-1.3.1-46scKLM9QZyCP6dbMArZVq bytestring-0.11.5.3
    bz2-1.0.1.1-5nJQK7nrNK8DHBs81w7Txc
    conduit-1.3.6.1-LOP5sjciwZZGtwvmGKv7ZW
    conduit-extra-1.3.8-1JMiFOCwvslD8QGjqNo8o8 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-8EpZZqUWEWc7SRp6Vw2qaM
    errors-2.3.0-Bt9TPfb4HdvAiNYutdkWJY
    hashable-1.4.6.0-JiQr1Tltq7G4W5bcwnoSMj
    incremental-parser-0.5.1-3LhWm1BDD6bL2T9YafOsOR
    ixset-typed-0.5.1.0-GIGrMuGbboU4tqBBVgRRUc
    lens-5.3.2-5iQf9T9ZD7E1oav0YIbKON
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-IKG3zvKYtEQ3q1XygxFZnU
    openpgp-asciiarmor-0.1.2-5yKVAFaahXa1QmcDvFLgQk
    prettyprinter-1.7.1-CSlGZoOoBlWC7jpjoL7RBV
    resourcet-1.2.6-9cm9lWfgO5WKiqJck5h8fE
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    zlib-0.7.0.0-4e7wIz3ojLOAV2Wk6rHCKU

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

