#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 text-builder-linear
version:              0.1.3
visibility:           public
id:                   text-builder-linear-0.1.3-6Bbqt6X716H1sFlaR1MqkU
key:                  text-builder-linear-0.1.3-6Bbqt6X716H1sFlaR1MqkU
license:              BSD-3-Clause
copyright:            2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko
homepage:             https://github.com/Bodigrim/linear-builder
synopsis:             Builder for Text and ByteString based on linear types
description:
    Strict Text and ByteString builder, which hides mutable buffer behind linear types
    and takes amortized linear time.

category:             Text
abi:                  c68f3eeabfdcbec4e51e20a1e18ba08e
exposed:              True
exposed-modules:
    Data.Text.Builder.Linear Data.Text.Builder.Linear.Buffer
    Data.Text.Builder.Linear.Core

hidden-modules:
    Data.Text.Builder.Linear.Array Data.Text.Builder.Linear.Char
    Data.Text.Builder.Linear.Dec.Bounded
    Data.Text.Builder.Linear.Dec.Unbounded
    Data.Text.Builder.Linear.Double Data.Text.Builder.Linear.Hex
    Data.Text.Builder.Linear.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/text-builder-linear-0.1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/text-builder-linear-0.1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/text-builder-linear-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-builder-linear
hs-libraries:         HStext-builder-linear-0.1.3-6Bbqt6X716H1sFlaR1MqkU
depends:
    base-4.17.2.1 bytestring-0.11.5.3 ghc-bignum-1.3
    quote-quot-0.2.1.0-KHvztF2qimL8lZQ572L1QJ text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-text-builder-linear/html/text-builder-linear.haddock

haddock-html:         /usr/share/doc/haskell-text-builder-linear/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

