#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1GyPmmTg1Cb8zn86T8NGmL
key:                  trifecta-2.1.4-1GyPmmTg1Cb8zn86T8NGmL
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  2fdf760be0a159894e12d36e016a700c
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1GyPmmTg1Cb8zn86T8NGmL
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-CRExiPUdjbG8JKbY7llSvY
    blaze-html-0.9.2.0-LjI88QSzeg6Du3gTHOTwfP
    blaze-markup-0.8.3.0-3LhydqQBevSLPC64eL272u bytestring-0.11.5.3
    charset-0.3.12-ApgSF7sJsRuAlHYNl4sPFe
    comonad-5.0.9-H2efciFXOddKZZNbkNICvQ containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-EIyeAUgzd8F3gz4X11UUxZ
    ghc-prim-0.9.1 hashable-1.4.6.0-Bdyeh8ev81I2bBqnptAVUL
    indexed-traversable-0.1.4-52OhEMiwF4u4EtkYVR4uVg
    lens-5.3.2-3lnPesktvu71I24tA5AXig mtl-2.2.2
    parsers-0.12.12-EkRANkErUQWGtV7IMVZ0Dt
    prettyprinter-1.7.1-8UVKtzGyqYf1hA40GaDLxY
    prettyprinter-ansi-terminal-1.1.3-IyfQOLi3m8UGh0RxwsEjoo
    profunctors-5.6.3-B1puex7pinj8XdCtxpi2Qf
    reducers-3.12.5-7KVyTZl0QwjKBccVztQGDt transformers-0.5.6.2
    unordered-containers-0.2.20-1s4f8pAJmee27mGfYrIk99
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

