#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.2
visibility:           public
id:                   hledger-web-1.42.2-EiTBM0va2ZyBWOuVwkaJPr
key:                  hledger-web-1.42.2-EiTBM0va2ZyBWOuVwkaJPr
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  6a4c3f03b31435547d4e6f8a3be972e7
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.2-EiTBM0va2ZyBWOuVwkaJPr
depends:
    Decimal-0.5.2-16MtQDETqaTJIyJhMyooAY
    aeson-2.1.2.1-Kx5U0b11hXDAcrJPuBeHuf base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base64-1.0-L5gVYZ6948xLlvBJBmegXv
    blaze-html-0.9.2.0-KhmoRG3R09V549Pilp7yk8
    blaze-markup-0.8.3.0-7r16xFnCpy97jSGDBGxZET bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4NRudSZIbdgEwzMbC5HpSf
    clientsession-0.9.3.0-J85Ym5F9n1k8aOsNrTJClj
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-3OoOkivWqZS7dcQwoEFiHk
    conduit-extra-1.3.8-BJDq9IUY40K5dXgPcvjS82 containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-5tezMKqv9GA6gNR4q67AdR filepath-1.4.2.2
    githash-0.1.6.3-HPhO0WJvBOV198BThwzxQo
    hjsmin-0.2.1-EG1ybUiG3en3qPVu0BB7Om
    hledger-1.42.2-2O79c4Ox6HoEZLsY0Q78wY
    hledger-lib-1.42.2-Lj36cHhw0SuF8zqnZpUVTo
    hspec-2.11.3-5lWeKcWrhFCILITULT6Re2
    http-client-0.7.19-6519OECLAFwEwnL7Zu0xmW
    http-conduit-2.3.9.1-LdiFxavybru7fsar1aO4vs
    http-types-0.12.4-AnyveerSvWp9fcmJ7pBmmy
    megaparsec-9.7.0-CvA3wDhViq5BjXD55Lo9fs mtl-2.2.2
    network-3.1.4.0-4cEUA9pnnvEEvGlZk2FqT
    safe-0.3.21-HlwzjIK5TiIKPzF0RtoFLn
    shakespeare-2.1.4-KMc8g7Ey75lFQTOi0npKsi template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-7wl3VN2bkjVLyACPiFBxN
    unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-6yvNKQ0UUswJzjrPe1tuVO
    wai-cors-0.2.7-HkVPPTsL7PB6pDVarJy8pI
    wai-extra-3.1.18-7zPMyPLasumKA48lmOr4vP
    wai-handler-launch-3.0.3.1-HIy3M4k64XU7Zk1utO60N2
    warp-3.3.31-LNQyGmUrjCg6zDV5km21Oc
    yaml-0.11.11.2-BHSVNcT17WuHrMTwAaUYup
    yesod-1.6.2.1-HhppDXAlTSQ8I6WbbUZPmH
    yesod-core-1.6.27.1-K0kpjlaaVRLFoXQsd6Ijht
    yesod-form-1.7.9-Gwn2PCABM43J6wyBgBxrQa
    yesod-static-1.6.1.0-8l4LYlIWfJgKbFGAAFyA8G
    yesod-test-1.6.23-BCy8ibsODE93yueC1cTz5J

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

