/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_implementation.g1.G1CollectedHeap;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Universe {
    private static AddressField collectedHeapField;
    private static VirtualConstructor heapConstructor;
    private static OopField mainThreadGroupField;
    private static OopField systemThreadGroupField;
    private static AddressField boolArrayKlassField;
    private static AddressField byteArrayKlassField;
    private static AddressField charArrayKlassField;
    private static AddressField intArrayKlassField;
    private static AddressField shortArrayKlassField;
    private static AddressField longArrayKlassField;
    private static AddressField singleArrayKlassField;
    private static AddressField doubleArrayKlassField;
    private static AddressField narrowOopBaseField;
    private static CIntegerField narrowOopShiftField;
    private static AddressField narrowKlassBaseField;
    private static CIntegerField narrowKlassShiftField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Universe");
        collectedHeapField = type.getAddressField("_collectedHeap");
        heapConstructor = new VirtualConstructor(db);
        heapConstructor.addMapping("GenCollectedHeap", GenCollectedHeap.class);
        heapConstructor.addMapping("ParallelScavengeHeap", ParallelScavengeHeap.class);
        heapConstructor.addMapping("G1CollectedHeap", G1CollectedHeap.class);
        mainThreadGroupField = type.getOopField("_main_thread_group");
        systemThreadGroupField = type.getOopField("_system_thread_group");
        boolArrayKlassField = type.getAddressField("_boolArrayKlassObj");
        byteArrayKlassField = type.getAddressField("_byteArrayKlassObj");
        charArrayKlassField = type.getAddressField("_charArrayKlassObj");
        intArrayKlassField = type.getAddressField("_intArrayKlassObj");
        shortArrayKlassField = type.getAddressField("_shortArrayKlassObj");
        longArrayKlassField = type.getAddressField("_longArrayKlassObj");
        singleArrayKlassField = type.getAddressField("_singleArrayKlassObj");
        doubleArrayKlassField = type.getAddressField("_doubleArrayKlassObj");
        narrowOopBaseField = type.getAddressField("_narrow_oop._base");
        narrowOopShiftField = type.getCIntegerField("_narrow_oop._shift");
        narrowKlassBaseField = type.getAddressField("_narrow_klass._base");
        narrowKlassShiftField = type.getCIntegerField("_narrow_klass._shift");
    }

    public static String narrowOopModeToString(NARROW_OOP_MODE mode) {
        switch (mode) {
            case UnscaledNarrowOop: {
                return "32-bits Oops";
            }
            case ZeroBasedNarrowOop: {
                return "zero based Compressed Oops";
            }
            case HeapBasedNarrowOop: {
                return "Compressed Oops with base";
            }
        }
        return "";
    }

    public CollectedHeap heap() {
        try {
            return (CollectedHeap)heapConstructor.instantiateWrapperFor(collectedHeapField.getValue());
        }
        catch (WrongTypeException e) {
            return new CollectedHeap(collectedHeapField.getValue());
        }
    }

    public static long getNarrowOopBase() {
        if (narrowOopBaseField.getValue() == null) {
            return 0L;
        }
        return narrowOopBaseField.getValue().minus(null);
    }

    public static int getNarrowOopShift() {
        return (int)narrowOopShiftField.getValue();
    }

    public static long getNarrowKlassBase() {
        if (narrowKlassBaseField.getValue() == null) {
            return 0L;
        }
        return narrowKlassBaseField.getValue().minus(null);
    }

    public static int getNarrowKlassShift() {
        return (int)narrowKlassShiftField.getValue();
    }

    public boolean isIn(Address p) {
        return this.heap().isIn(p);
    }

    public boolean isInReserved(Address p) {
        return this.heap().isInReserved(p);
    }

    private Oop newOop(OopHandle handle) {
        return VM.getVM().getObjectHeap().newOop(handle);
    }

    public Oop mainThreadGroup() {
        return this.newOop(mainThreadGroupField.getValue());
    }

    public Oop systemThreadGroup() {
        return this.newOop(systemThreadGroupField.getValue());
    }

    public void basicTypeClassesDo(SystemDictionary.ClassVisitor visitor) {
        visitor.visit(new TypeArrayKlass(boolArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(byteArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(charArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(intArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(shortArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(longArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(singleArrayKlassField.getValue()));
        visitor.visit(new TypeArrayKlass(doubleArrayKlassField.getValue()));
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        this.heap().printOn(tty);
    }

    public static boolean elementTypeShouldBeAligned(BasicType type) {
        return type == BasicType.T_DOUBLE || type == BasicType.T_LONG;
    }

    public static boolean fieldTypeShouldBeAligned(BasicType type) {
        return type == BasicType.T_DOUBLE || type == BasicType.T_LONG;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Universe.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static enum NARROW_OOP_MODE {
        UnscaledNarrowOop,
        ZeroBasedNarrowOop,
        HeapBasedNarrowOop;

    }
}

