/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Toolkit;
import javax.swing.UIManager;

public class OS {
    private static final boolean osIsMacOsX;
    private static final boolean osIsWindows;
    private static final boolean osIsWindowsXP;
    private static final boolean osIsWindows2003;
    private static final boolean osIsWindowsVista;
    private static final boolean osIsLinux;

    public static boolean isMacOSX() {
        return osIsMacOsX;
    }

    public static boolean isWindows() {
        return osIsWindows;
    }

    public static boolean isWindowsXP() {
        return osIsWindowsXP;
    }

    public static boolean isWindows2003() {
        return osIsWindows2003;
    }

    public static boolean isWindowsVista() {
        return osIsWindowsVista;
    }

    public static boolean isLinux() {
        return osIsLinux;
    }

    public static boolean isUsingWindowsVisualStyles() {
        if (!OS.isWindows()) {
            return false;
        }
        boolean bl = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        if (!bl) {
            return false;
        }
        try {
            return System.getProperty("swing.noxp") == null;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
    }

    public static String getWindowsVisualStyle() {
        String string = UIManager.getString("win.xpstyle.name");
        if (string == null) {
            string = (String)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.colorName");
        }
        return string;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        osIsMacOsX = "mac os x".equals(string);
        osIsWindows = string != null && string.indexOf("windows") != -1;
        osIsWindowsXP = "windows xp".equals(string);
        osIsWindows2003 = "windows 2003".equals(string);
        osIsWindowsVista = "windows vista".equals(string);
        osIsLinux = string != null && string.indexOf("linux") != -1;
    }
}

