/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.tls;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

public class MariaDbX509KeyManager
extends X509ExtendedKeyManager {
    private final Hashtable<String, KeyStore.PrivateKeyEntry> privateKeyHash = new Hashtable();

    public MariaDbX509KeyManager(KeyStore keyStore, char[] pwd) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
            try {
                this.privateKeyHash.put(alias, (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(pwd)));
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {}
        }
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> accurateAlias = this.searchAccurateAliases(new String[]{keyType}, issuers);
        if (accurateAlias.size() == 0) {
            return null;
        }
        return accurateAlias.toArray(new String[0]);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        ArrayList<String> accurateAlias = this.searchAccurateAliases(keyType, issuers);
        return accurateAlias == null || accurateAlias.isEmpty() ? null : (String)accurateAlias.get(0);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry keyEntry = this.privateKeyHash.get(alias);
        if (keyEntry == null) {
            return null;
        }
        Certificate[] certs = keyEntry.getCertificateChain();
        if (certs.length > 0 && certs[0] instanceof X509Certificate) {
            return (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry keyEntry = this.privateKeyHash.get(alias);
        if (keyEntry == null) {
            return null;
        }
        return keyEntry.getPrivateKey();
    }

    private ArrayList<String> searchAccurateAliases(String[] keyTypes, Principal[] issuers) {
        if (keyTypes == null || keyTypes.length == 0) {
            return null;
        }
        ArrayList<String> accurateAliases = new ArrayList<String>();
        for (Map.Entry<String, KeyStore.PrivateKeyEntry> mapEntry : this.privateKeyHash.entrySet()) {
            Certificate[] certs = mapEntry.getValue().getCertificateChain();
            String alg = certs[0].getPublicKey().getAlgorithm();
            block1: for (String keyType : keyTypes) {
                if (!alg.equals(keyType)) continue;
                if (issuers != null && issuers.length != 0) {
                    for (Certificate cert : certs) {
                        if (!(cert instanceof X509Certificate)) continue;
                        X500Principal certificateIssuer = ((X509Certificate)cert).getIssuerX500Principal();
                        for (Principal issuer : issuers) {
                            if (!certificateIssuer.equals(issuer)) continue;
                            accurateAliases.add(mapEntry.getKey());
                            continue block1;
                        }
                    }
                    continue;
                }
                accurateAliases.add(mapEntry.getKey());
            }
        }
        return accurateAliases;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return null;
    }
}

