/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ElisionTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, ElisionTokenFilter> {
    @Nonnull
    private final List<String> articles;
    @Nullable
    private final Boolean articlesCase;
    @Nullable
    private final String articlesPath;
    public static final JsonpDeserializer<ElisionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElisionTokenFilter::setupElisionTokenFilterDeserializer);

    private ElisionTokenFilter(Builder builder) {
        super(builder);
        this.articles = ApiTypeHelper.unmodifiable(builder.articles);
        this.articlesCase = builder.articlesCase;
        this.articlesPath = builder.articlesPath;
    }

    public static ElisionTokenFilter of(Function<Builder, ObjectBuilder<ElisionTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Elision;
    }

    @Nonnull
    public final List<String> articles() {
        return this.articles;
    }

    @Nullable
    public final Boolean articlesCase() {
        return this.articlesCase;
    }

    @Nullable
    public final String articlesPath() {
        return this.articlesPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "elision");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.articles)) {
            generator.writeKey("articles");
            generator.writeStartArray();
            for (String item0 : this.articles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.articlesCase != null) {
            generator.writeKey("articles_case");
            generator.write(this.articlesCase.booleanValue());
        }
        if (this.articlesPath != null) {
            generator.writeKey("articles_path");
            generator.write(this.articlesPath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupElisionTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        ElisionTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::articles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "articles");
        op.add(Builder::articlesCase, JsonpDeserializer.booleanDeserializer(), "articles_case");
        op.add(Builder::articlesPath, JsonpDeserializer.stringDeserializer(), "articles_path");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.articles);
        result = 31 * result + Objects.hashCode(this.articlesCase);
        result = 31 * result + Objects.hashCode(this.articlesPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElisionTokenFilter other = (ElisionTokenFilter)o;
        return Objects.equals(this.articles, other.articles) && Objects.equals(this.articlesCase, other.articlesCase) && Objects.equals(this.articlesPath, other.articlesPath);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ElisionTokenFilter> {
        @Nullable
        private List<String> articles;
        @Nullable
        private Boolean articlesCase;
        @Nullable
        private String articlesPath;

        public Builder() {
        }

        private Builder(ElisionTokenFilter o) {
            super(o);
            this.articles = Builder._listCopy(o.articles);
            this.articlesCase = o.articlesCase;
            this.articlesPath = o.articlesPath;
        }

        private Builder(Builder o) {
            super(o);
            this.articles = Builder._listCopy(o.articles);
            this.articlesCase = o.articlesCase;
            this.articlesPath = o.articlesPath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder articles(List<String> list) {
            this.articles = Builder._listAddAll(this.articles, list);
            return this;
        }

        @Nonnull
        public final Builder articles(String value, String ... values) {
            this.articles = Builder._listAdd(this.articles, value, values);
            return this;
        }

        @Nonnull
        public final Builder articlesCase(@Nullable Boolean value) {
            this.articlesCase = value;
            return this;
        }

        @Nonnull
        public final Builder articlesPath(@Nullable String value) {
            this.articlesPath = value;
            return this;
        }

        @Override
        @Nonnull
        public ElisionTokenFilter build() {
            this._checkSingleUse();
            return new ElisionTokenFilter(this);
        }
    }
}

