#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-22K6d33sgpCIBFsrNaeP3H
key:                  postgrest-10.0.0-22K6d33sgpCIBFsrNaeP3H
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  f61356eceff05ecb4909573672d661a6
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-22K6d33sgpCIBFsrNaeP3H
depends:
    HTTP-4000.4.1-6l2L2QrYPR77FVP04RXOgN
    Ranged-sets-0.5.0-2fw1EURSH0lH5xPygIbs3H
    aeson-2.1.2.1-1NeIvw5bSkQ9apxHmCtPBl
    auto-update-0.1.6-J0hND8YSnbhzZMLYsvrvW base-4.17.2.1
    base64-bytestring-1.2.1.0-GswEt3eOHYLA64palw0j2S
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-2s4OeiMO3UWBaQwGHjklqk
    cassava-0.5.4.1-7s85Pyft4yWIhZ77I2vGX
    configurator-pg-0.2.10-5w5sB1JSCgr39divEwuZJE containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-3Cpa4QU2PcuJ7IDGatAF0h
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-GrdI0YbqFRVGU6JMQk3dXE
    hasql-dynamic-statements-0.3.1.1-5eLvTvwDvcp5wvuAj3rN0L
    hasql-notifications-0.2.0.5-AqEcoc51pCA6bmi0doqNG6
    hasql-pool-0.5.2.2-ARkb6Xm6qxgAqVtxphhJCr
    hasql-transaction-1.0.1.1-GcE0q7PiXSH3YXYPVhHQA7
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-7uecRhjtUnyHbQI0kDNqA2
    insert-ordered-containers-0.2.5.3-1fYwGFHC1i5BrLIbmIGqRx
    interpolatedstring-perl6-1.0.2-I6tuXdakrK3FDgc6ujuOdy
    jose-0.10-HwbkCcW6TeeHpDwPM2eXzl lens-5.3.2-3lnPesktvu71I24tA5AXig
    lens-aeson-1.2.3-Jk1L2IQrrvp7ASB1xszZjZ mtl-2.2.2
    network-3.1.4.0-GAyMeTMiQBM1z6BFq5KYYA
    network-uri-2.6.4.2-J6lb0WgqIXTCowsvFrAUqQ
    optparse-applicative-0.18.1.0-EO4j3VaswTtGiqiAFplF0k
    parsec-3.1.16.1 protolude-0.3.5-4HGZUSgMeMcCL3qWfbDxLy
    regex-tdfa-1.3.2.4-4mNvSPkd93s6qdh0OinOe0
    retry-0.9.3.1-BbL53auQ6NFKlmOONqETq5
    scientific-0.3.8.0-5UF0voSgI45snHwsluIty
    swagger2-2.8.10-IU05AshVUnCFFKK8evoe7P text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-1s4f8pAJmee27mGfYrIk99
    vault-0.3.1.5-D6c38ZLuU1QFEiHEK86JqI
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E
    wai-3.2.4-LNQZLvP4BwI5qoFlUqY1xm
    wai-cors-0.2.7-8lYJG8YnxZI40y2OnOQsJ9
    wai-extra-3.1.18-7bvLIwAWq5cJ3TQu8PVPer
    wai-logger-2.5.0-8Qr7u1DPMYw5I7OYCTJ2G8
    warp-3.3.31-5qZQWM2cWaK3toUW3gwoef

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

