# The PEP 484 type hints stub file for the QtGraphsWidgets module.
#
# Generated by SIP 6.12.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-Graphs.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtNetwork
from PyQt6 import QtQml
from PyQt6 import QtGraphs
from PyQt6 import QtQuick
from PyQt6 import QtWidgets
from PyQt6 import QtQuickWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class Q3DGraphsWidgetItem(QtCore.QObject):

    transparencyTechniqueChanged: typing.ClassVar[QtCore.pyqtSignal]
    def transparencyTechnique(self) -> QtGraphs.QtGraphs3D.TransparencyTechnique: ...
    def setTransparencyTechnique(self, technique: QtGraphs.QtGraphs3D.TransparencyTechnique) -> None: ...
    def doRayPicking(self, origin: QtGui.QVector3D, direction: QtGui.QVector3D) -> None: ...
    gridLineTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadowStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    ambientLightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomAtTargetEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    msaaSamplesChanged: typing.ClassVar[QtCore.pyqtSignal]
    wrapCameraYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    wrapCameraXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxCameraYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxCameraXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    minCameraYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    minCameraXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxCameraZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    minCameraZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraTargetPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraPresetChanged: typing.ClassVar[QtCore.pyqtSignal]
    marginChanged: typing.ClassVar[QtCore.pyqtSignal]
    queriedGraphPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    localeChanged: typing.ClassVar[QtCore.pyqtSignal]
    horizontalAspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    radialLabelOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelMarginChanged: typing.ClassVar[QtCore.pyqtSignal]
    polarChanged: typing.ClassVar[QtCore.pyqtSignal]
    optimizationHintChanged: typing.ClassVar[QtCore.pyqtSignal]
    aspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    orthoProjectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    currentFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    measureFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedElementChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadowQualityChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeThemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def eventFilter(self, obj: typing.Optional[QtCore.QObject], event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def event(self, event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def widget(self) -> typing.Optional[QtQuickWidgets.QQuickWidget]: ...
    def setWidget(self, widget: typing.Optional[QtQuickWidgets.QQuickWidget]) -> None: ...
    def setGridLineType(self, gridLineType: QtGraphs.QtGraphs3D.GridLineType) -> None: ...
    def gridLineType(self) -> QtGraphs.QtGraphs3D.GridLineType: ...
    def setLightColor(self, newLightColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def lightColor(self) -> QtGui.QColor: ...
    def setShadowStrength(self, newShadowStrength: float) -> None: ...
    def shadowStrength(self) -> float: ...
    def setLightStrength(self, newLightStrength: float) -> None: ...
    def lightStrength(self) -> float: ...
    def setAmbientLightStrength(self, newAmbientLightStrength: float) -> None: ...
    def ambientLightStrength(self) -> float: ...
    def setMsaaSamples(self, samples: int) -> None: ...
    def msaaSamples(self) -> int: ...
    def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
    def setWrapCameraYRotation(self, wrap: bool) -> None: ...
    def wrapCameraYRotation(self) -> bool: ...
    def setWrapCameraXRotation(self, wrap: bool) -> None: ...
    def wrapCameraXRotation(self) -> bool: ...
    def setCameraTargetPosition(self, target: QtGui.QVector3D) -> None: ...
    def cameraTargetPosition(self) -> QtGui.QVector3D: ...
    def setMaxCameraZoomLevel(self, level: float) -> None: ...
    def maxCameraZoomLevel(self) -> float: ...
    def setMinCameraZoomLevel(self, level: float) -> None: ...
    def minCameraZoomLevel(self) -> float: ...
    def setCameraZoomLevel(self, level: float) -> None: ...
    def cameraZoomLevel(self) -> float: ...
    def isRotationEnabled(self) -> bool: ...
    def setRotationEnabled(self, enable: bool) -> None: ...
    def isSelectionEnabled(self) -> bool: ...
    def setSelectionEnabled(self, enable: bool) -> None: ...
    def isZoomEnabled(self) -> bool: ...
    def setZoomEnabled(self, enable: bool) -> None: ...
    def isZoomAtTargetEnabled(self) -> bool: ...
    def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
    def setMaxCameraYRotation(self, rotation: float) -> None: ...
    def maxCameraYRotation(self) -> float: ...
    def setMinCameraYRotation(self, rotation: float) -> None: ...
    def minCameraYRotation(self) -> float: ...
    def setMaxCameraXRotation(self, rotation: float) -> None: ...
    def maxCameraXRotation(self) -> float: ...
    def setMinCameraXRotation(self, rotation: float) -> None: ...
    def minCameraXRotation(self) -> float: ...
    def setCameraYRotation(self, rotation: float) -> None: ...
    def cameraYRotation(self) -> float: ...
    def setCameraXRotation(self, rotation: float) -> None: ...
    def cameraXRotation(self) -> float: ...
    def setCameraPreset(self, preset: QtGraphs.QtGraphs3D.CameraPreset) -> None: ...
    def cameraPreset(self) -> QtGraphs.QtGraphs3D.CameraPreset: ...
    def renderToImage(self, imageSize: QtCore.QSize = ...) -> typing.Optional[QtQuick.QQuickItemGrabResult]: ...
    def selectedCustomItem(self) -> typing.Optional[QtGraphs.QCustom3DItem]: ...
    def selectedCustomItemIndex(self) -> int: ...
    def selectedAxis(self) -> typing.Optional[QtGraphs.QAbstract3DAxis]: ...
    def selectedLabelIndex(self) -> int: ...
    def customItems(self) -> list[QtGraphs.QCustom3DItem]: ...
    def releaseCustomItem(self, item: typing.Optional[QtGraphs.QCustom3DItem]) -> None: ...
    def removeCustomItemAt(self, position: QtGui.QVector3D) -> None: ...
    def removeCustomItem(self, item: typing.Optional[QtGraphs.QCustom3DItem]) -> None: ...
    def removeCustomItems(self) -> None: ...
    def addCustomItem(self, item: typing.Optional[QtGraphs.QCustom3DItem]) -> int: ...
    def hasSeries(self, series: typing.Optional[QtGraphs.QAbstract3DSeries]) -> bool: ...
    def clearSelection(self) -> None: ...
    def margin(self) -> float: ...
    def setMargin(self, margin: float) -> None: ...
    def queriedGraphPosition(self) -> QtGui.QVector3D: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def horizontalAspectRatio(self) -> float: ...
    def setHorizontalAspectRatio(self, ratio: float) -> None: ...
    def radialLabelOffset(self) -> float: ...
    def setRadialLabelOffset(self, offset: float) -> None: ...
    def labelMargin(self) -> float: ...
    def setLabelMargin(self, margin: float) -> None: ...
    def isPolar(self) -> bool: ...
    def setPolar(self, enable: bool) -> None: ...
    def optimizationHint(self) -> QtGraphs.QtGraphs3D.OptimizationHint: ...
    def setOptimizationHint(self, hint: QtGraphs.QtGraphs3D.OptimizationHint) -> None: ...
    def aspectRatio(self) -> float: ...
    def setAspectRatio(self, ratio: float) -> None: ...
    def selectedElement(self) -> QtGraphs.QtGraphs3D.ElementType: ...
    def isOrthoProjection(self) -> bool: ...
    def setOrthoProjection(self, enable: bool) -> None: ...
    def currentFps(self) -> int: ...
    def measureFps(self) -> bool: ...
    def setMeasureFps(self, enable: bool) -> None: ...
    def scene(self) -> typing.Optional[QtGraphs.Q3DScene]: ...
    def setSelectionMode(self, selectionMode: QtGraphs.QtGraphs3D.SelectionFlag) -> None: ...
    def selectionMode(self) -> QtGraphs.QtGraphs3D.SelectionFlag: ...
    def setShadowQuality(self, shadowQuality: QtGraphs.QtGraphs3D.ShadowQuality) -> None: ...
    def shadowQuality(self) -> QtGraphs.QtGraphs3D.ShadowQuality: ...
    def themes(self) -> list[QtGraphs.QGraphsTheme]: ...
    def setActiveTheme(self, activeTheme: typing.Optional[QtGraphs.QGraphsTheme]) -> None: ...
    def activeTheme(self) -> typing.Optional[QtGraphs.QGraphsTheme]: ...
    def releaseTheme(self, theme: typing.Optional[QtGraphs.QGraphsTheme]) -> None: ...
    def addTheme(self, theme: typing.Optional[QtGraphs.QGraphsTheme]) -> None: ...


class Q3DBarsWidgetItem(Q3DGraphsWidgetItem):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    floorLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSeriesMarginChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingRelativeChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingChanged: typing.ClassVar[QtCore.pyqtSignal]
    barThicknessChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiSeriesUniformChanged: typing.ClassVar[QtCore.pyqtSignal]
    def event(self, event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def floorLevel(self) -> float: ...
    def setFloorLevel(self, level: float) -> None: ...
    def selectedSeries(self) -> typing.Optional[QtGraphs.QBar3DSeries]: ...
    def axes(self) -> list[QtGraphs.QAbstract3DAxis]: ...
    def releaseAxis(self, axis: typing.Optional[QtGraphs.QAbstract3DAxis]) -> None: ...
    def addAxis(self, axis: typing.Optional[QtGraphs.QAbstract3DAxis]) -> None: ...
    def valueAxis(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setValueAxis(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def columnAxis(self) -> typing.Optional[QtGraphs.QCategory3DAxis]: ...
    def setColumnAxis(self, axis: typing.Optional[QtGraphs.QCategory3DAxis]) -> None: ...
    def rowAxis(self) -> typing.Optional[QtGraphs.QCategory3DAxis]: ...
    def setRowAxis(self, axis: typing.Optional[QtGraphs.QCategory3DAxis]) -> None: ...
    def barSeriesMargin(self) -> QtCore.QSizeF: ...
    def setBarSeriesMargin(self, margin: QtCore.QSizeF) -> None: ...
    def isBarSpacingRelative(self) -> bool: ...
    def setBarSpacingRelative(self, relative: bool) -> None: ...
    def barSpacing(self) -> QtCore.QSizeF: ...
    def setBarSpacing(self, spacing: QtCore.QSizeF) -> None: ...
    def barThickness(self) -> float: ...
    def setBarThickness(self, thicknessRatio: float) -> None: ...
    def isMultiSeriesUniform(self) -> bool: ...
    def setMultiSeriesUniform(self, uniform: bool) -> None: ...
    def seriesList(self) -> list[QtGraphs.QBar3DSeries]: ...
    def insertSeries(self, index: int, series: typing.Optional[QtGraphs.QBar3DSeries]) -> None: ...
    def removeSeries(self, series: typing.Optional[QtGraphs.QBar3DSeries]) -> None: ...
    def addSeries(self, series: typing.Optional[QtGraphs.QBar3DSeries]) -> None: ...
    def primarySeries(self) -> typing.Optional[QtGraphs.QBar3DSeries]: ...
    def setPrimarySeries(self, series: typing.Optional[QtGraphs.QBar3DSeries]) -> None: ...


class Q3DScatterWidgetItem(Q3DGraphsWidgetItem):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def event(self, event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def selectedSeries(self) -> typing.Optional[QtGraphs.QScatter3DSeries]: ...
    def axes(self) -> list[QtGraphs.QValue3DAxis]: ...
    def releaseAxis(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def addAxis(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisZ(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisZ(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisY(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisY(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisX(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisX(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def seriesList(self) -> list[QtGraphs.QScatter3DSeries]: ...
    def removeSeries(self, series: typing.Optional[QtGraphs.QScatter3DSeries]) -> None: ...
    def addSeries(self, series: typing.Optional[QtGraphs.QScatter3DSeries]) -> None: ...


class Q3DSurfaceWidgetItem(Q3DGraphsWidgetItem):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    flipHorizontalGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def event(self, event: typing.Optional[QtCore.QEvent]) -> bool: ...
    def flipHorizontalGrid(self) -> bool: ...
    def setFlipHorizontalGrid(self, flip: bool) -> None: ...
    def selectedSeries(self) -> typing.Optional[QtGraphs.QSurface3DSeries]: ...
    def axes(self) -> list[QtGraphs.QValue3DAxis]: ...
    def releaseAxis(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def addAxis(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisZ(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisZ(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisY(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisY(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def axisX(self) -> typing.Optional[QtGraphs.QValue3DAxis]: ...
    def setAxisX(self, axis: typing.Optional[QtGraphs.QValue3DAxis]) -> None: ...
    def seriesList(self) -> list[QtGraphs.QSurface3DSeries]: ...
    def removeSeries(self, series: typing.Optional[QtGraphs.QSurface3DSeries]) -> None: ...
    def addSeries(self, series: typing.Optional[QtGraphs.QSurface3DSeries]) -> None: ...
