\name{AddImageFilter}
\alias{AddImageFilter}
\title{AddImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Pixel-wise addition of two images.
AddImageFilter}
\details{
This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
The pixel type of the input 1 image must have a valid definition of
the operator+ with a pixel type of the image 2. This condition is
required because internally this filter will perform the operation
Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.
The total operation over one pixel will be
For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.
The images to be added are set using the methods:
Additionally, this filter can be used to add a constant to every pixel
of an image by using
WARNING:
No numeric overflow checking is performed in this filter.
See:
Add for the procedural interface
itk::AddImageFilter for the Doxygen on the original ITK class.
AddImageFilter}
%C++ includes: sitkAddImageFilter.h
\section{Methods}{
\describe{
\item{ AddImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~AddImageFilter():}{
Destructor
}
}
}
