# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_voa_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_voa_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_voa_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_voa_using_subcommand
	set -l cmd (__fish_voa_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c voa -n "__fish_voa_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_needs_command" -s h -l help -d 'Print help'
complete -c voa -n "__fish_voa_needs_command" -s V -l version -d 'Print version'
complete -c voa -n "__fish_voa_needs_command" -f -a "import" -d 'Import a single verifier into a VOA hierarchy.'
complete -c voa -n "__fish_voa_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c voa -n "__fish_voa_using_subcommand import" -s c -l context -d 'The context to import for.' -r
complete -c voa -n "__fish_voa_using_subcommand import" -s i -l input -d 'The directory or file to import from.' -r
complete -c voa -n "__fish_voa_using_subcommand import" -s b -l base-path -d 'The VOA base path to write to.' -r -F
complete -c voa -n "__fish_voa_using_subcommand import" -s r -l runtime -d 'Whether to import to the runtime directory.'
complete -c voa -n "__fish_voa_using_subcommand import" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand import" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from import help" -f -a "import" -d 'Import a single verifier into a VOA hierarchy.'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from import help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
