/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.nio.CharBuffer;
import java.util.Comparator;
import org.jkiss.code.NotNull;

public class AlphanumericComparator
implements Comparator<CharSequence> {
    private static final AlphanumericComparator INSTANCE = new AlphanumericComparator();

    private AlphanumericComparator() {
    }

    @NotNull
    public static AlphanumericComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        CharBuffer b1 = CharBuffer.wrap(o1);
        CharBuffer b2 = CharBuffer.wrap(o2);
        while (b1.hasRemaining() && b2.hasRemaining()) {
            AlphanumericComparator.adjustBufferWindow(b1);
            AlphanumericComparator.adjustBufferWindow(b2);
            int result = AlphanumericComparator.compare(b1, b2);
            if (result != 0) {
                return result;
            }
            AlphanumericComparator.resetBufferWindow(b1);
            AlphanumericComparator.resetBufferWindow(b2);
        }
        return Integer.compare(b1.remaining(), b2.remaining());
    }

    private static int compare(@NotNull CharBuffer b1, @NotNull CharBuffer b2) {
        int result;
        if (AlphanumericComparator.isDigit(b1, b1.position()) && AlphanumericComparator.isDigit(b2, b2.position()) && (result = Integer.compare(b1.remaining(), b2.remaining())) != 0) {
            return result;
        }
        return b1.compareTo(b2);
    }

    private static void resetBufferWindow(@NotNull CharBuffer buffer) {
        buffer.position(buffer.limit());
        buffer.limit(buffer.capacity());
    }

    private static void adjustBufferWindow(@NotNull CharBuffer buffer) {
        int start = buffer.position();
        int end = buffer.position();
        boolean digit = AlphanumericComparator.isDigit(buffer, start);
        while (end < buffer.limit() && digit == AlphanumericComparator.isDigit(buffer, end)) {
            if (!digit || start + 1 >= buffer.limit() || !AlphanumericComparator.isZero(buffer, start) || !AlphanumericComparator.isDigit(buffer, ++end)) continue;
            ++start;
        }
        buffer.position(start).limit(end);
    }

    private static boolean isDigit(@NotNull CharBuffer buffer, int position) {
        char ch = buffer.get(position);
        return ch >= '0' && ch <= '9';
    }

    private static boolean isZero(@NotNull CharBuffer buffer, int position) {
        return buffer.get(position) == '0';
    }
}

