/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.TypeResolver;
import io.cucumber.java.Transpose;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class JavaParameterInfo
implements ParameterInfo {
    private final Type type;
    private final boolean transposed;

    private JavaParameterInfo(Type type, boolean transposed) {
        this.type = type;
        this.transposed = transposed;
    }

    static List<ParameterInfo> fromMethod(Method method) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            boolean transposed = false;
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof Transpose)) continue;
                transposed = ((Transpose)annotation).value();
            }
            result.add(new JavaParameterInfo(genericParameterTypes[i], transposed));
        }
        return result;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public TypeResolver getTypeResolver() {
        return () -> this.type;
    }
}

