/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class NodeBackgroundColorControlGroup
implements ControlGroup {
    static final String REVERT_BACKGROUND = "revert-node-background";
    static final String NODE_BACKGROUND_COLOR = "nodebackgroundcolor";
    private RevertingProperty mSetNodeBackgroundColor;
    private ColorProperty mNodeBackgroundColor;
    private BgColorChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeBackgroundColor = new RevertingProperty(REVERT_BACKGROUND);
        this.mNodeBackgroundColor = new ColorProperty(NODE_BACKGROUND_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_BACKGROUND_COLOR));
        this.propertyChangeListener = new BgColorChangeListener(this.mSetNodeBackgroundColor, (IPropertyControl)this.mNodeBackgroundColor);
        this.mSetNodeBackgroundColor.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeBackgroundColor.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeBackgroundColor.appendToForm(formBuilder);
        this.mSetNodeBackgroundColor.appendToForm(formBuilder);
    }

    private class BgColorChangeListener
    extends ControlGroupChangeListener {
        public BgColorChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBackgroundColor(node, enabled ? NodeBackgroundColorControlGroup.this.mNodeBackgroundColor.getColorValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            Color color = NodeStyleModel.getBackgroundColor((NodeModel)node);
            Color viewColor = styleController.getBackgroundColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeBackgroundColorControlGroup.this.mSetNodeBackgroundColor.setValue(color != null);
            NodeBackgroundColorControlGroup.this.mNodeBackgroundColor.setColorValue(viewColor);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, NodeBackgroundColorControlGroup.this.mSetNodeBackgroundColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeBackgroundColorControlGroup.this.mNodeBackgroundColor);
        }
    }
}

