/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class EnvVariableValue
extends ProxyValue
implements CSSEnvVariableValue {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private StyleValue fallback = null;

    EnvVariableValue() {
        super(CSSValue.Type.ENV);
    }

    protected EnvVariableValue(EnvVariableValue envVariableValue) {
        super(envVariableValue);
        this.name = envVariableValue.name;
        if (envVariableValue.fallback != null) {
            this.fallback = envVariableValue.fallback.clone();
        }
    }

    @Override
    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("env(").append(this.name);
        if (this.fallback != null) {
            stringBuilder.append(", ").append(this.fallback.getCssText());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("env(").append(this.name);
        if (this.fallback != null) {
            stringBuilder.append(',').append(this.fallback.getMinifiedCssText(string));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"env(");
        simpleWriter.write((CharSequence)this.name);
        if (this.fallback != null) {
            simpleWriter.write((CharSequence)", ");
            this.fallback.writeCssText(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory valueFactory = new ValueFactory();
        StyleValue styleValue = valueFactory.parseProperty(string);
        if (styleValue == null || styleValue.getPrimitiveType() != CSSValue.Type.ENV) {
            throw new DOMException(13, "Not an environment variable value.");
        }
        EnvVariableValue envVariableValue = (EnvVariableValue)styleValue;
        this.name = envVariableValue.getName();
        this.fallback = envVariableValue.fallback;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.fallback == null ? 0 : this.fallback.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnvVariableValue envVariableValue = (EnvVariableValue)object;
        if (this.fallback == null ? envVariableValue.fallback != null : !this.fallback.equals(envVariableValue.fallback)) {
            return false;
        }
        if (this.name == null) {
            return envVariableValue.name == null;
        }
        return this.name.equals(envVariableValue.name);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StyleValue getFallback() {
        return this.fallback;
    }

    @Override
    public EnvVariableValue clone() {
        return new EnvVariableValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(EnvVariableValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            if (lexicalUnit2 == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            EnvVariableValue.this.name = lexicalUnit2.getStringValue();
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalUnit2 == null) {
                    throw new DOMException(5, "Unexpected character");
                }
                ValueFactory valueFactory = new ValueFactory();
                EnvVariableValue.this.fallback = valueFactory.createCSSValue(lexicalUnit2);
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

