/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.svg;

import io.sf.carte.echosvg.dom.svg.AbstractSVGItem;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List<SVGItem> itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2) throws ParseException;

    protected abstract void checkItemType(Object var1) throws SVGException;

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() throws DOMException {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.itemList == null) {
            this.itemList = new ArrayList<SVGItem>(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem getItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || this.itemList == null || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n});
        }
        return this.itemList.get(n);
    }

    protected SVGItem insertItemBeforeImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n});
        }
        if (n > this.itemList.size()) {
            n = this.itemList.size();
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem replaceItemImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n});
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.set(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem removeItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n});
        }
        SVGItem sVGItem = this.itemList.remove(n);
        sVGItem.setParent(null);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem appendItemImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(sVGItem);
        }
        return sVGItem;
    }

    protected SVGItem removeIfNeeded(Object object) {
        SVGItem sVGItem;
        if (object instanceof SVGItem) {
            sVGItem = (SVGItem)object;
            if (sVGItem.getParent() != null) {
                sVGItem.getParent().removeItem(sVGItem);
            }
        } else {
            sVGItem = this.createSVGItem(object);
        }
        return sVGItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revalidate() {
        if (this.valid) {
            return;
        }
        this.valid = true;
        String string = this.getValueAsString();
        if (string == null || (string = string.trim()).isEmpty()) {
            this.clear(this.itemList);
            this.itemList = new ArrayList<SVGItem>(1);
            return;
        }
        ListBuilder listBuilder = new ListBuilder(this);
        try {
            this.doParse(string, listBuilder);
        }
        catch (ParseException parseException) {
        }
        finally {
            List<SVGItem> list = listBuilder.getList();
            this.clear(this.itemList);
            this.itemList = list != null ? list : new ArrayList<SVGItem>(1);
        }
    }

    protected void setValueAsString(List<SVGItem> list) throws DOMException {
        String string = null;
        Iterator<SVGItem> iterator = list.iterator();
        if (iterator.hasNext()) {
            SVGItem sVGItem = iterator.next();
            StringBuilder stringBuilder = new StringBuilder(list.size() * 8);
            stringBuilder.append(sVGItem.getValueAsString());
            while (iterator.hasNext()) {
                sVGItem = iterator.next();
                stringBuilder.append(this.getItemSeparator());
                stringBuilder.append(sVGItem.getValueAsString());
            }
            string = stringBuilder.toString();
        }
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem sVGItem) {
        String string = this.getValueAsString() + this.getItemSeparator() + sVGItem.getValueAsString();
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem sVGItem) {
        if (this.itemList.contains(sVGItem)) {
            this.itemList.remove(sVGItem);
            sVGItem.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List<SVGItem> list) {
        if (list == null) {
            return;
        }
        for (SVGItem sVGItem : list) {
            sVGItem.setParent(null);
        }
        list.clear();
    }

    public void copyTo(AbstractSVGList abstractSVGList) {
        abstractSVGList.valid = this.valid;
        if (this.itemList != null) {
            abstractSVGList.itemList = new ArrayList<SVGItem>(this.itemList.size());
            for (SVGItem sVGItem : this.itemList) {
                sVGItem = ((AbstractSVGItem)sVGItem).clone();
                sVGItem.setParent(abstractSVGList);
                abstractSVGList.itemList.add(sVGItem);
            }
        }
    }

    public String toString() {
        return this.getValueAsString();
    }
}

