/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Applies a version of the median filter optimized for binary images.


This filter was contributed by Bjorn Hanch Sollie after identifying
that the generic Median filter performed unnecessary operations when
the input image is binary.

This filter computes an image where a given pixel is the median value
of the pixels in a neighborhood about the corresponding input pixel.
For the case of binary images the median can be obtained by simply
counting the neighbors that are foreground.

A median filter is one of the family of nonlinear filters. It is used
to smooth an image without being biased by outliers or shot noise.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::BinaryMedian for the procedural interface

 itk::BinaryMedianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMedianImageFilter.h
*/
public class BinaryMedianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryMedianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryMedianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryMedianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryMedianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryMedianImageFilter::~BinaryMedianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryMedianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryMedianImageFilter::BinaryMedianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryMedianImageFilter() {
    this(SimpleITKJNI.new_BinaryMedianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryMedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.BinaryMedianImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::BinaryMedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.BinaryMedianImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryMedianImageFilter::GetRadius() const

Get the radius of the neighborhood used to compute the median

*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryMedianImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryMedianImageFilter::SetForegroundValue(double ForegroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryMedianImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryMedianImageFilter::GetForegroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryMedianImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMedianImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryMedianImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryMedianImageFilter::GetBackgroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryMedianImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMedianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryMedianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMedianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryMedianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryMedianImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryMedianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
