/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Derived class implementing a specific patch-based denoising algorithm,
as detailed below.


This class is derived from the base class PatchBasedDenoisingBaseImageFilter ; please refer to the documentation of the base class first. This
class implements a denoising filter that uses iterative non-local, or
semi-local, weighted averaging of image patches for image denoising.
The intensity at each pixel 'p' gets updated as a weighted average of
intensities of a chosen subset of pixels from the image.

This class implements the denoising algorithm using a Gaussian kernel
function for nonparametric density estimation. The class implements a
scheme to automatically estimated the kernel bandwidth parameter
(namely, sigma) using leave-one-out cross validation. It implements
schemes for random sampling of patches non-locally (from the entire
image) as well as semi-locally (from the spatial proximity of the
pixel being denoised at the specific point in time). It implements a
specific scheme for defining patch weights (mask) as described in
Awate and Whitaker 2005 IEEE CVPR and 2006 IEEE TPAMI.


See:
 PatchBasedDenoisingBaseImageFilter

 itk::PatchBasedDenoisingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkPatchBasedDenoisingImageFilter.h
*/
public class PatchBasedDenoisingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected PatchBasedDenoisingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.PatchBasedDenoisingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PatchBasedDenoisingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PatchBasedDenoisingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::PatchBasedDenoisingImageFilter::~PatchBasedDenoisingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_PatchBasedDenoisingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::PatchBasedDenoisingImageFilter::PatchBasedDenoisingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  PatchBasedDenoisingImageFilter() {
    this(SimpleITKJNI.new_PatchBasedDenoisingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthSigma(double KernelBandwidthSigma)

Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.

*/
public  void setKernelBandwidthSigma(double KernelBandwidthSigma) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setKernelBandwidthSigma(swigCPtr, this, KernelBandwidthSigma);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthSigma() const

Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.

*/
public  double getKernelBandwidthSigma() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getKernelBandwidthSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetPatchRadius(uint32_t PatchRadius)

Set/Get the patch radius specified in physical coordinates. Patch
radius is preferably set to an even number. Currently, only isotropic
patches in physical space are allowed; patches can be anisotropic in
voxel space.

*/
public  void setPatchRadius(long PatchRadius) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setPatchRadius(swigCPtr, this, PatchRadius);
  }

  /**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetPatchRadius() const

Set/Get the patch radius specified in physical coordinates. Patch
radius is preferably set to an even number. Currently, only isotropic
patches in physical space are allowed; patches can be anisotropic in
voxel space.

*/
public  long getPatchRadius() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getPatchRadius(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)

Set/Get the number of denoising iterations to perform. Must be a
positive integer. Defaults to 1.

*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfIterations() const

Set/Get the number of denoising iterations to perform. Must be a
positive integer. Defaults to 1.

*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetNumberOfSamplePatches(uint32_t NumberOfSamplePatches)

Set/Get the number of patches to sample for each pixel.

*/
public  void setNumberOfSamplePatches(long NumberOfSamplePatches) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setNumberOfSamplePatches(swigCPtr, this, NumberOfSamplePatches);
  }

  /**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfSamplePatches() const
*/
public  long getNumberOfSamplePatches() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getNumberOfSamplePatches(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetSampleVariance(double SampleVariance)

Set/Get the variance of the domain where patches are sampled.

*/
public  void setSampleVariance(double SampleVariance) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setSampleVariance(swigCPtr, this, SampleVariance);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetSampleVariance() const

Set/Get the variance of the domain where patches are sampled.

*/
public  double getSampleVariance() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getSampleVariance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModel(NoiseModelType NoiseModel)

Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.

*/
public  void setNoiseModel(PatchBasedDenoisingImageFilter.NoiseModelType NoiseModel) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setNoiseModel(swigCPtr, this, NoiseModel.swigValue());
  }

  /**
NoiseModelType itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModel() const

Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.

*/
public  PatchBasedDenoisingImageFilter.NoiseModelType getNoiseModel() {
    return PatchBasedDenoisingImageFilter.NoiseModelType.swigToEnum(SimpleITKJNI.PatchBasedDenoisingImageFilter_getNoiseModel(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetNoiseSigma(double NoiseSigma)

Set/Get the noise sigma. Used by the noise model where appropriate,
defaults to 5% of the image intensity range

*/
public  void setNoiseSigma(double NoiseSigma) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setNoiseSigma(swigCPtr, this, NoiseSigma);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetNoiseSigma() const
*/
public  double getNoiseSigma() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getNoiseSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModelFidelityWeight(double NoiseModelFidelityWeight)

Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.

*/
public  void setNoiseModelFidelityWeight(double NoiseModelFidelityWeight) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setNoiseModelFidelityWeight(swigCPtr, this, NoiseModelFidelityWeight);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModelFidelityWeight() const

Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.

*/
public  double getNoiseModelFidelityWeight() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getNoiseModelFidelityWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetAlwaysTreatComponentsAsEuclidean(bool AlwaysTreatComponentsAsEuclidean)

Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.

*/
public  void setAlwaysTreatComponentsAsEuclidean(boolean AlwaysTreatComponentsAsEuclidean) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setAlwaysTreatComponentsAsEuclidean(swigCPtr, this, AlwaysTreatComponentsAsEuclidean);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOn()

Set the value of AlwaysTreatComponentsAsEuclidean to true or false
respectfully.

*/
public  void alwaysTreatComponentsAsEuclideanOn() {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_alwaysTreatComponentsAsEuclideanOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOff()
*/
public  void alwaysTreatComponentsAsEuclideanOff() {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_alwaysTreatComponentsAsEuclideanOff(swigCPtr, this);
  }

  /**
bool itk::simple::PatchBasedDenoisingImageFilter::GetAlwaysTreatComponentsAsEuclidean() const

Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.

*/
public  boolean getAlwaysTreatComponentsAsEuclidean() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getAlwaysTreatComponentsAsEuclidean(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthEstimation(bool KernelBandwidthEstimation)

Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.

*/
public  void setKernelBandwidthEstimation(boolean KernelBandwidthEstimation) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setKernelBandwidthEstimation(swigCPtr, this, KernelBandwidthEstimation);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOn()

Set the value of KernelBandwidthEstimation to true or false
respectfully.

*/
public  void kernelBandwidthEstimationOn() {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_kernelBandwidthEstimationOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOff()
*/
public  void kernelBandwidthEstimationOff() {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_kernelBandwidthEstimationOff(swigCPtr, this);
  }

  /**
bool itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthEstimation() const

Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.

*/
public  boolean getKernelBandwidthEstimation() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getKernelBandwidthEstimation(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthMultiplicationFactor(double KernelBandwidthMultiplicationFactor)

Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.

*/
public  void setKernelBandwidthMultiplicationFactor(double KernelBandwidthMultiplicationFactor) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setKernelBandwidthMultiplicationFactor(swigCPtr, this, KernelBandwidthMultiplicationFactor);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthMultiplicationFactor() const

Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.

*/
public  double getKernelBandwidthMultiplicationFactor() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getKernelBandwidthMultiplicationFactor(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthUpdateFrequency(uint32_t KernelBandwidthUpdateFrequency)

Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.

*/
public  void setKernelBandwidthUpdateFrequency(long KernelBandwidthUpdateFrequency) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setKernelBandwidthUpdateFrequency(swigCPtr, this, KernelBandwidthUpdateFrequency);
  }

  /**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthUpdateFrequency() const

Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.

*/
public  long getKernelBandwidthUpdateFrequency() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getKernelBandwidthUpdateFrequency(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthFractionPixelsForEstimation(double KernelBandwidthFractionPixelsForEstimation)

Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.

*/
public  void setKernelBandwidthFractionPixelsForEstimation(double KernelBandwidthFractionPixelsForEstimation) {
    SimpleITKJNI.PatchBasedDenoisingImageFilter_setKernelBandwidthFractionPixelsForEstimation(swigCPtr, this, KernelBandwidthFractionPixelsForEstimation);
  }

  /**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthFractionPixelsForEstimation() const

Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.

*/
public  double getKernelBandwidthFractionPixelsForEstimation() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getKernelBandwidthFractionPixelsForEstimation(swigCPtr, this);
  }

  /**
std::string itk::simple::PatchBasedDenoisingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::PatchBasedDenoisingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.PatchBasedDenoisingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::PatchBasedDenoisingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.PatchBasedDenoisingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class NoiseModelType {
    public final static PatchBasedDenoisingImageFilter.NoiseModelType NOMODEL = new PatchBasedDenoisingImageFilter.NoiseModelType("NOMODEL");
    public final static PatchBasedDenoisingImageFilter.NoiseModelType GAUSSIAN = new PatchBasedDenoisingImageFilter.NoiseModelType("GAUSSIAN");
    public final static PatchBasedDenoisingImageFilter.NoiseModelType RICIAN = new PatchBasedDenoisingImageFilter.NoiseModelType("RICIAN");
    public final static PatchBasedDenoisingImageFilter.NoiseModelType POISSON = new PatchBasedDenoisingImageFilter.NoiseModelType("POISSON");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static NoiseModelType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + NoiseModelType.class + " with value " + swigValue);
    }

    private NoiseModelType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private NoiseModelType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private NoiseModelType(String swigName, NoiseModelType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static NoiseModelType[] swigValues = { NOMODEL, GAUSSIAN, RICIAN, POISSON };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
