/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.similarity.FastSimHashVersion;
import com.dynatrace.hash4j.similarity.MinHashVersion;
import com.dynatrace.hash4j.similarity.SimHashVersion;
import com.dynatrace.hash4j.similarity.SimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.SuperMinHashVersion;

public interface SimilarityHashing {
    public static SimilarityHashPolicy minHash(int numberOfComponents, int bitsPerComponent) {
        return SimilarityHashing.minHash(numberOfComponents, bitsPerComponent, MinHashVersion.DEFAULT);
    }

    public static SimilarityHashPolicy minHash(int numberOfComponents, int bitsPerComponent, MinHashVersion minHashVersion) {
        return minHashVersion.create(numberOfComponents, bitsPerComponent);
    }

    public static SimilarityHashPolicy superMinHash(int numberOfComponents, int bitsPerComponent) {
        return SimilarityHashing.superMinHash(numberOfComponents, bitsPerComponent, SuperMinHashVersion.DEFAULT);
    }

    public static SimilarityHashPolicy superMinHash(int numberOfComponents, int bitsPerComponent, SuperMinHashVersion superMinHashVersion) {
        return superMinHashVersion.create(numberOfComponents, bitsPerComponent);
    }

    public static SimilarityHashPolicy fastSimHash(int numberOfComponents) {
        return SimilarityHashing.fastSimHash(numberOfComponents, FastSimHashVersion.DEFAULT);
    }

    public static SimilarityHashPolicy fastSimHash(int numberOfComponents, FastSimHashVersion fastSimHashVersion) {
        return fastSimHashVersion.create(numberOfComponents);
    }

    public static SimilarityHashPolicy simHash(int numberOfComponents) {
        return SimilarityHashing.simHash(numberOfComponents, SimHashVersion.DEFAULT);
    }

    public static SimilarityHashPolicy simHash(int numberOfComponents, SimHashVersion simHashVersion) {
        return simHashVersion.create(numberOfComponents);
    }
}

