/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;

public interface PathTreeUtils {
    public static String asString(Path path, String separator) {
        if (path.getFileSystem().getSeparator().equals(separator)) {
            return path.toString();
        }
        int nameCount = path.getNameCount();
        if (nameCount == 0) {
            return "";
        }
        if (nameCount == 1) {
            return path.getName(0).toString();
        }
        StringBuilder s = new StringBuilder();
        s.append(path.getName(0));
        for (int i = 1; i < nameCount; ++i) {
            s.append(separator).append(path.getName(i));
        }
        return s.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsCaseSensitivePath(PathTree pathTree, String relativePath) {
        if (!pathTree.contains(relativePath)) {
            return false;
        }
        if (File.separatorChar != '\\') {
            return true;
        }
        relativePath = relativePath.replace(File.separatorChar, '/');
        String[] pathElements = relativePath.split("/");
        try (OpenPathTree openTree = pathTree.open();){
            Path root;
            Iterator<Path> iterator = openTree.getRoots().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!PathTreeUtils.containsCaseSensitivePath(root = iterator.next(), pathElements));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean containsCaseSensitivePath(Path root, String[] pathElements) {
        Path parent = root;
        String[] stringArray = pathElements;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElement = stringArray[n2];
            if (!Files.isDirectory(parent, new LinkOption[0])) {
                return false;
            }
            try (Stream<Path> stream = Files.list(parent);){
                Iterator i = stream.iterator();
                Path match = null;
                while (i.hasNext()) {
                    Path next = (Path)i.next();
                    if (!pathElement.equals(next.getFileName().toString())) continue;
                    match = next;
                    break;
                }
                if (match == null) {
                    boolean bl = false;
                    return bl;
                }
                parent = match;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw e;
            }
            ++n2;
        }
        return true;
    }
}

