/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.crf.CRFTagger;
import com.hankcs.hanlp.model.crf.FeatureTemplate;
import com.hankcs.hanlp.model.crf.crfpp.FeatureIndex;
import com.hankcs.hanlp.model.perceptron.PerceptronNERecognizer;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.NERInstance;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CRFNERecognizer
extends CRFTagger
implements NERecognizer {
    public NERTagSet tagSet;
    private PerceptronNERecognizer perceptronNERecognizer;

    public CRFNERecognizer() throws IOException {
        this(HanLP.Config.CRFNERModelPath);
    }

    public CRFNERecognizer(String modelPath) throws IOException {
        this(modelPath, null);
    }

    public CRFNERecognizer(String modelPath, String[] customNERTags) throws IOException {
        super(modelPath);
        if (this.model == null) {
            this.tagSet = new NERTagSet();
            this.addDefaultNERLabels();
            if (customNERTags != null) {
                for (String nerTags : customNERTags) {
                    this.addNERLabels(nerTags);
                }
            }
        } else {
            this.perceptronNERecognizer = new PerceptronNERecognizer(this.model);
            this.tagSet = this.perceptronNERecognizer.getNERTagSet();
        }
    }

    protected void addDefaultNERLabels() {
        this.tagSet.nerLabels.add("nr");
        this.tagSet.nerLabels.add("ns");
        this.tagSet.nerLabels.add("nt");
    }

    public void addNERLabels(String newNerTag) {
        this.tagSet.nerLabels.add(newNerTag);
    }

    @Override
    protected void convertCorpus(Sentence sentence, BufferedWriter bw) throws IOException {
        List<String[]> collector = Utility.convertSentenceToNER(sentence, this.tagSet);
        for (String[] tuple : collector) {
            bw.write(tuple[0]);
            bw.write(9);
            bw.write(tuple[1]);
            bw.write(9);
            bw.write(tuple[2]);
            bw.newLine();
        }
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        return this.perceptronNERecognizer.recognize(this.createInstance(wordArray, posArray));
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.tagSet;
    }

    private NERInstance createInstance(String[] wordArray, String[] posArray) {
        final FeatureTemplate[] featureTemplateArray = this.model.getFeatureTemplateArray();
        return new NERInstance(wordArray, posArray, this.model.featureMap){

            @Override
            protected int[] extractFeature(String[] wordArray, String[] posArray, FeatureMap featureMap, int position) {
                StringBuilder sbFeature = new StringBuilder();
                LinkedList<Integer> featureVec = new LinkedList<Integer>();
                for (int i = 0; i < featureTemplateArray.length; ++i) {
                    Iterator<int[]> offsetIterator = featureTemplateArray[i].offsetList.iterator();
                    Iterator<String> delimiterIterator = featureTemplateArray[i].delimiterList.iterator();
                    delimiterIterator.next();
                    while (offsetIterator.hasNext()) {
                        boolean first;
                        int[] offset = offsetIterator.next();
                        int t = offset[0] + position;
                        boolean bl = first = offset[1] == 0;
                        if (t < 0) {
                            sbFeature.append(FeatureIndex.BOS[-(t + 1)]);
                        } else if (t >= wordArray.length) {
                            sbFeature.append(FeatureIndex.EOS[t - wordArray.length]);
                        } else {
                            sbFeature.append(first ? wordArray[t] : posArray[t]);
                        }
                        if (delimiterIterator.hasNext()) {
                            sbFeature.append(delimiterIterator.next());
                            continue;
                        }
                        sbFeature.append(i);
                    }
                    1.addFeatureThenClear(sbFeature, featureVec, featureMap);
                }
                return 1.toFeatureArray(featureVec);
            }
        };
    }

    @Override
    protected String getDefaultFeatureTemplate() {
        return "# Unigram\nU0:%x[-2,0]\nU1:%x[-1,0]\nU2:%x[0,0]\nU3:%x[1,0]\nU4:%x[2,0]\nU5:%x[-2,1]\nU6:%x[-1,1]\nU7:%x[0,1]\nU8:%x[1,1]\nU9:%x[2,1]\nUA:%x[-2,1]%x[-1,1]\nUB:%x[-1,1]%x[0,1]\nUC:%x[0,1]%x[1,1]\nUD:%x[1,1]%x[2,1]\nUE:%x[2,1]%x[3,1]\n\n# Bigram\nB";
    }
}

