/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class PBKDFPBEKey
extends SecretKeySpec
implements Destroyable,
PBEKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;

    public PBKDFPBEKey(byte[] byArray, String string, PBEKeySpec pBEKeySpec) {
        super(byArray, string);
        this.password = pBEKeySpec.getPassword();
        this.salt = pBEKeySpec.getSalt();
        this.iterationCount = pBEKeySpec.getIterationCount();
    }

    @Override
    public String getAlgorithm() {
        String string = super.getAlgorithm();
        KeyUtil.checkDestroyed(this);
        return string;
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = super.getEncoded();
        KeyUtil.checkDestroyed(this);
        return byArray;
    }

    @Override
    public char[] getPassword() {
        char[] cArray = Arrays.clone(this.password);
        KeyUtil.checkDestroyed(this);
        return cArray;
    }

    @Override
    public byte[] getSalt() {
        byte[] byArray = Arrays.clone(this.salt);
        KeyUtil.checkDestroyed(this);
        return byArray;
    }

    @Override
    public int getIterationCount() {
        int n = this.iterationCount;
        KeyUtil.checkDestroyed(this);
        return n;
    }

    @Override
    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            if (this.salt != null) {
                Arrays.fill(this.salt, (byte)0);
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }
}

