import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateFunctionRequestFilterSensitiveLog, } from "../models/models_0";
import { de_CreateFunctionCommand, se_CreateFunctionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class CreateFunctionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "CreateFunction", {})
    .n("CloudFrontClient", "CreateFunctionCommand")
    .f(CreateFunctionRequestFilterSensitiveLog, void 0)
    .ser(se_CreateFunctionCommand)
    .de(de_CreateFunctionCommand)
    .build() {
}
