/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLEntityRenderingCacheImpl
implements OWLEntityRenderingCache {
    private final Multimap<String, OWLClass> owlClassMap = ArrayListMultimap.create((int)16, (int)1);
    private final Multimap<String, OWLObjectProperty> owlObjectPropertyMap = ArrayListMultimap.create((int)16, (int)1);
    private final Multimap<String, OWLDataProperty> owlDataPropertyMap = ArrayListMultimap.create((int)16, (int)1);
    private final Multimap<String, OWLAnnotationProperty> owlAnnotationPropertyMap = ArrayListMultimap.create((int)16, (int)1);
    private final Multimap<String, OWLNamedIndividual> owlIndividualMap = ArrayListMultimap.create((int)16, (int)1);
    private final Multimap<String, OWLDatatype> owlDatatypeMap = ArrayListMultimap.create((int)16, (int)1);
    private final Map<OWLEntity, String> entityRenderingMap = new HashMap<OWLEntity, String>();
    private final OWLOntologyChangeListener listener = this::processChanges;
    private OWLModelManager owlModelManager;
    private static final Comparator<DefRefCount<?>> byDefinitionCountThenReferenceCount = Comparator.comparingInt(DefRefCount::getDefinitionCount).thenComparingInt(DefRefCount::getReferenceCount);

    @Override
    public void setOWLModelManager(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        owlModelManager.addOntologyChangeListener(this.listener);
    }

    private void processChanges(List<? extends OWLOntologyChange> changes) {
        changes.stream().filter(OWLOntologyChange::isAxiomChange).flatMap(chg -> chg.getSignature().stream()).distinct().forEach(this::updateRendering);
    }

    @Override
    public void rebuild() {
        this.clear();
        this.owlModelManager.getOWLEntityRenderer();
        OWLDataFactory factory = this.owlModelManager.getOWLDataFactory();
        this.addRendering(factory.getOWLThing(), this.owlClassMap);
        this.addRendering(factory.getOWLNothing(), this.owlClassMap);
        this.addRendering(factory.getOWLTopObjectProperty(), this.owlObjectPropertyMap);
        this.addRendering(factory.getOWLBottomObjectProperty(), this.owlObjectPropertyMap);
        this.addRendering(factory.getOWLTopDataProperty(), this.owlDataPropertyMap);
        this.addRendering(factory.getOWLBottomDataProperty(), this.owlDataPropertyMap);
        for (OWLOntology ont : this.owlModelManager.getOntologies()) {
            for (OWLClass oWLClass : ont.getClassesInSignature()) {
                this.addRendering(oWLClass, this.owlClassMap);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getObjectPropertiesInSignature()) {
                this.addRendering(oWLObjectProperty, this.owlObjectPropertyMap);
            }
            for (OWLDataProperty oWLDataProperty : ont.getDataPropertiesInSignature()) {
                this.addRendering(oWLDataProperty, this.owlDataPropertyMap);
            }
            for (OWLIndividual oWLIndividual : ont.getIndividualsInSignature()) {
                if (oWLIndividual.isAnonymous()) continue;
                this.addRendering(oWLIndividual.asOWLNamedIndividual(), this.owlIndividualMap);
            }
            for (OWLAnnotationProperty oWLAnnotationProperty : ont.getAnnotationPropertiesInSignature()) {
                this.addRendering(oWLAnnotationProperty, this.owlAnnotationPropertyMap);
            }
        }
        for (IRI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.addRendering(factory.getOWLAnnotationProperty(uri), this.owlAnnotationPropertyMap);
        }
        for (Iterator<Object> iterator : DublinCoreVocabulary.values()) {
            this.addRendering(factory.getOWLAnnotationProperty(iterator.getIRI()), this.owlAnnotationPropertyMap);
        }
        OWLDataTypeUtils datatypeUtils = new OWLDataTypeUtils(this.owlModelManager.getOWLOntologyManager());
        for (OWLDatatype dt : datatypeUtils.getKnownDatatypes(this.owlModelManager.getActiveOntologies())) {
            this.addRendering(dt, this.owlDatatypeMap);
        }
    }

    public void dispose() {
        this.clear();
        this.owlModelManager.removeOntologyChangeListener(this.listener);
    }

    private void clear() {
        this.owlClassMap.clear();
        this.owlObjectPropertyMap.clear();
        this.owlDataPropertyMap.clear();
        this.owlAnnotationPropertyMap.clear();
        this.owlIndividualMap.clear();
        this.owlDatatypeMap.clear();
        this.entityRenderingMap.clear();
    }

    private <E extends OWLEntity> E getFirstEntityOrNull(Multimap<String, E> renderingMap, String rendering) {
        Collection entities = renderingMap.get((Object)rendering);
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return (E)((OWLEntity)entities.stream().findFirst().get());
        }
        return (E)((OWLEntity)entities.stream().map(this::toActiveOntologyReferenceCount).max(byDefinitionCountThenReferenceCount).map(DefRefCount::getEntity).orElse(null));
    }

    @Override
    public OWLClass getOWLClass(String rendering) {
        return this.getFirstEntityOrNull(this.owlClassMap, rendering);
    }

    @Override
    public Set<OWLEntity> getOWLEntities(String rendering) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.owlClassMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlObjectPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlDataPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlAnnotationPropertyMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlIndividualMap.get((Object)rendering));
        builder.addAll((Iterable)this.owlDatatypeMap.get((Object)rendering));
        return builder.build();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String rendering) {
        return this.getFirstEntityOrNull(this.owlObjectPropertyMap, rendering);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String rendering) {
        return this.getFirstEntityOrNull(this.owlDataPropertyMap, rendering);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String rendering) {
        return this.getFirstEntityOrNull(this.owlAnnotationPropertyMap, rendering);
    }

    @Override
    public OWLNamedIndividual getOWLIndividual(String rendering) {
        return this.getFirstEntityOrNull(this.owlIndividualMap, rendering);
    }

    @Override
    public OWLDatatype getOWLDatatype(String rendering) {
        return this.getFirstEntityOrNull(this.owlDatatypeMap, rendering);
    }

    @Override
    public String getRendering(OWLEntity owlEntity) {
        return this.entityRenderingMap.get(owlEntity);
    }

    @Override
    @Nullable
    public OWLEntity getOWLEntity(String rendering) {
        OWLClass entity = this.getOWLClass(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLObjectProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDataProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLIndividual(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDatatype(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLAnnotationProperty(rendering);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    @Override
    public void addRendering(OWLEntity owlEntity) {
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(@Nonnull OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlDataPropertyMap);
            }

            public void visit(@Nonnull OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap);
            }

            public void visit(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
                OWLEntityRenderingCacheImpl.this.addRendering(owlAnnotationProperty, OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap);
            }

            public void visit(@Nonnull OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlIndividualMap);
            }

            public void visit(@Nonnull OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlClassMap);
            }

            public void visit(@Nonnull OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlDatatypeMap);
            }
        });
    }

    private <T extends OWLEntity> void addRendering(T entity, Multimap<String, T> map) {
        if (!this.entityRenderingMap.containsKey(entity)) {
            String rendering = this.owlModelManager.getRendering((OWLObject)entity);
            map.put((Object)rendering, entity);
            this.entityRenderingMap.put(entity, rendering);
        }
    }

    @Override
    public void removeRendering(OWLEntity owlEntity) {
        final String oldRendering = this.entityRenderingMap.get(owlEntity);
        this.entityRenderingMap.remove(owlEntity);
        owlEntity.accept(new OWLEntityVisitor(){
            final /* synthetic */ OWLEntityRenderingCacheImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void visit(@Nonnull OWLClass entity) {
                this.this$0.owlClassMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(@Nonnull OWLDataProperty entity) {
                this.this$0.owlDataPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(@Nonnull OWLObjectProperty entity) {
                this.this$0.owlObjectPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(@Nonnull OWLAnnotationProperty entity) {
                this.this$0.owlAnnotationPropertyMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(@Nonnull OWLNamedIndividual entity) {
                this.this$0.owlIndividualMap.remove((Object)oldRendering, (Object)entity);
            }

            public void visit(@Nonnull OWLDatatype entity) {
                this.this$0.owlDatatypeMap.remove((Object)oldRendering, (Object)entity);
            }
        });
    }

    @Override
    public void updateRendering(OWLEntity ent) {
        boolean updateRendering = false;
        for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
            if (!ont.containsEntityInSignature(ent)) continue;
            updateRendering = true;
            break;
        }
        this.removeRendering(ent);
        if (updateRendering) {
            this.addRendering(ent);
        }
    }

    @Override
    public Set<String> getOWLClassRenderings() {
        return this.owlClassMap.keySet();
    }

    @Override
    public Set<String> getOWLObjectPropertyRenderings() {
        return this.owlObjectPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLDataPropertyRenderings() {
        return this.owlDataPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLAnnotationPropertyRenderings() {
        return this.owlAnnotationPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLIndividualRenderings() {
        return this.owlIndividualMap.keySet();
    }

    @Override
    public Set<String> getOWLDatatypeRenderings() {
        return this.owlDatatypeMap.keySet();
    }

    @Override
    public Set<String> getOWLEntityRenderings() {
        HashSet<String> renderings = new HashSet<String>(this.owlClassMap.size() + this.owlObjectPropertyMap.size() + this.owlDataPropertyMap.size() + this.owlAnnotationPropertyMap.size() + this.owlIndividualMap.size() + this.owlDatatypeMap.size());
        renderings.addAll(this.owlClassMap.keySet());
        renderings.addAll(this.owlObjectPropertyMap.keySet());
        renderings.addAll(this.owlDataPropertyMap.keySet());
        renderings.addAll(this.owlAnnotationPropertyMap.keySet());
        renderings.addAll(this.owlIndividualMap.keySet());
        renderings.addAll(this.owlDatatypeMap.keySet());
        return renderings;
    }

    private <E extends OWLEntity> DefRefCount<E> toActiveOntologyReferenceCount(@Nonnull E entity) {
        OWLOntology activeOntology = this.owlModelManager.getActiveOntology();
        int refCount = activeOntology.getReferencingAxioms(entity, Imports.EXCLUDED).size();
        int defCount = EntitySearcher.getReferencingAxioms(entity, (OWLOntology)activeOntology).size();
        return new DefRefCount<E>(entity, defCount, refCount);
    }

    private static class DefRefCount<E extends OWLEntity> {
        private E entity;
        private int definitionCount;
        private int referenceCount;

        public DefRefCount(E entity, int definitionCount, int referenceCount) {
            this.entity = entity;
            this.definitionCount = definitionCount;
            this.referenceCount = referenceCount;
        }

        public E getEntity() {
            return this.entity;
        }

        public int getDefinitionCount() {
            return this.definitionCount;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }
    }
}

