/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.ExtBuffer;
import com.sun.media.Log;
import com.sun.media.SimpleGraphBuilder;
import java.awt.Component;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;

public class CodecChain {
    static final int STAGES = 5;
    protected Codec[] codecs = null;
    protected Buffer[] buffers = null;
    protected Format[] formats = null;
    protected Renderer renderer = null;
    private boolean deallocated = true;
    protected boolean firstBuffer = true;
    private boolean rtpFormat = false;

    boolean isRawFormat(Format format) {
        return false;
    }

    public void reset() {
        this.firstBuffer = true;
        int i = 0;
        while (i < this.codecs.length) {
            if (this.codecs[i] != null) {
                this.codecs[i].reset();
            }
            ++i;
        }
    }

    public int process(Buffer buffer, boolean render) {
        int codecNo = 0;
        return this.doProcess(codecNo, buffer, render);
    }

    private int doProcess(int codecNo, Buffer input, boolean render) {
        int returnVal;
        Codec codec;
        Format format = input.getFormat();
        if (codecNo == this.codecs.length) {
            if (render) {
                if (this.renderer != null && this.formats[codecNo] != null && this.formats[codecNo] != format && !this.formats[codecNo].equals(format) && !input.isDiscard()) {
                    if (this.renderer.setInputFormat(format) == null) {
                        Log.error("Monitor failed to handle mid-stream format change:");
                        Log.error("  old: " + this.formats[codecNo]);
                        Log.error("  new: " + format);
                        return 1;
                    }
                    this.formats[codecNo] = format;
                }
                try {
                    return this.renderer.process(input);
                }
                catch (Exception e) {
                    Log.dumpStack(e);
                    return 1;
                }
                catch (Error err) {
                    Log.dumpStack(err);
                    return 1;
                }
            }
            return 0;
        }
        if (this.isRawFormat(format)) {
            if (!render) {
                return 0;
            }
        } else if (!this.rtpFormat && this.firstBuffer) {
            if ((input.getFlags() & 0x10) == 0) {
                return 0;
            }
            this.firstBuffer = false;
        }
        if ((codec = this.codecs[codecNo]) != null && this.formats[codecNo] != null && this.formats[codecNo] != format && !this.formats[codecNo].equals(format) && !input.isDiscard()) {
            if (codec.setInputFormat(format) == null) {
                Log.error("Monitor failed to handle mid-stream format change:");
                Log.error("  old: " + this.formats[codecNo]);
                Log.error("  new: " + format);
                return 1;
            }
            this.formats[codecNo] = format;
        }
        do {
            try {
                returnVal = codec.process(input, this.buffers[codecNo]);
            }
            catch (Exception e) {
                Log.dumpStack(e);
                return 1;
            }
            catch (Error err) {
                Log.dumpStack(err);
                return 1;
            }
            if (returnVal == 1) {
                return 1;
            }
            if ((returnVal & 4) != 0) continue;
            if (!this.buffers[codecNo].isDiscard() && !this.buffers[codecNo].isEOM()) {
                this.doProcess(codecNo + 1, this.buffers[codecNo], render);
            }
            this.buffers[codecNo].setOffset(0);
            this.buffers[codecNo].setLength(0);
            this.buffers[codecNo].setFlags(0);
        } while ((returnVal & 2) != 0);
        return returnVal;
    }

    public Component getControlComponent() {
        return null;
    }

    public boolean prefetch() {
        if (!this.deallocated) {
            return true;
        }
        try {
            this.renderer.open();
        }
        catch (ResourceUnavailableException e) {
            return false;
        }
        this.renderer.start();
        this.deallocated = false;
        return true;
    }

    public void deallocate() {
        if (this.deallocated) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.deallocated = true;
    }

    public void close() {
        int i = 0;
        while (i < this.codecs.length) {
            this.codecs[i].close();
            ++i;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    protected boolean buildChain(Format input) {
        String enc;
        Vector formatList = new Vector(10);
        Vector pluginList = SimpleGraphBuilder.findRenderingChain(input, formatList);
        if (pluginList == null) {
            return false;
        }
        int len = pluginList.size();
        this.codecs = new Codec[len - 1];
        this.buffers = new ExtBuffer[len - 1];
        this.formats = new Format[len];
        this.formats[0] = input;
        Log.comment("Monitor codec chain:");
        int j = 0;
        while (j < this.codecs.length) {
            this.codecs[j] = (Codec)pluginList.elementAt(len - j - 1);
            this.formats[j + 1] = (Format)formatList.elementAt(len - j - 2);
            this.buffers[j] = new ExtBuffer();
            this.buffers[j].setFormat(this.formats[j + 1]);
            Log.write("    codec: " + this.codecs[j]);
            Log.write("      format: " + this.formats[j]);
            ++j;
        }
        this.renderer = (Renderer)pluginList.elementAt(0);
        Log.write("    renderer: " + this.renderer);
        Log.write("      format: " + this.formats[this.codecs.length] + "\n");
        if (input.getEncoding() != null && (enc = input.getEncoding().toUpperCase()).endsWith("RTP")) {
            this.rtpFormat = true;
        }
        return true;
    }
}

