﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cur/CostandUsageReportService_EXPORTS.h>
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <aws/cur/CostandUsageReportServiceEndpointRules.h>


namespace Aws
{
namespace CostandUsageReportService
{
namespace Endpoint
{
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::EndpointProviderBase;
using Aws::Endpoint::DefaultEndpointProvider;

using CostandUsageReportServiceClientContextParameters = Aws::Endpoint::ClientContextParameters;

using CostandUsageReportServiceClientConfiguration = Aws::Client::GenericClientConfiguration;
using CostandUsageReportServiceBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the CostandUsageReportService Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using CostandUsageReportServiceEndpointProviderBase =
    EndpointProviderBase<CostandUsageReportServiceClientConfiguration, CostandUsageReportServiceBuiltInParameters, CostandUsageReportServiceClientContextParameters>;

using CostandUsageReportServiceDefaultEpProviderBase =
    DefaultEndpointProvider<CostandUsageReportServiceClientConfiguration, CostandUsageReportServiceBuiltInParameters, CostandUsageReportServiceClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_COSTANDUSAGEREPORTSERVICE_API CostandUsageReportServiceEndpointProvider : public CostandUsageReportServiceDefaultEpProviderBase
{
public:
    using CostandUsageReportServiceResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

    CostandUsageReportServiceEndpointProvider()
      : CostandUsageReportServiceDefaultEpProviderBase(Aws::CostandUsageReportService::CostandUsageReportServiceEndpointRules::GetRulesBlob(), Aws::CostandUsageReportService::CostandUsageReportServiceEndpointRules::RulesBlobSize)
    {}

    ~CostandUsageReportServiceEndpointProvider()
    {
    }
};
} // namespace Endpoint
} // namespace CostandUsageReportService
} // namespace Aws
