﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/panorama/Panorama_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace Panorama
{
namespace Model
{
  enum class ConnectionType
  {
    NOT_SET,
    STATIC_IP,
    DHCP
  };

namespace ConnectionTypeMapper
{
AWS_PANORAMA_API ConnectionType GetConnectionTypeForName(const Aws::String& name);

AWS_PANORAMA_API Aws::String GetNameForConnectionType(ConnectionType value);
} // namespace ConnectionTypeMapper
} // namespace Model
} // namespace Panorama
} // namespace Aws
