/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.lookup;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import org.codehaus.plexus.component.configurator.converters.basic.StringBuilderConverter;
import org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.eclipse.sisu.inject.Weak;

public final class DefaultConverterLookup
implements ConverterLookup {
    private static final ConfigurationConverter[] DEFAULT_CONVERTERS = new ConfigurationConverter[]{new FileConverter(), new BooleanConverter(), new StringConverter(), new IntConverter(), new CollectionConverter(), new ArrayConverter(), new MapConverter(), new PropertiesConverter(), new UrlConverter(), new UriConverter(), new DateConverter(), new EnumConverter(), new LongConverter(), new FloatConverter(), new DoubleConverter(), new CharConverter(), new ByteConverter(), new ShortConverter(), new PlexusConfigurationConverter(), new ClassRealmConverter(), new StringBufferConverter(), new StringBuilderConverter(), new ObjectWithFieldsConverter()};
    private final Map<Class<?>, ConfigurationConverter> lookupCache = Weak.concurrentKeys();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();

    @Override
    public void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type2) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookupCache.get(type2);
        if (converter != null) {
            return converter;
        }
        int i = 0;
        while (i < this.customConverters.size()) {
            converter = this.customConverters.get(i);
            if (converter.canConvert(type2)) {
                this.lookupCache.put(type2, converter);
                return converter;
            }
            ++i;
        }
        i = 0;
        while (i < DEFAULT_CONVERTERS.length) {
            converter = DEFAULT_CONVERTERS[i];
            if (converter.canConvert(type2)) {
                this.lookupCache.put(type2, converter);
                return converter;
            }
            ++i;
        }
        throw new ComponentConfigurationException("Cannot find converter for type: " + type2);
    }

    void setCustomConverters(List<ConfigurationConverter> converters) {
        this.customConverters.addAll(converters);
    }
}

