/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class CustomTableEditor
implements MouseListener,
TraverseListener {
    private final Table table;
    private final TableEditor tableEditor;
    private ContentProposalAdapter proposalAdapter;
    private int columnIndex;
    protected int firstTraverseIndex = -1;
    protected int lastTraverseIndex = -1;
    protected boolean editOnEnter = true;

    public CustomTableEditor(Table table) {
        this(table, null);
    }

    public CustomTableEditor(Table table, ContentProposalAdapter proposalAdapter) {
        this.table = table;
        this.proposalAdapter = proposalAdapter;
        this.tableEditor = new TableEditor(table);
        this.tableEditor.horizontalAlignment = 0x1000000;
        this.tableEditor.verticalAlignment = 128;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.minimumWidth = 50;
        table.addMouseListener((MouseListener)this);
        table.addTraverseListener((TraverseListener)this);
    }

    public void setProposalAdapter(ContentProposalAdapter proposalAdapter) {
        this.proposalAdapter = proposalAdapter;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        TableItem item = this.table.getItem(new Point(e.x, e.y));
        if (item != null) {
            this.columnIndex = UIUtils.getColumnAtPos(item, e.x, e.y);
            UIUtils.asyncExec(() -> this.showEditor(item));
        }
    }

    public void showEditor(TableItem item, int index) {
        this.columnIndex = index;
        this.showEditor(item);
    }

    public void showEditor(TableItem item) {
        this.closeEditor();
        this.table.showItem(item);
        final Control editor = this.createEditor(this.table, this.columnIndex, item);
        if (editor == null) {
            return;
        }
        this.tableEditor.minimumHeight = editor.computeSize((int)-1, (int)-1).y;
        editor.setFocus();
        editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomTableEditor.this.onFocusLost(editor);
            }
        });
        UIUtils.installMacOSFocusLostSubstitution((Widget)editor, () -> this.onFocusLost(editor));
        editor.addTraverseListener((TraverseListener)this);
        UIUtils.applyMainFont(editor);
        this.tableEditor.setEditor(editor, item, this.columnIndex);
    }

    private void onFocusLost(Control editor) {
        this.saveEditorValue(editor, this.columnIndex, this.tableEditor.getItem());
        if (!this.isProposalPopupActive()) {
            this.closeEditor();
        }
    }

    private boolean isProposalPopupActive() {
        return this.proposalAdapter != null && this.proposalAdapter.isProposalPopupOpen();
    }

    public void closeEditor() {
        Control editor = this.tableEditor.getEditor();
        if (editor != null) {
            editor.dispose();
        }
    }

    public void keyTraversed(TraverseEvent e) {
        Control editor = this.tableEditor.getEditor();
        if (editor != null && editor.isDisposed()) {
            editor = null;
        }
        if (e.detail == 4) {
            TableItem[] selection;
            if (editor != null) {
                this.saveEditorValue(editor, this.columnIndex, this.tableEditor.getItem());
                if (!this.isProposalPopupActive()) {
                    this.closeEditor();
                }
            } else if (this.editOnEnter && (selection = this.table.getSelection()) != null && selection.length >= 1) {
                this.showEditor(selection[0]);
            }
            if (this.editOnEnter) {
                e.doit = false;
                e.detail = 0;
            }
        } else if ((e.detail == 16 || e.detail == 8) && editor != null) {
            TableItem item = this.tableEditor.getItem();
            if (item != null) {
                int lastColumn;
                this.saveEditorValue(editor, this.columnIndex, item);
                if (!this.isProposalPopupActive()) {
                    this.closeEditor();
                }
                int n = lastColumn = this.lastTraverseIndex > 0 ? this.lastTraverseIndex : this.table.getColumnCount() - 1;
                if (this.columnIndex < lastColumn) {
                    this.columnIndex = e.detail == 16 ? ++this.columnIndex : --this.columnIndex;
                } else {
                    if (e.detail == 16) {
                        item = UIUtils.getNextTableItem(this.table, this.tableEditor.getItem());
                        if (item == null && this.table.getItemCount() > 0) {
                            item = this.table.getItem(0);
                        }
                    } else {
                        item = UIUtils.getPreviousTableItem(this.table, this.tableEditor.getItem());
                        if (item == null && this.table.getItemCount() > 0) {
                            item = this.table.getItem(this.table.getItemCount() - 1);
                        }
                    }
                    if (item != null) {
                        this.columnIndex = Math.max(this.firstTraverseIndex, 0);
                    } else {
                        return;
                    }
                }
                this.showEditor(item);
                this.table.setSelection(item);
                e.doit = false;
                e.detail = 0;
            }
        } else if (e.detail == 2 && editor != null) {
            if (!this.isProposalPopupActive()) {
                this.closeEditor();
            }
            e.doit = false;
            e.detail = 0;
        }
    }

    protected abstract Control createEditor(Table var1, int var2, TableItem var3);

    protected abstract void saveEditorValue(Control var1, int var2, TableItem var3);
}

