/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionTextProvider;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQuerySourcesInfoCollection;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermErrorNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.Pair;

public abstract class SQLQueryCompletionContext {
    private static final Log log = Log.getLog(SQLQueryCompletionContext.class);
    private static final Set<String> statementStartKeywords = LSMInspections.prepareOffquerySyntaxInspection().predictedWords();
    private static final int statementStartKeywordMaxLength = statementStartKeywords.stream().mapToInt(String::length).max().orElse(0);
    private static final Set<SQLQuerySymbolClass> potentialKeywordPartClassification = Set.of(SQLQuerySymbolClass.UNKNOWN, SQLQuerySymbolClass.ERROR, SQLQuerySymbolClass.RESERVED);
    private final int scriptItemOffset;
    private final int requestOffset;
    protected boolean searchInsideWords;
    private static final SQLQueryDataContextInfo EMPTY_DATA_CONTEXT_INFO = new SQLQueryDataContextInfo(){
        static final SQLQuerySourcesInfoCollection EMPTY_SOURCES_COLLECTION = new SQLQuerySourcesInfoCollection(){

            @Override
            @NotNull
            public Map<SQLQueryRowsSourceModel, SourceResolutionResult> getResolutionResults() {
                return Collections.emptyMap();
            }

            @Override
            @NotNull
            public Set<DBSEntity> getReferencedTables() {
                return Collections.emptySet();
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                return Collections.emptySet();
            }
        };

        @Override
        @NotNull
        public SQLQuerySourcesInfoCollection getKnownSources() {
            return EMPTY_SOURCES_COLLECTION;
        }

        @Override
        @NotNull
        public List<SQLQueryResultColumn> getColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public SourceResolutionResult resolveSource(DBRProgressMonitor monitor, List<String> s) {
            return null;
        }

        @Override
        public boolean isJoin() {
            return false;
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getRightParentColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getLeftParentColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public SQLQueryDataContextInfo getRelatedContext() {
            return null;
        }
    };

    public static int getMaxKeywordLength() {
        return statementStartKeywordMaxLength;
    }

    public static SQLQueryCompletionContext prepareEmpty(int scriptItemOffset, int requestOffset) {
        return new SQLQueryCompletionContext(0, requestOffset){

            @Override
            @NotNull
            public SQLQueryDataContextInfo getDataContext() {
                return SQLQueryDataContextInfo.empty();
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return LSMInspections.SyntaxInspectionResult.EMPTY;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                return List.of(new SQLQueryCompletionSet(this.getRequestOffset(), 0, Collections.emptyList()));
            }
        };
    }

    @NotNull
    public static SQLQueryCompletionContext prepareOffquery(final int scriptItemOffset, int requestOffset) {
        return new SQLQueryCompletionContext(scriptItemOffset, requestOffset){
            private static final LSMInspections.SyntaxInspectionResult syntaxInspectionResult = LSMInspections.prepareOffquerySyntaxInspection();
            private static final Pattern KEYWORD_FILTER_PATTERN = Pattern.compile("([a-zA-Z0-9]+)");

            @Override
            @NotNull
            public SQLQueryDataContextInfo getDataContext() {
                return SQLQueryDataContextInfo.empty();
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                String lineText;
                int lineStartOffset;
                try {
                    IDocument doc = request.getDocument();
                    IRegion lineInfo = doc.getLineInformationOfOffset(this.getRequestOffset());
                    lineStartOffset = lineInfo.getOffset();
                    lineText = doc.get(lineStartOffset, lineInfo.getLength());
                }
                catch (BadLocationException badLocationException) {
                    lineStartOffset = -1;
                    lineText = "";
                }
                Matcher m = KEYWORD_FILTER_PATTERN.matcher(lineText);
                SQLQueryWordEntry filter = null;
                if (m.find() && lineStartOffset >= 0) {
                    MatchResult mr = m.toMatchResult();
                    int inLineOffset = this.getRequestOffset() - lineStartOffset;
                    int i = 0;
                    while (i < mr.groupCount()) {
                        int start = mr.start(i);
                        int end = mr.end(i);
                        if (start <= inLineOffset && end >= inLineOffset) {
                            String filterKeyString = lineText.substring(m.start(), m.end()).toLowerCase();
                            int filterStart = start + lineStartOffset - scriptItemOffset;
                            filter = new SQLQueryWordEntry(filterStart, filterKeyString);
                            break;
                        }
                        ++i;
                    }
                }
                ArrayList<SQLQueryCompletionSet> results = new ArrayList<SQLQueryCompletionSet>();
                this.prepareKeywordCompletions(statementStartKeywords, filter, results);
                return results;
            }
        };
    }

    private SQLQueryCompletionContext(int scriptItemOffset, int requestOffset) {
        this.scriptItemOffset = scriptItemOffset;
        this.requestOffset = requestOffset;
    }

    public int getOffset() {
        return this.scriptItemOffset;
    }

    public int getRequestOffset() {
        return this.requestOffset;
    }

    @NotNull
    public abstract SQLQueryDataContextInfo getDataContext();

    @NotNull
    public abstract LSMInspections.SyntaxInspectionResult getInspectionResult();

    @NotNull
    public Set<String> getAliasesInUse() {
        return Collections.emptySet();
    }

    @NotNull
    public Set<DBSObjectContainer> getExposedContexts() {
        return Collections.emptySet();
    }

    public boolean isColumnNameConflicting(String name) {
        return false;
    }

    @NotNull
    public abstract Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor var1, @NotNull SQLCompletionRequest var2);

    @NotNull
    protected SQLQueryWordEntry makeFilterInfo(@Nullable SQLQueryWordEntry filterKey, @NotNull String filterString) {
        return new SQLQueryWordEntry(filterKey == null ? -1 : this.getOffset() + filterKey.offset, filterString);
    }

    public static SQLQueryCompletionContext prepare(final @NotNull SQLScriptItemAtOffset scriptItem, final int requestOffset, final @Nullable DBCExecutionContext dbcExecutionContext, final @NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult, final @NotNull SQLQueryModel.LexicalContextResolutionResult context, final @Nullable SQLQueryLexicalScopeItem lexicalItem, final @NotNull STMTreeNode[] nameNodes, final boolean hasPeriod, final @Nullable STMTreeNode currentTerm) {
        return new SQLQueryCompletionContext(scriptItem.offset, requestOffset){
            private final Set<DBSObjectContainer> exposedContexts;
            private Map<String, Boolean> columnNameConflicts;
            private SQLQueryDataContextInfo nearestContext;
            private SQLQueryDataContextInfo deepestContext;
            private AssociationsResolutionContext associationsResolutionContext;
            {
                super($anonymous0, $anonymous1);
                this.exposedContexts = SQLQueryCompletionContext.obtainExposedContexts(dBCExecutionContext);
                this.columnNameConflicts = null;
                this.nearestContext = SQLQueryDataContextInfo.empty();
                this.deepestContext = SQLQueryDataContextInfo.empty();
                this.associationsResolutionContext = null;
            }

            private void setContextInfo(SQLQueryDataContextInfo contextInfo) {
                this.nearestContext = contextInfo;
                this.deepestContext = contextInfo;
            }

            private void tryApplyOriginContext() {
                SQLQuerySymbolOrigin sQLQuerySymbolOrigin = context.symbolsOrigin();
                if (sQLQuerySymbolOrigin instanceof SQLQuerySymbolOrigin.RowsSourceRef) {
                    SQLQuerySymbolOrigin.RowsSourceRef rowsSourceOrigin = (SQLQuerySymbolOrigin.RowsSourceRef)sQLQuerySymbolOrigin;
                    this.setContextInfo(SQLQueryDataContextInfo.makeFor(rowsSourceOrigin.getRowsSourceContext()));
                } else {
                    SQLQuerySymbolOrigin sQLQuerySymbolOrigin2 = context.symbolsOrigin();
                    if (sQLQuerySymbolOrigin2 instanceof SQLQuerySymbolOrigin.RowsDataRef) {
                        SQLQuerySymbolOrigin.RowsDataRef rowsDataOrigin = (SQLQuerySymbolOrigin.RowsDataRef)sQLQuerySymbolOrigin2;
                        this.setContextInfo(SQLQueryDataContextInfo.makeFor(rowsDataOrigin.getRowsDataContext()));
                    }
                }
            }

            @NotNull
            private AssociationsResolutionContext getAssociationsContext(@NotNull DBRProgressMonitor monitor, @NotNull SQLQueryDataContextInfo context2, @Nullable SQLQueryWordEntry filterOrNull) {
                return this.associationsResolutionContext != null && this.associationsResolutionContext.context == context2 && this.associationsResolutionContext.filterOrNull == filterOrNull ? this.associationsResolutionContext : (this.associationsResolutionContext = new AssociationsResolutionContext(monitor, context2, filterOrNull));
            }

            @Override
            @NotNull
            public SQLQueryDataContextInfo getDataContext() {
                return this.deepestContext;
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                return this.nearestContext.getKnownSources().getAliasesInUse();
            }

            @Override
            @NotNull
            public Set<DBSObjectContainer> getExposedContexts() {
                return this.exposedContexts;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                boolean keywordsAllowed;
                this.searchInsideWords = request.getContext().isSearchInsideNames();
                int position = this.getRequestOffset() - this.getOffset();
                SQLQueryWordEntry currentWord = this.obtainCurrentWord(currentTerm, position);
                List<SQLQueryWordEntry> parts = this.obtainIdentifierParts(position);
                LinkedList<SQLQueryCompletionSet> completionSets = new LinkedList<SQLQueryCompletionSet>();
                if (lexicalItem != null) {
                    this.prepareLexicalItemCompletions(monitor, request, lexicalItem, position, parts, completionSets);
                } else if (this.nameNodesAreUseful(parts)) {
                    this.tryApplyOriginContext();
                    this.prepareInspectedIdentifierCompletions(monitor, request, parts, completionSets);
                } else if (context.symbolsOrigin() != null) {
                    this.accomplishFromKnownOrigin(monitor, request, context.symbolsOrigin(), null, completionSets);
                } else if (syntaxInspectionResult.expectingIdentifier()) {
                    this.tryApplyOriginContext();
                    this.prepareInspectedIdentifierCompletions(monitor, request, parts, completionSets);
                } else {
                    this.tryApplyOriginContext();
                    this.prepareInspectedFreeCompletions(monitor, request, completionSets);
                }
                boolean bl = keywordsAllowed = (lexicalItem == null || lexicalItem.getOrigin() != null && !lexicalItem.getOrigin().isChained() || lexicalItem.getSymbolClass() != null && potentialKeywordPartClassification.contains((Object)lexicalItem.getSymbolClass())) && !hasPeriod;
                if (keywordsAllowed) {
                    this.prepareKeywordCompletions(syntaxInspectionResult.predictedWords(), currentWord, completionSets);
                }
                completionSets.removeIf(c -> c == null || c.getItems().isEmpty());
                return completionSets;
            }

            private void prepareInspectedFreeCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull List<SQLQueryCompletionSet> completionSets) {
                if ((syntaxInspectionResult.expectingColumnName() || syntaxInspectionResult.expectingColumnReference()) && nameNodes.length == 0) {
                    this.prepareNonPrefixedColumnCompletions(monitor, request, this.deepestContext, null, completionSets);
                }
                if (syntaxInspectionResult.expectingTableReference() && nameNodes.length == 0) {
                    this.prepareTableCompletions(monitor, request, this.deepestContext.getKnownSources(), null, completionSets);
                }
            }

            private boolean nameNodesAreUseful(@NotNull List<SQLQueryWordEntry> parts) {
                return nameNodes.length > 0 && (parts.size() > 1 || parts.size() == 1 && parts.get(0) != null);
            }

            @Nullable
            private SQLQueryWordEntry obtainCurrentWord(STMTreeNode currentTerm2, int position) {
                block4: {
                    Interval wordRange;
                    block6: {
                        block5: {
                            if (currentTerm2 == null) {
                                return null;
                            }
                            wordRange = currentTerm2.getRealInterval();
                            if (wordRange.b < position - 1) break block4;
                            if (!(currentTerm2 instanceof STMTreeTermNode)) break block5;
                            STMTreeTermNode t = (STMTreeTermNode)currentTerm2;
                            if (t.symbol.getType() != 186) break block6;
                        }
                        if (!(currentTerm2 instanceof STMTreeTermErrorNode)) break block4;
                    }
                    return new SQLQueryWordEntry(wordRange.a, currentTerm2.getTextContent().substring(0, position - currentTerm2.getRealInterval().a));
                }
                return null;
            }

            private void prepareInspectedIdentifierCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull List<SQLQueryWordEntry> parts, @NotNull List<SQLQueryCompletionSet> results) {
                String[][] quoteStrs;
                List<SQLQueryWordEntry> prefix = parts.subList(0, parts.size() - 1);
                SQLQueryWordEntry tail = parts.get(parts.size() - 1);
                if (tail != null && (quoteStrs = request.getContext().getDataSource().getSQLDialect().getIdentifierQuoteStrings()) != null && quoteStrs.length > 0) {
                    String qp = Stream.of(quoteStrs).flatMap(ss -> Stream.of(ss)).map(Pattern::quote).distinct().collect(Collectors.joining("|"));
                    tail = new SQLQueryWordEntry(tail.offset, tail.string.replaceAll(qp, ""));
                }
                SQLQueryDataContextInfo defaultContext = this.deepestContext;
                if (syntaxInspectionResult.expectingColumnReference() || syntaxInspectionResult.expectingColumnName()) {
                    this.accomplishColumnReference(monitor, request, defaultContext, prefix, tail, results);
                } else if (syntaxInspectionResult.expectingTableReference()) {
                    this.accomplishTableReference(monitor, request, defaultContext, prefix, tail, results);
                }
            }

            private void accomplishTableReference(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQueryDataContextInfo context2, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail, @NotNull List<SQLQueryCompletionSet> results) {
                if (dbcExecutionContext != null && dbcExecutionContext.getDataSource() != null && DBStructUtils.isConnectedContainer((DBPObject)dbcExecutionContext.getDataSource())) {
                    if (prefix.isEmpty()) {
                        this.prepareTableCompletions(monitor, request, context2.getKnownSources(), tail, results);
                    } else {
                        List<String> contextName = prefix.stream().map(e -> e.string).collect(Collectors.toList());
                        DBSObject prefixObject = SQLSearchUtils.findObjectByFQN(monitor, (DBSObjectContainer)dbcExecutionContext.getDataSource(), dbcExecutionContext, contextName, false, request.getWordDetector());
                        if (prefixObject != null) {
                            SQLQueryCompletionItem.ContextObjectInfo prefixInfo = this.prepareContextInfo(request, prefix, tail, prefixObject);
                            List<SQLQueryCompletionItem> items = this.accomplishTableReferences(monitor, request, context2.getKnownSources(), prefixObject, prefixInfo, tail);
                            this.makeFilteredCompletionSet(prefix.isEmpty() ? tail : prefix.get(0), items, results);
                        }
                    }
                }
            }

            private List<SQLQueryCompletionItem> accomplishTableReferences(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull DBSObject prefixContext, @Nullable SQLQueryCompletionItem.ContextObjectInfo prefixInfo, @Nullable SQLQueryWordEntry filterOrNull) {
                LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
                if (prefixContext instanceof DBSObjectContainer) {
                    DBSObjectContainer container = (DBSObjectContainer)prefixContext;
                    HashSet<Class<DBSPackage>> expectedTypes = new HashSet<Class<DBSPackage>>();
                    expectedTypes.add(DBSSchema.class);
                    expectedTypes.add(DBSCatalog.class);
                    expectedTypes.add(DBSTable.class);
                    expectedTypes.add(DBSView.class);
                    expectedTypes.add(DBSAlias.class);
                    if (request.getContext().isSearchProcedures()) {
                        expectedTypes.add(DBSProcedure.class);
                        expectedTypes.add(DBSPackage.class);
                    }
                    try {
                        this.collectImmediateChildren(monitor, knownSources, List.of(container), o -> expectedTypes.stream().anyMatch(c -> c.isAssignableFrom(o.getClass())), prefixInfo, filterOrNull, items);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                return items;
            }

            private void collectImmediateChildren(@NotNull DBRProgressMonitor monitor, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull Collection<DBSObjectContainer> containers, @Nullable Predicate<DBSObject> filter, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                AssociationsResolutionContext associations = this.getAssociationsContext(monitor, this.deepestContext, filterOrNull);
                for (DBSObjectContainer container : containers) {
                    Collection children = container.getChildren(monitor);
                    for (DBSObject child : children) {
                        SQLQueryWordEntry childName;
                        int score;
                        if (DBUtils.isHiddenObject((Object)child) || filter != null && !filter.test(child) || (score = (childName = this.makeFilterInfo(filterOrNull, child.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                        if (child instanceof DBSEntity) {
                            DBSEntity o = (DBSEntity)child;
                            if (child instanceof DBSTable || child instanceof DBSView) {
                                accumulator.addLast(SQLQueryCompletionItem.forRealTable(score, childName, contextObjext, o, knownSources.getReferencedTables().contains(o), associations.hasRelatedAssociationsWithTable(o)));
                                continue;
                            }
                        }
                        accumulator.addLast(this.makeDbObjectCompletionItem(score, childName, contextObjext, child));
                    }
                }
            }

            private SQLQueryCompletionItem makeDbObjectCompletionItem(int score, @NotNull SQLQueryWordEntry childName, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @NotNull DBSObject child) {
                SQLQueryCompletionItem item;
                if (child instanceof DBSProcedure) {
                    DBSProcedure p = (DBSProcedure)child;
                    item = SQLQueryCompletionItem.forProcedureObject(score, childName, contextObjext, p);
                } else if (child instanceof DBSCatalog) {
                    DBSCatalog p = (DBSCatalog)child;
                    item = SQLQueryCompletionItem.forDbCatalogObject(score, childName, contextObjext, child);
                } else if (child instanceof DBSSchema) {
                    DBSSchema p = (DBSSchema)child;
                    item = SQLQueryCompletionItem.forDbSchemaObject(score, childName, contextObjext, child);
                } else {
                    item = SQLQueryCompletionItem.forDbObject(score, childName, contextObjext, child);
                }
                return item;
            }

            @NotNull
            private void accomplishColumnReference(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQueryDataContextInfo context2, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail, @NotNull List<SQLQueryCompletionSet> results) {
                if (prefix.size() > 0) {
                    this.preparePrefixedColumnCompletions(context2, prefix, tail, results);
                } else {
                    this.prepareNonPrefixedColumnCompletions(monitor, request, context2, tail, results);
                }
            }

            private void preparePrefixedColumnCompletions(@NotNull SQLQueryDataContextInfo context2, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail, @NotNull List<SQLQueryCompletionSet> results) {
                LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem> byAliasItems = new LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem>();
                LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem> byFullNameItems = new LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem>();
                for (SourceResolutionResult rr : context2.getKnownSources().getResolutionResults().values()) {
                    boolean sourceFullnameMatch;
                    boolean sourceAliasMatch;
                    if (prefix.size() == 1) {
                        SQLQueryWordEntry mayBeAliasName = prefix.get(0);
                        sourceAliasMatch = rr.aliasOrNull != null && rr.aliasOrNull.getName().equalsIgnoreCase(mayBeAliasName.filterString);
                    } else {
                        sourceAliasMatch = false;
                    }
                    if (rr.tableOrNull != null) {
                        List<String> parts = SQLQueryCompletionItem.prepareQualifiedNameParts((DBSObject)rr.tableOrNull, null);
                        int partsMatched = 0;
                        int i = prefix.size() - 1;
                        int j = parts.size() - 1;
                        while (i >= 0 && j >= 0) {
                            if (parts.get(j).equalsIgnoreCase(prefix.get((int)i).filterString)) {
                                ++partsMatched;
                            }
                            --i;
                            --j;
                        }
                        sourceFullnameMatch = partsMatched == prefix.size();
                    } else {
                        sourceFullnameMatch = false;
                    }
                    if (!sourceAliasMatch && !sourceFullnameMatch) continue;
                    for (SQLQueryResultColumn c : rr.source.getRowsDataContext().getColumnsList()) {
                        SQLQueryWordEntry key = this.makeFilterInfo(tail, c.symbol.getName());
                        int nameScore = key.matches(tail, this.searchInsideWords);
                        if (nameScore <= 0) continue;
                        if (sourceAliasMatch) {
                            byAliasItems.addLast(SQLQueryCompletionItem.forSubsetColumn(nameScore, key, c, rr, false));
                        }
                        if (!sourceFullnameMatch) continue;
                        byFullNameItems.addLast(SQLQueryCompletionItem.forSubsetColumn(nameScore, key, c, rr, true));
                    }
                }
                if (byAliasItems.size() > 0) {
                    this.makeFilteredCompletionSet(tail, byAliasItems, results);
                }
                if (byFullNameItems.size() > 0) {
                    this.makeFilteredCompletionSet(prefix.get(0), byFullNameItems, results);
                }
            }

            private List<SQLQueryCompletionItem> accomplishQualifiedValueReferences(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull DBSObject prefixContext, @Nullable SQLQueryCompletionItem.ContextObjectInfo prefixInfo, @Nullable SQLQueryWordEntry filterOrNull) {
                LinkedList<SQLQueryCompletionItem> items;
                block5: {
                    Map<DBSObject, SourceResolutionResult> knownTables;
                    block4: {
                        knownTables = knownSources.getResolutionResults().values().stream().filter(rr -> rr.referenceName != null && rr.tableOrNull != null).collect(Collectors.toMap(rr -> rr.tableOrNull, Function.identity()));
                        items = new LinkedList<SQLQueryCompletionItem>();
                        SourceResolutionResult currentTableSource = (SourceResolutionResult)knownTables.get(prefixContext);
                        if (currentTableSource == null) break block4;
                        for (SQLQueryResultColumn c : currentTableSource.source.getRowsDataContext().getColumnsList()) {
                            SQLQueryWordEntry key = this.makeFilterInfo(filterOrNull, c.symbol.getName());
                            int nameScore = key.matches(filterOrNull, this.searchInsideWords);
                            if (nameScore <= 0) continue;
                            items.addLast(SQLQueryCompletionItem.forSubsetColumn(nameScore, key, c, currentTableSource, false));
                        }
                        break block5;
                    }
                    if (!(prefixContext instanceof DBSObjectContainer)) break block5;
                    DBSObjectContainer container = (DBSObjectContainer)prefixContext;
                    HashSet expectedTypes = new HashSet();
                    expectedTypes.add(DBSSchema.class);
                    expectedTypes.add(DBSCatalog.class);
                    expectedTypes.add(DBSTable.class);
                    expectedTypes.add(DBSView.class);
                    if (request.getContext().isSearchProcedures()) {
                        expectedTypes.add(DBSProcedure.class);
                        expectedTypes.add(DBSPackage.class);
                    }
                    expectedTypes.add(DBSSequence.class);
                    try {
                        this.collectImmediateChildren(monitor, knownSources, List.of(container), 4.makeObjectForValueRefFilterPredicate(expectedTypes, knownTables), prefixInfo, filterOrNull, items);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                return items;
            }

            @NotNull
            private static Predicate<DBSObject> makeObjectForValueRefFilterPredicate(Set<Class<?>> expectedTypes, Map<DBSObject, SourceResolutionResult> knownTables) {
                return object -> expectedTypes.stream().anyMatch(expectedTypeClass -> expectedTypeClass.isAssignableFrom(object.getClass())) && (!(object instanceof DBSView) && !(object instanceof DBSTable) || knownTables.containsKey(object));
            }

            private void prepareObjectComponentCompletions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull SQLQueryWordEntry componentNamePart, @NotNull List<Class<? extends DBSObject>> componentTypes, @NotNull List<SQLQueryCompletionSet> results) {
                try {
                    DBSObjectContainer container;
                    DBSEntity entity;
                    List attrs;
                    Collection<Object> components = object instanceof DBSEntity ? ((attrs = (entity = (DBSEntity)object).getAttributes(monitor)) != null ? attrs : Collections.emptyList()) : (object instanceof DBSObjectContainer && DBStructUtils.isConnectedContainer((DBPObject)(container = (DBSObjectContainer)object)) ? container.getChildren(monitor) : Collections.emptyList());
                    LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
                    for (DBSObject o : components) {
                        SQLQueryWordEntry filter;
                        int score;
                        if (!componentTypes.stream().anyMatch(t -> t.isInstance(o)) || (score = (filter = this.makeFilterInfo(componentNamePart, o.getName())).matches(componentNamePart, this.searchInsideWords)) <= 0) continue;
                        items.addLast(this.makeDbObjectCompletionItem(score, filter, null, o));
                    }
                    this.makeFilteredCompletionSet(componentNamePart, items, results);
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                }
            }

            private List<SQLQueryWordEntry> obtainIdentifierParts(int position) {
                ArrayList<SQLQueryWordEntry> parts = new ArrayList<SQLQueryWordEntry>(nameNodes.length);
                int i = 0;
                while (i < nameNodes.length) {
                    block5: {
                        STMTreeNode term;
                        block4: {
                            block3: {
                                term = nameNodes[i];
                                if (!(term instanceof STMTreeTermNode)) break block3;
                                STMTreeTermNode t = (STMTreeTermNode)term;
                                if (t.symbol.getType() != 186) break block4;
                            }
                            if (!(term instanceof STMTreeTermErrorNode)) break block5;
                        }
                        if (term.getRealInterval().b + 1 >= position) break;
                        parts.add(new SQLQueryWordEntry(term.getRealInterval().a, term.getTextContent()));
                    }
                    ++i;
                }
                STMTreeNode currentNode = i >= nameNodes.length ? null : nameNodes[i];
                String currentPart = currentNode == null ? null : currentNode.getTextContent().substring(0, position - currentNode.getRealInterval().a);
                parts.add(currentPart == null ? null : new SQLQueryWordEntry(currentNode.getRealInterval().a, currentPart));
                return parts;
            }

            private SQLQuerySymbolDefinition unrollSymbolDefinition(SQLQuerySymbolDefinition def) {
                while (def instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)def;
                    def = entry.getDefinition();
                }
                return def;
            }

            private void prepareLexicalItemCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQueryLexicalScopeItem lexicalItem2, int position, List<SQLQueryWordEntry> parts, @NotNull List<SQLQueryCompletionSet> results) {
                if (lexicalItem2 instanceof SQLQueryTupleRefEntry) {
                    SQLQueryTupleRefEntry tupleRef = (SQLQueryTupleRefEntry)lexicalItem2;
                    this.accomplishFromKnownOriginOrFallback(monitor, request, tupleRef.getOrigin(), null, parts, results);
                } else if (lexicalItem2 instanceof SQLQueryMemberAccessEntry) {
                    SQLQueryMemberAccessEntry entry = (SQLQueryMemberAccessEntry)lexicalItem2;
                    this.accomplishFromKnownOriginOrFallback(monitor, request, entry.getOrigin(), null, parts, results);
                } else if (lexicalItem2 instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)lexicalItem2;
                    Interval nameRange = entry.getSyntaxNode().getRealInterval();
                    SQLQueryWordEntry namePart = new SQLQueryWordEntry(nameRange.a, entry.getRawName().substring(0, position - nameRange.a));
                    this.accomplishFromKnownOriginOrFallback(monitor, request, entry.getOrigin(), namePart, parts, results);
                } else {
                    throw new UnsupportedOperationException("Unexpected lexical item kind to complete " + lexicalItem2.getClass().getName());
                }
            }

            private void accomplishFromKnownOriginOrFallback(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @Nullable SQLQuerySymbolOrigin origin, @Nullable SQLQueryWordEntry originBasedFilterOrNull, @NotNull List<SQLQueryWordEntry> parts, @NotNull List<SQLQueryCompletionSet> results) {
                if (origin != null) {
                    this.accomplishFromKnownOrigin(monitor, request, origin, originBasedFilterOrNull, results);
                } else if (this.nameNodesAreUseful(parts)) {
                    this.prepareInspectedIdentifierCompletions(monitor, request, parts, results);
                }
            }

            private void accomplishFromKnownOrigin(final @NotNull DBRProgressMonitor monitor, final @NotNull SQLCompletionRequest request, @NotNull SQLQuerySymbolOrigin origin, final @Nullable SQLQueryWordEntry filterOrNull, final @NotNull List<SQLQueryCompletionSet> results) {
                final 4 completionContext = this;
                origin.apply(new SQLQuerySymbolOrigin.Visitor(){

                    @Override
                    public void visitDbObjectFromDbObject(SQLQuerySymbolOrigin.DbObjectFromDbObject origin) {
                        SQLQueryCompletionItem.ContextObjectInfo prefix = new SQLQueryCompletionItem.ContextObjectInfo("", origin.getObject(), true);
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(origin.getRowsContext());
                        this.setContextInfo(contextInfo);
                        switch (origin.getFilterMode()) {
                            case DEFAULT: {
                                this.prepareDefaultObjectCompletion(prefix, origin.getMemberTypes());
                                break;
                            }
                            case ROWSET: {
                                this.makeFilteredCompletionSet(filterOrNull, this.accomplishTableReferences(monitor, request, deepestContext.getKnownSources(), prefix.object(), prefix, filterOrNull), results);
                                DBSObject dBSObject = origin.getObject();
                                if (!(dBSObject instanceof DBSObjectContainer)) break;
                                DBSObjectContainer c = (DBSObjectContainer)dBSObject;
                                this.prepareProceduresCompletions(monitor, request, contextInfo.getKnownSources(), List.of(c), filterOrNull);
                                break;
                            }
                            case VALUE: 
                            case FUNCTION: {
                                this.makeFilteredCompletionSet(filterOrNull, this.accomplishQualifiedValueReferences(monitor, request, deepestContext.getKnownSources(), prefix.object(), prefix, filterOrNull), results);
                                DBSObject dBSObject = origin.getObject();
                                if (!(dBSObject instanceof DBSObjectContainer)) break;
                                DBSObjectContainer c = (DBSObjectContainer)dBSObject;
                                this.prepareProceduresCompletions(monitor, request, contextInfo.getKnownSources(), List.of(c), filterOrNull);
                                break;
                            }
                            case OBJECT: {
                                DBSObject dBSObject = origin.getObject();
                                if (!(dBSObject instanceof DBSObjectContainer)) break;
                                DBSObjectContainer objectContainer = (DBSObjectContainer)dBSObject;
                                this.prepareObjectCompletions(monitor, request, deepestContext.getKnownSources(), List.of(objectContainer), prefix, Set.of(RelationalObjectType.TYPE_UNKNOWN), filterOrNull, results);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unexpected filter mode: " + String.valueOf((Object)origin.getFilterMode()));
                            }
                        }
                    }

                    private void prepareDefaultObjectCompletion(@NotNull SQLQueryCompletionItem.ContextObjectInfo prefix, @NotNull Set<DBSObjectType> memberTypes) {
                        if (memberTypes.size() == 1 && (memberTypes.contains(RelationalObjectType.TYPE_UNKNOWN) || memberTypes.isEmpty())) {
                            this.makeFilteredCompletionSet(filterOrNull, this.accomplishTableReferences(monitor, request, deepestContext.getKnownSources(), prefix.object(), prefix, filterOrNull), results);
                        } else {
                            DBSObject dBSObject = prefix.object();
                            if (dBSObject instanceof DBSObjectContainer) {
                                DBSObjectContainer container = (DBSObjectContainer)dBSObject;
                                this.prepareObjectCompletions(monitor, request, deepestContext.getKnownSources(), List.of(container), prefix, memberTypes, filterOrNull, results);
                            }
                        }
                    }

                    @Override
                    public void visitDbObjectRef(SQLQuerySymbolOrigin.DbObjectRef origin) {
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(origin.getRowsSourceContext());
                        this.setContextInfo(contextInfo);
                        if (origin.isIncludingRowsets()) {
                            this.prepareTableCompletions(monitor, request, contextInfo.getKnownSources(), filterOrNull, results);
                        } else {
                            Collection<DBSObjectContainer> container = this.obtainDefaultContext(monitor, request);
                            if (container != null) {
                                this.prepareObjectCompletions(monitor, request, contextInfo.getKnownSources(), container, null, origin.getObjectTypes(), filterOrNull, results);
                            }
                            this.prepareContextSchemasAndCatalogs(monitor, exposedContexts, null, filterOrNull, results);
                        }
                    }

                    @Override
                    public void visitColumnRefFromReferencedContext(SQLQuerySymbolOrigin.ColumnRefFromReferencedContext origin) {
                        this.makeFilteredCompletionSet(filterOrNull, this.prepareTupleColumns(SQLQueryDataContextInfo.makeFor(origin.getRowsSource().source.getRowsDataContext()), filterOrNull, false), results);
                    }

                    @Override
                    public void visitMemberOfType(SQLQuerySymbolOrigin.MemberOfType origin) {
                        this.accomplishMemberReference(monitor, origin.getType(), filterOrNull, results);
                    }

                    @Override
                    public void visitRowsSourceRef(@NotNull SQLQuerySymbolOrigin.RowsSourceRef rowsSourceRef) {
                        SQLQuerySourcesInfoCollection knownSources = rowsSourceRef.getRowsSourceContext().getKnownSources(false);
                        this.setContextInfo(SQLQueryDataContextInfo.makeFor(rowsSourceRef.getRowsSourceContext()));
                        this.prepareTableCompletions(monitor, request, knownSources, filterOrNull, results);
                    }

                    @Override
                    public void visitRowsDataRef(@NotNull SQLQuerySymbolOrigin.RowsDataRef rowsDataRef) {
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(rowsDataRef.getRowsDataContext());
                        this.setContextInfo(contextInfo);
                        this.prepareNonPrefixedColumnCompletions(monitor, request, contextInfo, filterOrNull, results);
                    }

                    @Override
                    public void visitExpandableRowsTupleRef(SQLQuerySymbolOrigin.ExpandableRowsTupleRef origin) {
                        SQLQueryRowsDataContext tupleSource = origin.getReferencedSource() != null ? origin.getReferencedSource().source.getRowsDataContext() : origin.getRowsDataContext();
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(tupleSource);
                        this.setContextInfo(contextInfo);
                        this.prepareTupleRefExpansionCompletiom(origin.getPlaceholder(), contextInfo, request, completionContext, monitor, results);
                    }

                    @Override
                    public void visitColumnNameFromRowsData(SQLQuerySymbolOrigin.ColumnNameFromRowsData origin) {
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(origin.getRowsDataContext());
                        this.setContextInfo(contextInfo);
                        this.makeFilteredCompletionSet(filterOrNull, this.prepareTupleColumns(contextInfo, filterOrNull, false), results);
                    }

                    @Override
                    public void visitSyntaxBasedFromRowsData(SQLQuerySymbolOrigin.SyntaxBasedFromRowsData origin) {
                        SQLQueryDataContextInfo contextInfo = SQLQueryDataContextInfo.makeFor(origin.getRowsDataContext());
                        this.setContextInfo(contextInfo);
                        this.prepareInspectedFreeCompletions(monitor, request, results);
                    }
                });
            }

            private void prepareTupleRefExpansionCompletiom(STMTreeNode placeholder, SQLQueryDataContextInfo contextInfo, @NotNull SQLCompletionRequest request, SQLQueryCompletionContext completionContext, @NotNull DBRProgressMonitor monitor, @NotNull List<SQLQueryCompletionSet> results) {
                Interval placeholderInterval = placeholder.getRealInterval();
                if (this.getRequestOffset() - this.getOffset() == placeholderInterval.b + 1) {
                    SQLQueryWordEntry placeholderEntry = new SQLQueryWordEntry(placeholderInterval.a, placeholder.getTextContent());
                    SQLQueryCompletionTextProvider formatter = new SQLQueryCompletionTextProvider(request, completionContext, monitor);
                    String columnListString = this.prepareTupleColumns(contextInfo, null, true).stream().map(c -> c.apply(formatter)).collect(Collectors.joining(", "));
                    request.setWordPart("*");
                    this.makeFilteredCompletionSet(placeholderEntry, List.of(SQLQueryCompletionItem.forSpecialText(1, this.makeFilterInfo(placeholderEntry, ""), columnListString, "Tuple columns expansion")), results);
                }
            }

            private void accomplishMemberReference(@NotNull DBRProgressMonitor monitor, @NotNull SQLQueryExprType compositeType, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
                LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem> items = new LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem>();
                try {
                    List<SQLQueryExprType.SQLQueryExprTypeMemberInfo> members = compositeType.getNamedMembers(monitor);
                    for (SQLQueryExprType.SQLQueryExprTypeMemberInfo member : members) {
                        SQLQueryWordEntry itemKey = this.makeFilterInfo(filterOrNull, member.name());
                        int score = itemKey.matches(filterOrNull, this.searchInsideWords);
                        if (score <= 0) continue;
                        SQLQueryCompletionItem item = member.column() != null ? SQLQueryCompletionItem.forSubsetColumn(score, itemKey, member.column(), null, false) : (member.attribute() != null ? SQLQueryCompletionItem.forCompositeField(score, itemKey, member.attribute(), member) : SQLQueryCompletionItem.forSpecialCompositeField(score, itemKey, member));
                        items.addLast((SQLQueryCompletionItem.SQLColumnNameCompletionItem)item);
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
                this.makeFilteredCompletionSet(filterOrNull, items, results);
            }

            private List<SQLQueryCompletionItem> prepareJoinConditionCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLQueryDataContextInfo context2, @Nullable SQLQueryWordEntry filterOrNull) {
                LinkedList<SQLQueryCompletionItem> result = new LinkedList<SQLQueryCompletionItem>();
                Map<SQLQueryRowsSourceModel, SourceResolutionResult> resolutionResults = context2.getKnownSources().getResolutionResults();
                if (resolutionResults.size() > 1 && context2.isJoin()) {
                    AssociationsResolutionContext associations = this.getAssociationsContext(monitor, context2, filterOrNull);
                    for (SQLQueryResultColumn sQLQueryResultColumn : context2.getLeftParentColumnsList()) {
                        if (sQLQueryResultColumn.realAttr == null) continue;
                        Set<DBSEntityAttribute> leftRels = associations.findAssociatedAttributes(monitor, sQLQueryResultColumn.realAttr);
                        for (SQLQueryResultColumn sQLQueryResultColumn2 : context2.getRightParentColumnsList()) {
                            if (sQLQueryResultColumn2.realAttr == null) continue;
                            Set<DBSEntityAttribute> rightRels = associations.findAssociatedAttributes(monitor, sQLQueryResultColumn2.realAttr);
                            if (!leftRels.contains(sQLQueryResultColumn2.realAttr) && !rightRels.contains(sQLQueryResultColumn.realAttr)) continue;
                            SQLQueryWordEntry leftWord = this.makeFilterInfo(null, sQLQueryResultColumn.symbol.getName());
                            int leftScore = leftWord.matches(filterOrNull, this.searchInsideWords);
                            SQLQueryWordEntry rightWord = this.makeFilterInfo(null, sQLQueryResultColumn2.symbol.getName());
                            int rightScore = rightWord.matches(filterOrNull, this.searchInsideWords);
                            if (leftScore <= 0 && rightScore <= 0) continue;
                            SQLQueryCompletionItem.SQLColumnNameCompletionItem leftColumnRef = SQLQueryCompletionItem.forSubsetColumn(leftScore, leftWord, sQLQueryResultColumn, resolutionResults.get(sQLQueryResultColumn.source), true);
                            SQLQueryCompletionItem.SQLColumnNameCompletionItem rightColumnRef = SQLQueryCompletionItem.forSubsetColumn(rightScore, rightWord, sQLQueryResultColumn2, resolutionResults.get(sQLQueryResultColumn2.source), true);
                            int score = Math.max(leftScore, rightScore);
                            SQLQueryWordEntry matchedWord = (leftScore >= rightScore ? leftColumnRef : rightColumnRef).getFilterInfo();
                            result.addLast(SQLQueryCompletionItem.forJoinCondition(score, matchedWord, leftColumnRef, rightColumnRef));
                        }
                    }
                }
                return result;
            }

            private void prepareNonPrefixedColumnCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQueryDataContextInfo context2, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
                List<SQLQueryCompletionItem> resultItems;
                List<? extends SQLQueryCompletionItem> subsetColumns = this.prepareTupleColumns(context2, filterOrNull, true);
                if (syntaxInspectionResult.expectingColumnReference()) {
                    LinkedList<SQLQueryCompletionItem> tableRefs = new LinkedList<SQLQueryCompletionItem>();
                    if (request.getContext().getDataSource().getSQLDialect().supportsQualifiedColumnNames()) {
                        for (SourceResolutionResult rr : context2.getKnownSources().getResolutionResults().values()) {
                            SQLQueryWordEntry tableName;
                            int score;
                            if (rr.aliasOrNull != null && !rr.isCteSubquery) {
                                SQLQueryWordEntry sourceAlias = this.makeFilterInfo(filterOrNull, rr.aliasOrNull.getName());
                                score = sourceAlias.matches(filterOrNull, this.searchInsideWords);
                                if (score <= 0) continue;
                                tableRefs.add(SQLQueryCompletionItem.forRowsSourceAlias(score, sourceAlias, rr.aliasOrNull, rr, false));
                                continue;
                            }
                            if (rr.tableOrNull == null || (score = (tableName = this.makeFilterInfo(filterOrNull, rr.tableOrNull.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                            tableRefs.add(SQLQueryCompletionItem.forRealTable(score, tableName, null, rr.tableOrNull, true, false));
                        }
                    }
                    List joinConditions = syntaxInspectionResult.expectingJoinCondition() ? this.prepareJoinConditionCompletions(monitor, context2, filterOrNull) : Collections.emptyList();
                    LinkedList<SQLQueryCompletionItem> procedureItems = this.prepareProceduresCompletions(monitor, request, context2.getKnownSources(), null, filterOrNull);
                    LinkedList<SQLQueryCompletionItem> sequenceItems = this.prepareSequencesCompletions(monitor, request, context2.getKnownSources(), null, filterOrNull);
                    resultItems = Stream.of(joinConditions, subsetColumns, tableRefs, procedureItems, sequenceItems).flatMap(Collection::stream).toList();
                } else {
                    resultItems = subsetColumns;
                }
                this.makeFilteredCompletionSet(filterOrNull, resultItems, results);
            }

            @NotNull
            private LinkedList<SQLQueryCompletionItem> prepareProceduresCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @Nullable List<DBSObjectContainer> container, @Nullable SQLQueryWordEntry filterOrNull) {
                Collection<DBSObjectContainer> objectContainers = container;
                if (objectContainers == null) {
                    objectContainers = this.obtainDefaultContext(monitor, request);
                }
                LinkedList<SQLQueryCompletionItem> proceduresItems = new LinkedList<SQLQueryCompletionItem>();
                try {
                    this.collectProcedures(monitor, request, objectContainers, null, filterOrNull, proceduresItems);
                    this.collectPackages(monitor, request, knownSources, this.exposedContexts, null, filterOrNull, proceduresItems);
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                }
                return proceduresItems;
            }

            @NotNull
            private LinkedList<SQLQueryCompletionItem> prepareSequencesCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @Nullable List<DBSObjectContainer> container, @Nullable SQLQueryWordEntry filterOrNull) {
                Collection<DBSObjectContainer> objectContainers = container;
                if (objectContainers == null) {
                    objectContainers = this.obtainDefaultContext(monitor, request);
                }
                LinkedList<SQLQueryCompletionItem> sequenceItems = new LinkedList<SQLQueryCompletionItem>();
                try {
                    this.collectImmediateChildren(monitor, knownSources, objectContainers, o -> o instanceof DBSSequence, null, filterOrNull, sequenceItems);
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                }
                return sequenceItems;
            }

            @Override
            public boolean isColumnNameConflicting(String name) {
                if (this.columnNameConflicts == null) {
                    this.columnNameConflicts = this.getDataContext().getColumnsList().stream().collect(Collectors.groupingBy(c -> c.symbol.getName())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((List)kv.getValue()).size() > 1));
                }
                return this.columnNameConflicts.get(name);
            }

            @NotNull
            private List<? extends SQLQueryCompletionItem> prepareTupleColumns(@NotNull SQLQueryDataContextInfo dataContext, @Nullable SQLQueryWordEntry filterOrNull, boolean useAbsoluteName) {
                SQLQuerySourcesInfoCollection knownSources = dataContext.getKnownSources();
                Stream<SQLQueryCompletionItem.SQLColumnNameCompletionItem> subsetColumns = dataContext.getColumnsList().stream().map(rc -> {
                    SQLQueryWordEntry filterKey = this.makeFilterInfo(filterOrNull, rc.symbol.getName());
                    int score = filterKey.matches(filterOrNull, this.searchInsideWords);
                    return score <= 0 ? null : SQLQueryCompletionItem.forSubsetColumn(score, filterKey, rc, knownSources.getResolutionResults().get(rc.source), useAbsoluteName);
                }).filter(Objects::nonNull);
                return subsetColumns.toList();
            }

            private void prepareTableCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
                LinkedList<SQLQueryCompletionItem> completions = new LinkedList<SQLQueryCompletionItem>();
                AssociationsResolutionContext associations = this.getAssociationsContext(monitor, this.deepestContext, filterOrNull);
                for (SourceResolutionResult rr : knownSources.getResolutionResults().values()) {
                    SQLQueryWordEntry aliasName;
                    int score;
                    if (rr.aliasOrNull == null || !rr.isCteSubquery || (score = (aliasName = this.makeFilterInfo(filterOrNull, rr.aliasOrNull.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                    completions.add(SQLQueryCompletionItem.forRowsSourceAlias(score, aliasName, rr.aliasOrNull, rr, associations.hasRelatedAssociationsWithTable(rr.source)));
                }
                if (dbcExecutionContext != null) {
                    try {
                        Collection<DBSObjectContainer> containers = this.obtainDefaultContext(monitor, request);
                        this.collectTables(monitor, knownSources, containers, null, filterOrNull, completions);
                        this.collectPackages(monitor, request, knownSources, this.exposedContexts, null, filterOrNull, completions);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                this.makeFilteredCompletionSet(filterOrNull, completions, results);
                this.prepareContextSchemasAndCatalogs(monitor, this.exposedContexts, null, filterOrNull, results);
            }

            private void prepareObjectCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull Collection<DBSObjectContainer> contexts, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @NotNull Set<DBSObjectType> objectTypes, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
                LinkedList<SQLQueryCompletionItem> completions = new LinkedList<SQLQueryCompletionItem>();
                HashSet objs = new HashSet();
                try {
                    this.collectImmediateChildren(monitor, knownSources, contexts, o -> objectTypes.stream().anyMatch(t -> t.getTypeClass().isAssignableFrom(o.getClass())) && objs.add(o), contextObjext, filterOrNull, completions);
                    if (request.getContext().isSearchProcedures() && objectTypes.stream().anyMatch(t -> DBSProcedure.class.isAssignableFrom(t.getTypeClass()))) {
                        this.collectProcedures(monitor, request, contexts, contextObjext, filterOrNull, completions);
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
                this.makeFilteredCompletionSet(filterOrNull, completions, results);
            }

            @Nullable
            private Collection<DBSObjectContainer> obtainDefaultContext(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                if (dbcExecutionContext == null) {
                    return Collections.emptyList();
                }
                DBCExecutionContextDefaults defaults = dbcExecutionContext.getContextDefaults();
                if (defaults != null) {
                    DBPDataSource dBPDataSource;
                    DBSSchema defaultSchema = defaults.getDefaultSchema();
                    DBSCatalog defaultCatalog = defaults.getDefaultCatalog();
                    if (defaultCatalog == null && defaultSchema == null && (dBPDataSource = dbcExecutionContext.getDataSource()) instanceof DBSObjectContainer) {
                        DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
                        return List.of(container);
                    }
                    if (defaultCatalog != null && request.getContext().isSearchGlobally()) {
                        HashSet<DBSObjectContainer> result = new HashSet<DBSObjectContainer>();
                        this.findAllSchemaContainers(monitor, (DBSObjectContainer)defaultCatalog, result);
                        return result;
                    }
                    if (defaultCatalog != null && defaultSchema == null) {
                        return List.of(defaultCatalog);
                    }
                    if (defaultSchema != null) {
                        return List.of(defaultSchema);
                    }
                } else {
                    DBPDataSource dBPDataSource = dbcExecutionContext.getDataSource();
                    if (dBPDataSource instanceof DBSObjectContainer) {
                        DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
                        return List.of(container);
                    }
                }
                return Collections.emptyList();
            }

            private void findAllSchemaContainers(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull Set<DBSObjectContainer> result) {
                try {
                    if (result.add(container)) {
                        Collection dbObjs = container.getChildren(monitor);
                        for (DBSObject obj : dbObjs) {
                            if (!(obj instanceof DBSObjectContainer)) continue;
                            DBSObjectContainer child = (DBSObjectContainer)obj;
                            if (!(obj instanceof DBSCatalog) && !(obj instanceof DBSSchema)) continue;
                            this.findAllSchemaContainers(monitor, child, result);
                        }
                    }
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                }
            }

            private void prepareContextSchemasAndCatalogs(@NotNull DBRProgressMonitor monitor, @NotNull Collection<DBSObjectContainer> contexts, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObject, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
                LinkedList<SQLQueryCompletionItem> completions = new LinkedList<SQLQueryCompletionItem>();
                try {
                    for (DBSObjectContainer container : contexts) {
                        Collection children = container.getChildren(monitor);
                        for (DBSObject child : children) {
                            SQLQueryWordEntry childName;
                            int score;
                            if (!(child instanceof DBSSchema) && !(child instanceof DBSCatalog) || (score = (childName = this.makeFilterInfo(filterOrNull, child.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                            completions.addLast(this.makeDbObjectCompletionItem(score, childName, contextObject, child));
                        }
                    }
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                }
                this.makeFilteredCompletionSet(filterOrNull, completions, results);
            }

            private void collectPackages(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull Collection<DBSObjectContainer> contexts, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                if (request.getContext().isSearchProcedures()) {
                    this.collectImmediateChildren(monitor, knownSources, contexts, o -> o instanceof DBSProcedureContainer, contextObjext, filterOrNull, accumulator);
                }
            }

            private void collectProcedures(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull Collection<DBSObjectContainer> containers, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                for (DBSObjectContainer container : containers) {
                    if (request.getContext().isSearchProcedures() && container instanceof DBSProcedureContainer) {
                        Collection procedures;
                        DBSProcedureContainer pc = (DBSProcedureContainer)container;
                        if (request.getContext().getDataSource().getInfo().supportsStoredCode() && (procedures = pc.getProcedures(monitor)) != null) {
                            for (DBSProcedure p : procedures) {
                                SQLQueryWordEntry childName = this.makeFilterInfo(filterOrNull, p.getName());
                                int score = childName.matches(filterOrNull, this.searchInsideWords);
                                if (score <= 0) continue;
                                accumulator.addLast(SQLQueryCompletionItem.forProcedureObject(score, childName, contextObjext, p));
                            }
                        }
                    }
                    if (filterOrNull == null || contextObjext != null) continue;
                    for (String fname : request.getContext().getDataSource().getSQLDialect().getFunctions()) {
                        SQLQueryWordEntry childName = this.makeFilterInfo(filterOrNull, fname);
                        int score = childName.matches(filterOrNull, this.searchInsideWords);
                        if (score <= 0) continue;
                        accumulator.addLast(SQLQueryCompletionItem.forBuiltinFunction(score, childName, fname));
                    }
                }
            }

            private void collectTables(@NotNull DBRProgressMonitor monitor, @NotNull SQLQuerySourcesInfoCollection knownSources, @NotNull Collection<DBSObjectContainer> containers, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                this.collectImmediateChildren(monitor, knownSources, containers, o -> o instanceof DBSTable || o instanceof DBSView, contextObjext, filterOrNull, accumulator);
            }

            private SQLQueryCompletionItem.ContextObjectInfo prepareContextInfo(@NotNull SQLCompletionRequest request, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail, @NotNull DBSObject contextObject) {
                if (contextObject != null) {
                    int prefixStart = prefix.get((int)0).offset;
                    int requestPosition = tail != null ? tail.offset : requestOffset - scriptItem.offset;
                    String prefixString = scriptItem.item.getOriginalText().substring(prefixStart, requestPosition);
                    return new SQLQueryCompletionItem.ContextObjectInfo(prefixString, contextObject, false);
                }
                return null;
            }
        };
    }

    protected void prepareKeywordCompletions(@NotNull Set<String> keywords, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<SQLQueryCompletionSet> results) {
        LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
        for (String s : keywords) {
            SQLQueryWordEntry filterWord = this.makeFilterInfo(filterOrNull, s);
            int score = filterWord.matches(filterOrNull, this.searchInsideWords);
            if (score <= 0) continue;
            items.addLast(SQLQueryCompletionItem.forReservedWord(score, filterWord, s));
        }
        this.makeFilteredCompletionSet(filterOrNull, items, results);
    }

    protected void makeFilteredCompletionSet(@Nullable SQLQueryWordEntry filterOrNull, List<? extends SQLQueryCompletionItem> items, @NotNull List<SQLQueryCompletionSet> results) {
        int replacementPosition = filterOrNull == null ? this.getRequestOffset() : this.getOffset() + filterOrNull.offset;
        int replacementLength = this.getRequestOffset() - replacementPosition;
        results.add(new SQLQueryCompletionSet(replacementPosition, replacementLength, items));
    }

    @NotNull
    private static Set<DBSObjectContainer> obtainExposedContexts(@Nullable DBCExecutionContext dbcExecutionContext) {
        LinkedHashSet<DBSObjectContainer> exposedContexts = new LinkedHashSet<DBSObjectContainer>();
        if (dbcExecutionContext != null) {
            DBSObjectContainer container;
            DBSObject contextObject = DBUtils.getSelectedObject((DBCExecutionContext)dbcExecutionContext);
            while (contextObject != null) {
                if (contextObject instanceof DBSObjectContainer) {
                    container = (DBSObjectContainer)contextObject;
                    exposedContexts.add(container);
                }
                contextObject = contextObject.getParentObject();
            }
            DBPDataSource dataSource = dbcExecutionContext.getDataSource();
            if (dataSource instanceof DBSObjectContainer) {
                container = (DBSObjectContainer)dataSource;
                exposedContexts.add(container);
            }
        }
        return exposedContexts;
    }

    @NotNull
    public static SQLQueryCompletionContext prepareCompletionContext(@NotNull SQLScriptItemAtOffset scriptItem, int offset, @Nullable DBCExecutionContext executionContext, @NotNull SQLDialect dialect) {
        block8: {
            SQLQueryLexicalScopeItem lexicalItem;
            ArrayDeque nameNodes;
            LSMInspections.NameInspectionResult nameInspectionResult;
            SQLQueryModel.LexicalContextResolutionResult context;
            LSMInspections.SyntaxInspectionResult syntaxInspectionResult;
            block10: {
                block9: {
                    int position = offset - scriptItem.offset;
                    SQLQueryModel model = scriptItem.item.getQueryModel();
                    if (model == null) break block8;
                    if (scriptItem.item.hasContextBoundaryAtLength() && position >= scriptItem.item.length()) {
                        return SQLQueryCompletionContext.prepareOffquery(scriptItem.offset, offset);
                    }
                    STMTreeNode syntaxNode = model.getSyntaxNode();
                    Interval parsedInterval = syntaxNode.getRealInterval();
                    if (parsedInterval.a < 0 || parsedInterval.b < 0) {
                        return SQLQueryCompletionContext.prepareEmpty(scriptItem.offset, offset);
                    }
                    if (scriptItem.item.getOriginalText().length() <= SQLQueryCompletionContext.getMaxKeywordLength() && LSMInspections.matchesAnyWord((String)scriptItem.item.getOriginalText()) && position <= scriptItem.item.getOriginalText().length()) {
                        return SQLQueryCompletionContext.prepareOffquery(scriptItem.offset, offset);
                    }
                    LSMInspections inspections = new LSMInspections(dialect, syntaxNode);
                    syntaxInspectionResult = inspections.prepareAbstractSyntaxInspection(position);
                    if (syntaxInspectionResult == null) {
                        return SQLQueryCompletionContext.prepareOffquery(scriptItem.offset, offset);
                    }
                    context = model.findLexicalContext(Math.min(position, model.getSyntaxNode().getRealInterval().b + 1));
                    nameInspectionResult = inspections.collectNameNodes(position);
                    if (nameInspectionResult.positionToInspect() != position) {
                        syntaxInspectionResult = inspections.prepareAbstractSyntaxInspection(nameInspectionResult.positionToInspect());
                    }
                    nameNodes = nameInspectionResult.nameNodes();
                    lexicalItem = context.lexicalItem();
                    if (lexicalItem instanceof SQLQuerySymbolEntry && (nameNodes.isEmpty() || ((STMTreeNode)nameNodes.getFirst()).getRealInterval().a > lexicalItem.getSyntaxNode().getRealInterval().a || ((STMTreeNode)nameNodes.getLast()).getRealInterval().b < lexicalItem.getSyntaxNode().getRealInterval().b)) break block9;
                    if (!(lexicalItem instanceof SQLQueryTupleRefEntry)) break block10;
                    SQLQueryTupleRefEntry e = (SQLQueryTupleRefEntry)lexicalItem;
                    if (e.getSyntaxNode().getRealInterval().b + 1 == position) break block10;
                }
                lexicalItem = null;
            }
            return SQLQueryCompletionContext.prepare(scriptItem, offset, executionContext, syntaxInspectionResult, context, lexicalItem, (STMTreeNode[])nameNodes.toArray(STMTreeNode[]::new), nameInspectionResult.hasPeriod(), nameInspectionResult.currentTerm());
        }
        return SQLQueryCompletionContext.prepareEmpty(0, offset);
    }

    private class AssociationsResolutionContext {
        @NotNull
        private final SQLQueryDataContextInfo context;
        @NotNull
        private final SQLQueryDataContextInfo relatedContext;
        @Nullable
        private final SQLQueryWordEntry filterOrNull;
        @Nullable
        private Map<DBSEntityAttribute, List<SQLQueryCompletionItem.SQLColumnNameCompletionItem>> realColumnRefsByEntityAttribute = null;
        @NotNull
        private final Map<DBSEntity, EntityAssociationsInfo> associatedAttrsByEntity = new HashMap<DBSEntity, EntityAssociationsInfo>();
        @Nullable
        private Set<DBSEntity> allAssociatedEntitiesOfColumnsList = null;
        private final DBRProgressMonitor associationPresenceResolutionMonitor;

        public AssociationsResolutionContext(@NotNull DBRProgressMonitor monitor, @Nullable SQLQueryDataContextInfo context, SQLQueryWordEntry filterOrNull) {
            this.context = context;
            this.relatedContext = this.context.getRelatedContext() == null ? this.context : this.context.getRelatedContext();
            this.filterOrNull = filterOrNull;
            this.associationPresenceResolutionMonitor = new LocalCacheProgressMonitor(monitor);
        }

        private Set<DBSEntity> getAssociatedEntitiesOfColumnsList(@NotNull DBRProgressMonitor monitor) {
            if (this.allAssociatedEntitiesOfColumnsList == null) {
                this.allAssociatedEntitiesOfColumnsList = this.relatedContext.getColumnsList().stream().filter(a -> a.realAttr != null).flatMap(a -> this.findAssociatedEntities(monitor, a.realAttr).stream()).collect(Collectors.toUnmodifiableSet());
            }
            return this.allAssociatedEntitiesOfColumnsList;
        }

        private Set<DBSEntityAttribute> extractRealAttributes(@NotNull List<SQLQueryResultColumn> columnsList) {
            return columnsList.stream().filter(c -> c.realAttr != null).map(c -> c.realAttr).collect(Collectors.toSet());
        }

        public boolean hasRelatedAssociationsWithTable(@NotNull DBSEntity table) {
            EntityAssociationsInfo tableAssociations = this.findAssociationsInfo(this.associationPresenceResolutionMonitor, table);
            if (!this.getAssociatedEntitiesOfColumnsList(this.associationPresenceResolutionMonitor).contains(table)) {
                if (!this.extractRealAttributes(this.relatedContext.getColumnsList()).stream().anyMatch(tableAssociations.allAssociatedAttributes::contains)) {
                    return false;
                }
            }
            return true;
        }

        public boolean hasRelatedAssociationsWithTable(@NotNull SQLQueryRowsSourceModel source) {
            Set<DBSEntityAttribute> tupleAttributes = this.extractRealAttributes(this.relatedContext.getColumnsList());
            Set<DBSEntityAttribute> sourceAttributes = this.extractRealAttributes(source.getRowsDataContext().getColumnsList());
            Set tupleAssociations = tupleAttributes.stream().flatMap(a -> this.findAssociatedAttributes(this.associationPresenceResolutionMonitor, (DBSEntityAttribute)a).stream()).collect(Collectors.toSet());
            if (sourceAttributes.stream().anyMatch(tupleAssociations::contains)) {
                return true;
            }
            Set sourceAssociations = sourceAttributes.stream().flatMap(a -> this.findAssociatedAttributes(this.associationPresenceResolutionMonitor, (DBSEntityAttribute)a).stream()).collect(Collectors.toSet());
            return tupleAttributes.stream().anyMatch(sourceAssociations::contains);
        }

        @NotNull
        private Map<DBSEntityAttribute, List<SQLQueryCompletionItem.SQLColumnNameCompletionItem>> getRealColumnNameCompletionItems() {
            return this.realColumnRefsByEntityAttribute != null ? this.realColumnRefsByEntityAttribute : (this.realColumnRefsByEntityAttribute = this.context.getColumnsList().stream().filter(rc -> rc.realAttr != null && rc.realAttr.getParentObject() == rc.realSource).collect(Collectors.groupingBy(rc -> rc.realAttr)).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, g -> ((List)g.getValue()).stream().map(rc -> {
                SQLQueryWordEntry word = SQLQueryCompletionContext.this.makeFilterInfo(null, rc.symbol.getName());
                int score = word.matches(this.filterOrNull, SQLQueryCompletionContext.this.searchInsideWords);
                return SQLQueryCompletionItem.forSubsetColumn(score, word, rc, this.context.getKnownSources().getResolutionResults().get(rc.source), true);
            }).toList())));
        }

        @NotNull
        public List<SQLQueryCompletionItem.SQLColumnNameCompletionItem> getRealColumnRefsByEntityAttribute(@NotNull DBSEntityAttribute attr) {
            return Optional.ofNullable(this.getRealColumnNameCompletionItems().get(attr)).orElse(Collections.emptyList());
        }

        @NotNull
        public EntityAssociationsInfo findAssociationsInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table) {
            return this.associatedAttrsByEntity.computeIfAbsent(table, e -> this.prepareAllAssociations(monitor, (DBSEntity)e));
        }

        @NotNull
        public Set<DBSEntityAttribute> findAssociatedAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute key) {
            return Optional.ofNullable(this.findAssociationsInfo((DBRProgressMonitor)monitor, (DBSEntity)key.getParentObject()).associationsByAttribute.get(key)).map(t -> t.attributes).orElse(Collections.emptySet());
        }

        @NotNull
        public Set<DBSEntity> findAssociatedEntities(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute key) {
            return Optional.ofNullable(this.findAssociationsInfo((DBRProgressMonitor)monitor, (DBSEntity)key.getParentObject()).associationsByAttribute.get(key)).map(t -> t.entities).orElse(Collections.emptySet());
        }

        @NotNull
        private EntityAssociationsInfo prepareAllAssociations(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) {
            try {
                Map<DBSEntityAttribute, EntityAssociationTargetsInfo> associatedAttributes = Stream.concat(Optional.ofNullable(entity.getAssociations(monitor)).stream().flatMap(Collection::stream), Optional.ofNullable(entity.getReferences(monitor)).stream().flatMap(Collection::stream)).filter(c -> c instanceof DBSTableForeignKey).map(c -> {
                    try {
                        return ((DBSTableForeignKey)c).getAttributeReferences(monitor);
                    }
                    catch (DBException dBException) {
                        return null;
                    }
                }).filter(aa -> aa != null && aa.size() == 1 && aa.getFirst() instanceof DBSTableForeignKeyColumn).map(aa -> (DBSTableForeignKeyColumn)aa.getFirst()).map(attrRef -> {
                    DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                    DBSEntityAttribute targetAttr = attrRef.getReferencedColumn();
                    if (targetAttr != null && sourceAttr != null) {
                        if (sourceAttr.getParentObject() == entity) {
                            return Pair.of((Object)sourceAttr, (Object)targetAttr);
                        }
                        return Pair.of((Object)targetAttr, (Object)sourceAttr);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.groupingBy(Pair::getFirst, Collectors.mapping(Pair::getSecond, Collectors.collectingAndThen(Collectors.toSet(), targetAttrs -> new EntityAssociationTargetsInfo((Set<DBSEntityAttribute>)targetAttrs, targetAttrs.stream().map(DBSEntityElement::getParentObject).collect(Collectors.toUnmodifiableSet()))))));
                Set<DBSEntity> allAssociationTargets = associatedAttributes.values().stream().flatMap(t -> t.entities.stream()).collect(Collectors.toUnmodifiableSet());
                Set<DBSEntityAttribute> allAssociatedAttributes = associatedAttributes.values().stream().flatMap(t -> t.attributes.stream()).collect(Collectors.toUnmodifiableSet());
                return new EntityAssociationsInfo(entity, associatedAttributes, allAssociationTargets, allAssociatedAttributes);
            }
            catch (DBException dBException) {
                return new EntityAssociationsInfo(entity, Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
            }
        }
    }

    @FunctionalInterface
    private static interface CompletionItemProducer<T> {
        public SQLQueryCompletionItem produce(int var1, SQLQueryWordEntry var2, T var3);
    }

    private record EntityAssociationTargetsInfo(@NotNull Set<DBSEntityAttribute> attributes, @NotNull Set<DBSEntity> entities) {
        static /* synthetic */ Set access$5(EntityAssociationTargetsInfo entityAssociationTargetsInfo) {
            return entityAssociationTargetsInfo.attributes;
        }

        static /* synthetic */ Set access$6(EntityAssociationTargetsInfo entityAssociationTargetsInfo) {
            return entityAssociationTargetsInfo.entities;
        }
    }

    private record EntityAssociationsInfo(@NotNull DBSEntity entity, @NotNull Map<DBSEntityAttribute, EntityAssociationTargetsInfo> associationsByAttribute, @NotNull Set<DBSEntity> allAssociatedEntities, @NotNull Set<DBSEntityAttribute> allAssociatedAttributes) {
    }

    public static interface SQLQueryDataContextInfo {
        @NotNull
        public SQLQuerySourcesInfoCollection getKnownSources();

        @NotNull
        public List<SQLQueryResultColumn> getColumnsList();

        @Nullable
        public SourceResolutionResult resolveSource(DBRProgressMonitor var1, List<String> var2);

        public boolean isJoin();

        @NotNull
        public List<? extends SQLQueryResultColumn> getRightParentColumnsList();

        @NotNull
        public List<? extends SQLQueryResultColumn> getLeftParentColumnsList();

        @Nullable
        public SQLQueryDataContextInfo getRelatedContext();

        public static SQLQueryDataContextInfo empty() {
            return EMPTY_DATA_CONTEXT_INFO;
        }

        public static SQLQueryDataContextInfo makeFor(@NotNull SQLQueryRowsSourceContext rowsSourceContext) {
            return new SQLQueryRowsSourceContextInfo(rowsSourceContext);
        }

        public static SQLQueryDataContextInfo makeFor(@NotNull SQLQueryRowsDataContext rowsDataContext) {
            return new SQLQueryRowsDataContextInfo(rowsDataContext);
        }
    }

    private static class SQLQueryRowsDataContextInfo
    extends SQLQueryRowsSourceContextInfo {
        @NotNull
        private final SQLQueryRowsDataContext rowsDataContext;

        public SQLQueryRowsDataContextInfo(@NotNull SQLQueryRowsDataContext rowsDataContext) {
            super(rowsDataContext.getRowsSources());
            this.rowsDataContext = rowsDataContext;
        }

        @Override
        @NotNull
        public List<SQLQueryResultColumn> getColumnsList() {
            return this.rowsDataContext.getColumnsList();
        }

        @Override
        public boolean isJoin() {
            return this.rowsDataContext.getJoinInfo() != null;
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getRightParentColumnsList() {
            return this.isJoin() ? this.rowsDataContext.getJoinInfo().right().getColumnsList() : Collections.emptyList();
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getLeftParentColumnsList() {
            return this.isJoin() ? this.rowsDataContext.getJoinInfo().left().getColumnsList() : Collections.emptyList();
        }

        @Override
        @NotNull
        protected Supplier<SQLQueryDataContextInfo> prepareRelatedContextInfoProvider() {
            return () -> this;
        }
    }

    private static class SQLQueryRowsSourceContextInfo
    implements SQLQueryDataContextInfo {
        @NotNull
        private final SQLQueryRowsSourceContext rowsSourceContext;
        @NotNull
        private final SQLQuerySourcesInfoCollection subquerySources;
        @Nullable
        private Supplier<SQLQueryDataContextInfo> relatedContextInfoProvider = null;

        public SQLQueryRowsSourceContextInfo(@NotNull SQLQueryRowsSourceContext rowsSourceContext) {
            this.rowsSourceContext = rowsSourceContext;
            this.subquerySources = rowsSourceContext.getKnownSources(true);
        }

        @Override
        @NotNull
        public SQLQuerySourcesInfoCollection getKnownSources() {
            return this.subquerySources;
        }

        @Override
        @NotNull
        public List<SQLQueryResultColumn> getColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public SourceResolutionResult resolveSource(DBRProgressMonitor monitor, List<String> tableName) {
            List<DBSEntity> tables = this.rowsSourceContext.getConnectionInfo().findRealTables(monitor, tableName);
            return this.subquerySources.getResolutionResults().values().stream().filter(r -> tables.contains(r.tableOrNull)).findFirst().orElse(null);
        }

        @Override
        public boolean isJoin() {
            return false;
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getRightParentColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<? extends SQLQueryResultColumn> getLeftParentColumnsList() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public final SQLQueryDataContextInfo getRelatedContext() {
            if (this.relatedContextInfoProvider == null) {
                this.relatedContextInfoProvider = this.prepareRelatedContextInfoProvider();
            }
            return this.relatedContextInfoProvider.get();
        }

        @NotNull
        protected Supplier<SQLQueryDataContextInfo> prepareRelatedContextInfoProvider() {
            SQLQueryDataContextInfo relatedContextInfo = this.rowsSourceContext.getRelatedContextProvider() == null ? null : SQLQueryDataContextInfo.makeFor(this.rowsSourceContext.getRelatedContextProvider().get());
            return () -> relatedContextInfo;
        }
    }
}

