/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Flow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotModels;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotProperties;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatChunk;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatRequest;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotMessage;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotSessionToken;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CopilotCompletionEngine
extends BaseCompletionEngine {
    private static final Log log = Log.getLog(CopilotCompletionEngine.class);
    private final DisposableLazyValue<CopilotClient, DBException> client = new DisposableLazyValue<CopilotClient, DBException>(){

        @NotNull
        protected CopilotClient initialize() {
            return new CopilotClient();
        }

        @Override
        protected void onDispose(@NotNull CopilotClient disposedValue) {
            disposedValue.close();
        }
    };
    private final CopilotProperties properties;
    private volatile CopilotSessionToken sessionToken;

    public CopilotCompletionEngine(CopilotProperties properties) {
        this.properties = properties;
    }

    @Override
    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((CopilotClient)this.client.getInstance()).loadModels(monitor, this.requestSessionToken(monitor).token()).stream().map(model -> CopilotModels.KNOWN_MODELS.getOrDefault(model.id(), new AIModel(model.id(), null, Set.of()))).toList();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.messages().stream().map(CopilotMessage::from).toList()).withTemperature(this.properties.getTemperature()).withStream(false).withIntent(false).withTopP(1).withN(1).build();
        List<String> choices = ((CopilotClient)this.client.getInstance()).chat(monitor, this.requestSessionToken(monitor).token(), chatRequest).choices().stream().map(it -> it.message().content()).toList();
        return new AIEngineResponse(choices);
    }

    @Override
    @NotNull
    public Flow.Publisher<AIEngineResponseChunk> requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.messages().stream().map(CopilotMessage::from).toList()).withTemperature(this.properties.getTemperature()).withStream(true).withIntent(false).withTopP(1).withN(1).build();
        Flow.Publisher<CopilotChatChunk> chunkPublisher = ((CopilotClient)this.client.getInstance()).createChatCompletionStream(monitor, this.requestSessionToken(monitor).token(), chatRequest);
        return subscriber -> chunkPublisher.subscribe(new Flow.Subscriber<CopilotChatChunk>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(CopilotChatChunk chunk) {
                List<String> choices = chunk.choices().stream().takeWhile(it -> it.delta().content() != null).map(it -> it.delta().content()).toList();
                subscriber.onNext(new AIEngineResponseChunk(choices));
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    @Override
    public int getContextWindowSize(DBRProgressMonitor monitor) throws DBException {
        Integer contextWindowSize = this.properties.getContextWindowSize();
        if (contextWindowSize != null) {
            return contextWindowSize;
        }
        throw new DBException("Context window size is not defined in Copilot properties. Please set it explicitly or use a known model with a predefined context window size.");
    }

    @Override
    public void close() throws DBException {
        this.client.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CopilotSessionToken requestSessionToken(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sessionToken != null) {
            return this.sessionToken;
        }
        CopilotCompletionEngine copilotCompletionEngine = this;
        synchronized (copilotCompletionEngine) {
            if (this.sessionToken != null) {
                return this.sessionToken;
            }
            return ((CopilotClient)this.client.getInstance()).requestSessionToken(monitor, this.properties.getToken());
        }
    }

    public String getModelName() throws DBException {
        return CommonUtils.toString((Object)this.properties.getModel(), (String)"gpt-4o");
    }
}

