/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.legacy;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptGenerateSql;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.AIUIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIFeatures;
import org.jkiss.dbeaver.ui.ai.legacy.AISuggestionPopup;
import org.jkiss.dbeaver.ui.ai.legacy.InMemoryHistoryManager;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.utils.CommonUtils;

public class AILegacyTranslator {
    /*
     * WARNING - void declaration
     */
    public void performAiTranslation(ExecutionEvent event) {
        void editor;
        AIFeatures.SQL_AI_POPUP.use();
        if (AISettingsManager.getInstance().getSettings().isAiDisabled()) {
            return;
        }
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(iEditorPart instanceof SQLEditor)) {
            return;
        }
        SQLEditor sQLEditor = (SQLEditor)iEditorPart;
        DBPDataSourceContainer dataSourceContainer = editor.getDataSourceContainer();
        if (dataSourceContainer == null) {
            DBWorkbench.getPlatformUI().showError("No datasource", "Connection must be associated with the SQL script");
            return;
        }
        DBCExecutionContext executionContext = editor.getExecutionContext();
        if (executionContext == null) {
            DBWorkbench.getPlatformUI().showError("No connection", "You must connect to the database before performing completion");
            return;
        }
        try {
            if (!AIUtils.hasValidConfiguration()) {
                UIUtils.showPreferencesFor((Shell)editor.getSite().getShell(), (Object)AISettingsManager.getInstance().getSettings(), (String[])new String[]{"org.jkiss.dbeaver.preferences.ai"});
                return;
            }
            AICompletionSettings settings = new AICompletionSettings(dataSourceContainer);
            if (!AIUIUtils.confirmMetaTransfer((AIContextSettings)settings)) {
                return;
            }
            DBSLogicalDataSource lDataSource = DBSLogicalDataSource.createLogicalDataSource((DBPDataSourceContainer)dataSourceContainer, (DBCExecutionContext)executionContext);
            AISuggestionPopup aiCompletionPopup = new AISuggestionPopup(HandlerUtil.getActiveShell((ExecutionEvent)event), "AI smart completion", lDataSource, executionContext, settings);
            if (aiCompletionPopup.open() == 0) {
                this.doAutoCompletion(executionContext, lDataSource, (SQLEditor)editor, aiCompletionPopup);
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("AI error", "Cannot determine AI engine", (Throwable)e);
        }
    }

    private void doAutoCompletion(@NotNull DBCExecutionContext executionContext, @NotNull DBSLogicalDataSource dataSource, @NotNull SQLEditor editor, @NotNull AISuggestionPopup popup) {
        String userInput = popup.getInputText();
        try {
            String sql = this.translateUserInputIntoSql(userInput, dataSource, executionContext, popup);
            if (sql == null || sql.isEmpty()) {
                DBWorkbench.getPlatformUI().showError("AI error", "No smart completions returned");
                return;
            }
            InMemoryHistoryManager.saveTranslationHistory(dataSource, new QMTranslationHistoryItem(userInput, sql));
            this.insertSqlCompletion(editor, sql);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Auto completion error", null, e.getTargetException());
            return;
        }
        AIFeatures.SQL_AI_GENERATE_PROPOSALS.use(Map.of("driver", dataSource.getDataSourceContainer().getDriver().getPreconfiguredId(), "scope", popup.getScope().name()));
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.executeImmediately")) {
            editor.processSQL(false, false);
        }
    }

    @Nullable
    private String translateUserInputIntoSql(@NotNull String userInput, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull AISuggestionPopup popup) throws InvocationTargetException {
        if (CommonUtils.isEmptyTrimmed((String)userInput)) {
            return null;
        }
        AtomicReference sql = new AtomicReference();
        UIUtils.runInProgressDialog(monitor -> {
            try {
                AIDatabaseContext dbContext = new AIDatabaseContext.Builder(dataSource).setScope(popup.getScope()).setCustomEntities(popup.getCustomEntities(monitor)).setExecutionContext(executionContext).build();
                DBPWorkspace workspace = executionContext.getDataSource().getContainer().getProject().getWorkspace();
                AIAssistant aiAssistant = AIAssistantRegistry.getInstance().createAssistant(workspace);
                AIPromptGenerateSql sysPromptBuilder = AIPromptGenerateSql.create(() -> ((AIDatabaseContext)dbContext).getDataSource());
                AIMessage userMessage = AIMessage.userMessage((String)userInput);
                String result = aiAssistant.generateText(monitor, dbContext, (AIPromptGenerator)sysPromptBuilder, List.of(userMessage));
                String finalText = AITextUtils.extractGeneratedSqlQuery((DBRProgressMonitor)monitor, (AIDatabaseContext)dbContext, (AIMessage)userMessage, (String)result);
                sql.set(finalText);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        });
        return (String)sql.get();
    }

    private void insertSqlCompletion(SQLEditor editor, String completion) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        IDocument document = editor.getDocument();
        if (document != null && selection instanceof TextSelection) {
            try {
                int offset = ((TextSelection)selection).getOffset();
                int length = ((TextSelection)selection).getLength();
                SQLScriptElement query = editor.extractQueryAtPos(offset);
                String text = completion;
                if (query != null) {
                    offset = query.getOffset();
                    length = query.getLength();
                    if (length > 0 && !query.getText().endsWith(";") && !text.isEmpty() && text.charAt(text.length() - 1) == ';') {
                        text = text.substring(0, text.length() - 1);
                    }
                }
                document.replace(offset, length, text);
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + text.length(), 0));
            }
            catch (BadLocationException e) {
                DBWorkbench.getPlatformUI().showError("Insert SQL", "Error inserting SQL completion in text editor", (Throwable)e);
            }
        }
    }
}

